/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum OcsfNumberField {
    ACTIVITY_ID("activity_id"),

    COMPLIANCE_STATUS_ID("compliance.status_id"),

    CONFIDENCE_SCORE("confidence_score"),

    SEVERITY_ID("severity_id"),

    STATUS_ID("status_id"),

    FINDING_INFO_RELATED_EVENTS_COUNT("finding_info.related_events_count"),

    EVIDENCES_API_RESPONSE_CODE("evidences.api.response.code"),

    EVIDENCES_DST_ENDPOINT_AUTONOMOUS_SYSTEM_NUMBER("evidences.dst_endpoint.autonomous_system.number"),

    EVIDENCES_DST_ENDPOINT_PORT("evidences.dst_endpoint.port"),

    EVIDENCES_SRC_ENDPOINT_AUTONOMOUS_SYSTEM_NUMBER("evidences.src_endpoint.autonomous_system.number"),

    EVIDENCES_SRC_ENDPOINT_PORT("evidences.src_endpoint.port"),

    RESOURCES_IMAGE_IN_USE_COUNT("resources.image.in_use_count"),

    VULNERABILITIES_CVE_CVSS_BASE_SCORE("vulnerabilities.cve.cvss.base_score"),

    VENDOR_ATTRIBUTES_SEVERITY_ID("vendor_attributes.severity_id"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OcsfNumberField> VALUE_MAP = EnumUtils.uniqueIndex(OcsfNumberField.class,
            OcsfNumberField::toString);

    private final String value;

    private OcsfNumberField(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return OcsfNumberField corresponding to the value
     */
    public static OcsfNumberField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link OcsfNumberField}s
     */
    public static Set<OcsfNumberField> knownValues() {
        Set<OcsfNumberField> knownValues = EnumSet.allOf(OcsfNumberField.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
