/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a standard to identify security findings using OCSF.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OcsfFindingIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<OcsfFindingIdentifier.Builder, OcsfFindingIdentifier> {
    private static final SdkField<String> CLOUD_ACCOUNT_UID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudAccountUid").getter(getter(OcsfFindingIdentifier::cloudAccountUid))
            .setter(setter(Builder::cloudAccountUid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudAccountUid").build()).build();

    private static final SdkField<String> FINDING_INFO_UID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FindingInfoUid").getter(getter(OcsfFindingIdentifier::findingInfoUid))
            .setter(setter(Builder::findingInfoUid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingInfoUid").build()).build();

    private static final SdkField<String> METADATA_PRODUCT_UID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataProductUid").getter(getter(OcsfFindingIdentifier::metadataProductUid))
            .setter(setter(Builder::metadataProductUid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProductUid").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_ACCOUNT_UID_FIELD,
            FINDING_INFO_UID_FIELD, METADATA_PRODUCT_UID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cloudAccountUid;

    private final String findingInfoUid;

    private final String metadataProductUid;

    private OcsfFindingIdentifier(BuilderImpl builder) {
        this.cloudAccountUid = builder.cloudAccountUid;
        this.findingInfoUid = builder.findingInfoUid;
        this.metadataProductUid = builder.metadataProductUid;
    }

    /**
     * <p>
     * Finding cloud.account.uid, which is a unique identifier in the Amazon Web Services account..
     * </p>
     * 
     * @return Finding cloud.account.uid, which is a unique identifier in the Amazon Web Services account..
     */
    public final String cloudAccountUid() {
        return cloudAccountUid;
    }

    /**
     * <p>
     * Finding finding_info.uid, which is a unique identifier for the finding from the finding provider.
     * </p>
     * 
     * @return Finding finding_info.uid, which is a unique identifier for the finding from the finding provider.
     */
    public final String findingInfoUid() {
        return findingInfoUid;
    }

    /**
     * <p>
     * Finding metadata.product.uid, which is a unique identifier for the product.
     * </p>
     * 
     * @return Finding metadata.product.uid, which is a unique identifier for the product.
     */
    public final String metadataProductUid() {
        return metadataProductUid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudAccountUid());
        hashCode = 31 * hashCode + Objects.hashCode(findingInfoUid());
        hashCode = 31 * hashCode + Objects.hashCode(metadataProductUid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OcsfFindingIdentifier)) {
            return false;
        }
        OcsfFindingIdentifier other = (OcsfFindingIdentifier) obj;
        return Objects.equals(cloudAccountUid(), other.cloudAccountUid())
                && Objects.equals(findingInfoUid(), other.findingInfoUid())
                && Objects.equals(metadataProductUid(), other.metadataProductUid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OcsfFindingIdentifier").add("CloudAccountUid", cloudAccountUid())
                .add("FindingInfoUid", findingInfoUid()).add("MetadataProductUid", metadataProductUid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudAccountUid":
            return Optional.ofNullable(clazz.cast(cloudAccountUid()));
        case "FindingInfoUid":
            return Optional.ofNullable(clazz.cast(findingInfoUid()));
        case "MetadataProductUid":
            return Optional.ofNullable(clazz.cast(metadataProductUid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CloudAccountUid", CLOUD_ACCOUNT_UID_FIELD);
        map.put("FindingInfoUid", FINDING_INFO_UID_FIELD);
        map.put("MetadataProductUid", METADATA_PRODUCT_UID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OcsfFindingIdentifier, T> g) {
        return obj -> g.apply((OcsfFindingIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OcsfFindingIdentifier> {
        /**
         * <p>
         * Finding cloud.account.uid, which is a unique identifier in the Amazon Web Services account..
         * </p>
         * 
         * @param cloudAccountUid
         *        Finding cloud.account.uid, which is a unique identifier in the Amazon Web Services account..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudAccountUid(String cloudAccountUid);

        /**
         * <p>
         * Finding finding_info.uid, which is a unique identifier for the finding from the finding provider.
         * </p>
         * 
         * @param findingInfoUid
         *        Finding finding_info.uid, which is a unique identifier for the finding from the finding provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingInfoUid(String findingInfoUid);

        /**
         * <p>
         * Finding metadata.product.uid, which is a unique identifier for the product.
         * </p>
         * 
         * @param metadataProductUid
         *        Finding metadata.product.uid, which is a unique identifier for the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataProductUid(String metadataProductUid);
    }

    static final class BuilderImpl implements Builder {
        private String cloudAccountUid;

        private String findingInfoUid;

        private String metadataProductUid;

        private BuilderImpl() {
        }

        private BuilderImpl(OcsfFindingIdentifier model) {
            cloudAccountUid(model.cloudAccountUid);
            findingInfoUid(model.findingInfoUid);
            metadataProductUid(model.metadataProductUid);
        }

        public final String getCloudAccountUid() {
            return cloudAccountUid;
        }

        public final void setCloudAccountUid(String cloudAccountUid) {
            this.cloudAccountUid = cloudAccountUid;
        }

        @Override
        public final Builder cloudAccountUid(String cloudAccountUid) {
            this.cloudAccountUid = cloudAccountUid;
            return this;
        }

        public final String getFindingInfoUid() {
            return findingInfoUid;
        }

        public final void setFindingInfoUid(String findingInfoUid) {
            this.findingInfoUid = findingInfoUid;
        }

        @Override
        public final Builder findingInfoUid(String findingInfoUid) {
            this.findingInfoUid = findingInfoUid;
            return this;
        }

        public final String getMetadataProductUid() {
            return metadataProductUid;
        }

        public final void setMetadataProductUid(String metadataProductUid) {
            this.metadataProductUid = metadataProductUid;
        }

        @Override
        public final Builder metadataProductUid(String metadataProductUid) {
            this.metadataProductUid = metadataProductUid;
            return this;
        }

        @Override
        public OcsfFindingIdentifier build() {
            return new OcsfFindingIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
