/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a network path component that occurs before or after the current component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkHeader implements SdkPojo, Serializable, ToCopyableBuilder<NetworkHeader.Builder, NetworkHeader> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(NetworkHeader::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<NetworkPathComponentDetails> DESTINATION_FIELD = SdkField
            .<NetworkPathComponentDetails> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(NetworkHeader::destination)).setter(setter(Builder::destination))
            .constructor(NetworkPathComponentDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<NetworkPathComponentDetails> SOURCE_FIELD = SdkField
            .<NetworkPathComponentDetails> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(NetworkHeader::source)).setter(setter(Builder::source))
            .constructor(NetworkPathComponentDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD,
            DESTINATION_FIELD, SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String protocol;

    private final NetworkPathComponentDetails destination;

    private final NetworkPathComponentDetails source;

    private NetworkHeader(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.destination = builder.destination;
        this.source = builder.source;
    }

    /**
     * <p>
     * The protocol used for the component.
     * </p>
     * <p>
     * Length Constraints: Minimum of 1. Maximum of 16.
     * </p>
     * 
     * @return The protocol used for the component.</p>
     *         <p>
     *         Length Constraints: Minimum of 1. Maximum of 16.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * Information about the destination of the component.
     * </p>
     * 
     * @return Information about the destination of the component.
     */
    public final NetworkPathComponentDetails destination() {
        return destination;
    }

    /**
     * <p>
     * Information about the origin of the component.
     * </p>
     * 
     * @return Information about the origin of the component.
     */
    public final NetworkPathComponentDetails source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkHeader)) {
            return false;
        }
        NetworkHeader other = (NetworkHeader) obj;
        return Objects.equals(protocol(), other.protocol()) && Objects.equals(destination(), other.destination())
                && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkHeader").add("Protocol", protocol()).add("Destination", destination())
                .add("Source", source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("Source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkHeader, T> g) {
        return obj -> g.apply((NetworkHeader) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkHeader> {
        /**
         * <p>
         * The protocol used for the component.
         * </p>
         * <p>
         * Length Constraints: Minimum of 1. Maximum of 16.
         * </p>
         * 
         * @param protocol
         *        The protocol used for the component.</p>
         *        <p>
         *        Length Constraints: Minimum of 1. Maximum of 16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * Information about the destination of the component.
         * </p>
         * 
         * @param destination
         *        Information about the destination of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(NetworkPathComponentDetails destination);

        /**
         * <p>
         * Information about the destination of the component.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkPathComponentDetails.Builder}
         * avoiding the need to create one manually via {@link NetworkPathComponentDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkPathComponentDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #destination(NetworkPathComponentDetails)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link NetworkPathComponentDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(NetworkPathComponentDetails)
         */
        default Builder destination(Consumer<NetworkPathComponentDetails.Builder> destination) {
            return destination(NetworkPathComponentDetails.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * Information about the origin of the component.
         * </p>
         * 
         * @param source
         *        Information about the origin of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(NetworkPathComponentDetails source);

        /**
         * <p>
         * Information about the origin of the component.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkPathComponentDetails.Builder}
         * avoiding the need to create one manually via {@link NetworkPathComponentDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkPathComponentDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #source(NetworkPathComponentDetails)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link NetworkPathComponentDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(NetworkPathComponentDetails)
         */
        default Builder source(Consumer<NetworkPathComponentDetails.Builder> source) {
            return source(NetworkPathComponentDetails.builder().applyMutation(source).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String protocol;

        private NetworkPathComponentDetails destination;

        private NetworkPathComponentDetails source;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkHeader model) {
            protocol(model.protocol);
            destination(model.destination);
            source(model.source);
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final NetworkPathComponentDetails.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(NetworkPathComponentDetails.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(NetworkPathComponentDetails destination) {
            this.destination = destination;
            return this;
        }

        public final NetworkPathComponentDetails.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(NetworkPathComponentDetails.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(NetworkPathComponentDetails source) {
            this.source = source;
            return this;
        }

        @Override
        public NetworkHeader build() {
            return new NetworkHeader(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
