/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecurityControlDefinitionsResponse extends SecurityHubResponse implements
        ToCopyableBuilder<ListSecurityControlDefinitionsResponse.Builder, ListSecurityControlDefinitionsResponse> {
    private static final SdkField<List<SecurityControlDefinition>> SECURITY_CONTROL_DEFINITIONS_FIELD = SdkField
            .<List<SecurityControlDefinition>> builder(MarshallingType.LIST)
            .memberName("SecurityControlDefinitions")
            .getter(getter(ListSecurityControlDefinitionsResponse::securityControlDefinitions))
            .setter(setter(Builder::securityControlDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityControlDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityControlDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSecurityControlDefinitionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SECURITY_CONTROL_DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SecurityControlDefinition> securityControlDefinitions;

    private final String nextToken;

    private ListSecurityControlDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.securityControlDefinitions = builder.securityControlDefinitions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityControlDefinitions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecurityControlDefinitions() {
        return securityControlDefinitions != null && !(securityControlDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of controls that apply to the specified standard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityControlDefinitions} method.
     * </p>
     * 
     * @return An array of controls that apply to the specified standard.
     */
    public final List<SecurityControlDefinition> securityControlDefinitions() {
        return securityControlDefinitions;
    }

    /**
     * <p>
     * A pagination parameter that's included in the response only if it was included in the request.
     * </p>
     * 
     * @return A pagination parameter that's included in the response only if it was included in the request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityControlDefinitions() ? securityControlDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityControlDefinitionsResponse)) {
            return false;
        }
        ListSecurityControlDefinitionsResponse other = (ListSecurityControlDefinitionsResponse) obj;
        return hasSecurityControlDefinitions() == other.hasSecurityControlDefinitions()
                && Objects.equals(securityControlDefinitions(), other.securityControlDefinitions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSecurityControlDefinitionsResponse")
                .add("SecurityControlDefinitions", hasSecurityControlDefinitions() ? securityControlDefinitions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityControlDefinitions":
            return Optional.ofNullable(clazz.cast(securityControlDefinitions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecurityControlDefinitions", SECURITY_CONTROL_DEFINITIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityControlDefinitionsResponse, T> g) {
        return obj -> g.apply((ListSecurityControlDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSecurityControlDefinitionsResponse> {
        /**
         * <p>
         * An array of controls that apply to the specified standard.
         * </p>
         * 
         * @param securityControlDefinitions
         *        An array of controls that apply to the specified standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControlDefinitions(Collection<SecurityControlDefinition> securityControlDefinitions);

        /**
         * <p>
         * An array of controls that apply to the specified standard.
         * </p>
         * 
         * @param securityControlDefinitions
         *        An array of controls that apply to the specified standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControlDefinitions(SecurityControlDefinition... securityControlDefinitions);

        /**
         * <p>
         * An array of controls that apply to the specified standard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.SecurityControlDefinition.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.SecurityControlDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.SecurityControlDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #securityControlDefinitions(List<SecurityControlDefinition>)}.
         * 
         * @param securityControlDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.SecurityControlDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityControlDefinitions(java.util.Collection<SecurityControlDefinition>)
         */
        Builder securityControlDefinitions(Consumer<SecurityControlDefinition.Builder>... securityControlDefinitions);

        /**
         * <p>
         * A pagination parameter that's included in the response only if it was included in the request.
         * </p>
         * 
         * @param nextToken
         *        A pagination parameter that's included in the response only if it was included in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<SecurityControlDefinition> securityControlDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityControlDefinitionsResponse model) {
            super(model);
            securityControlDefinitions(model.securityControlDefinitions);
            nextToken(model.nextToken);
        }

        public final List<SecurityControlDefinition.Builder> getSecurityControlDefinitions() {
            List<SecurityControlDefinition.Builder> result = SecurityControlDefinitionsCopier
                    .copyToBuilder(this.securityControlDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityControlDefinitions(
                Collection<SecurityControlDefinition.BuilderImpl> securityControlDefinitions) {
            this.securityControlDefinitions = SecurityControlDefinitionsCopier.copyFromBuilder(securityControlDefinitions);
        }

        @Override
        public final Builder securityControlDefinitions(Collection<SecurityControlDefinition> securityControlDefinitions) {
            this.securityControlDefinitions = SecurityControlDefinitionsCopier.copy(securityControlDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityControlDefinitions(SecurityControlDefinition... securityControlDefinitions) {
            securityControlDefinitions(Arrays.asList(securityControlDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityControlDefinitions(Consumer<SecurityControlDefinition.Builder>... securityControlDefinitions) {
            securityControlDefinitions(Stream.of(securityControlDefinitions)
                    .map(c -> SecurityControlDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSecurityControlDefinitionsResponse build() {
            return new ListSecurityControlDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
