/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMembersRequest extends SecurityHubRequest implements
        ToCopyableBuilder<ListMembersRequest.Builder, ListMembersRequest> {
    private static final SdkField<Boolean> ONLY_ASSOCIATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OnlyAssociated").getter(getter(ListMembersRequest::onlyAssociated))
            .setter(setter(Builder::onlyAssociated))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OnlyAssociated").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListMembersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMembersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ONLY_ASSOCIATED_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean onlyAssociated;

    private final Integer maxResults;

    private final String nextToken;

    private ListMembersRequest(BuilderImpl builder) {
        super(builder);
        this.onlyAssociated = builder.onlyAssociated;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Specifies which member accounts to include in the response based on their relationship status with the
     * administrator account. The default value is <code>TRUE</code>.
     * </p>
     * <p>
     * If <code>OnlyAssociated</code> is set to <code>TRUE</code>, the response includes member accounts whose
     * relationship status with the administrator account is set to <code>ENABLED</code>.
     * </p>
     * <p>
     * If <code>OnlyAssociated</code> is set to <code>FALSE</code>, the response includes all existing member accounts.
     * </p>
     * 
     * @return Specifies which member accounts to include in the response based on their relationship status with the
     *         administrator account. The default value is <code>TRUE</code>.</p>
     *         <p>
     *         If <code>OnlyAssociated</code> is set to <code>TRUE</code>, the response includes member accounts whose
     *         relationship status with the administrator account is set to <code>ENABLED</code>.
     *         </p>
     *         <p>
     *         If <code>OnlyAssociated</code> is set to <code>FALSE</code>, the response includes all existing member
     *         accounts.
     */
    public final Boolean onlyAssociated() {
        return onlyAssociated;
    }

    /**
     * <p>
     * The maximum number of items to return in the response.
     * </p>
     * 
     * @return The maximum number of items to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token that is required for pagination. On your first call to the <code>ListMembers</code> operation, set the
     * value of this parameter to <code>NULL</code>.
     * </p>
     * <p>
     * For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value
     * returned from the previous response.
     * </p>
     * 
     * @return The token that is required for pagination. On your first call to the <code>ListMembers</code> operation,
     *         set the value of this parameter to <code>NULL</code>.</p>
     *         <p>
     *         For subsequent calls to the operation, to continue listing data, set the value of this parameter to the
     *         value returned from the previous response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(onlyAssociated());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembersRequest)) {
            return false;
        }
        ListMembersRequest other = (ListMembersRequest) obj;
        return Objects.equals(onlyAssociated(), other.onlyAssociated()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMembersRequest").add("OnlyAssociated", onlyAssociated()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OnlyAssociated":
            return Optional.ofNullable(clazz.cast(onlyAssociated()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OnlyAssociated", ONLY_ASSOCIATED_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMembersRequest, T> g) {
        return obj -> g.apply((ListMembersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListMembersRequest> {
        /**
         * <p>
         * Specifies which member accounts to include in the response based on their relationship status with the
         * administrator account. The default value is <code>TRUE</code>.
         * </p>
         * <p>
         * If <code>OnlyAssociated</code> is set to <code>TRUE</code>, the response includes member accounts whose
         * relationship status with the administrator account is set to <code>ENABLED</code>.
         * </p>
         * <p>
         * If <code>OnlyAssociated</code> is set to <code>FALSE</code>, the response includes all existing member
         * accounts.
         * </p>
         * 
         * @param onlyAssociated
         *        Specifies which member accounts to include in the response based on their relationship status with the
         *        administrator account. The default value is <code>TRUE</code>.</p>
         *        <p>
         *        If <code>OnlyAssociated</code> is set to <code>TRUE</code>, the response includes member accounts
         *        whose relationship status with the administrator account is set to <code>ENABLED</code>.
         *        </p>
         *        <p>
         *        If <code>OnlyAssociated</code> is set to <code>FALSE</code>, the response includes all existing member
         *        accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onlyAssociated(Boolean onlyAssociated);

        /**
         * <p>
         * The maximum number of items to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token that is required for pagination. On your first call to the <code>ListMembers</code> operation, set
         * the value of this parameter to <code>NULL</code>.
         * </p>
         * <p>
         * For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value
         * returned from the previous response.
         * </p>
         * 
         * @param nextToken
         *        The token that is required for pagination. On your first call to the <code>ListMembers</code>
         *        operation, set the value of this parameter to <code>NULL</code>.</p>
         *        <p>
         *        For subsequent calls to the operation, to continue listing data, set the value of this parameter to
         *        the value returned from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private Boolean onlyAssociated;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembersRequest model) {
            super(model);
            onlyAssociated(model.onlyAssociated);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Boolean getOnlyAssociated() {
            return onlyAssociated;
        }

        public final void setOnlyAssociated(Boolean onlyAssociated) {
            this.onlyAssociated = onlyAssociated;
        }

        @Override
        public final Builder onlyAssociated(Boolean onlyAssociated) {
            this.onlyAssociated = onlyAssociated;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMembersRequest build() {
            return new ListMembersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
