/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationPolicyAssociationsRequest extends SecurityHubRequest implements
        ToCopyableBuilder<ListConfigurationPolicyAssociationsRequest.Builder, ListConfigurationPolicyAssociationsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConfigurationPolicyAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListConfigurationPolicyAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<AssociationFilters> FILTERS_FIELD = SdkField
            .<AssociationFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(ListConfigurationPolicyAssociationsRequest::filters)).setter(setter(Builder::filters))
            .constructor(AssociationFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final AssociationFilters filters;

    private ListConfigurationPolicyAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The <code>NextToken</code> value that's returned from a previous paginated
     * <code>ListConfigurationPolicyAssociations</code> request where <code>MaxResults</code> was used but the results
     * exceeded the value of that parameter. Pagination continues from the end of the previous response that returned
     * the <code>NextToken</code> value. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>NextToken</code> value that's returned from a previous paginated
     *         <code>ListConfigurationPolicyAssociations</code> request where <code>MaxResults</code> was used but the
     *         results exceeded the value of that parameter. Pagination continues from the end of the previous response
     *         that returned the <code>NextToken</code> value. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results that's returned by <code>ListConfigurationPolicies</code> in each page of the
     * response. When this parameter is used, <code>ListConfigurationPolicyAssociations</code> returns the specified
     * number of results in a single page and a <code>NextToken</code> response element. You can see the remaining
     * results of the initial request by sending another <code>ListConfigurationPolicyAssociations</code> request with
     * the returned <code>NextToken</code> value. A valid range for <code>MaxResults</code> is between 1 and 100.
     * </p>
     * 
     * @return The maximum number of results that's returned by <code>ListConfigurationPolicies</code> in each page of
     *         the response. When this parameter is used, <code>ListConfigurationPolicyAssociations</code> returns the
     *         specified number of results in a single page and a <code>NextToken</code> response element. You can see
     *         the remaining results of the initial request by sending another
     *         <code>ListConfigurationPolicyAssociations</code> request with the returned <code>NextToken</code> value.
     *         A valid range for <code>MaxResults</code> is between 1 and 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Options for filtering the <code>ListConfigurationPolicyAssociations</code> response. You can filter by the Amazon
     * Resource Name (ARN) or universally unique identifier (UUID) of a configuration, <code>AssociationType</code>, or
     * <code>AssociationStatus</code>.
     * </p>
     * 
     * @return Options for filtering the <code>ListConfigurationPolicyAssociations</code> response. You can filter by
     *         the Amazon Resource Name (ARN) or universally unique identifier (UUID) of a configuration,
     *         <code>AssociationType</code>, or <code>AssociationStatus</code>.
     */
    public final AssociationFilters filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationPolicyAssociationsRequest)) {
            return false;
        }
        ListConfigurationPolicyAssociationsRequest other = (ListConfigurationPolicyAssociationsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConfigurationPolicyAssociationsRequest").add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Filters", filters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationPolicyAssociationsRequest, T> g) {
        return obj -> g.apply((ListConfigurationPolicyAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfigurationPolicyAssociationsRequest> {
        /**
         * <p>
         * The <code>NextToken</code> value that's returned from a previous paginated
         * <code>ListConfigurationPolicyAssociations</code> request where <code>MaxResults</code> was used but the
         * results exceeded the value of that parameter. Pagination continues from the end of the previous response that
         * returned the <code>NextToken</code> value. This value is <code>null</code> when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value that's returned from a previous paginated
         *        <code>ListConfigurationPolicyAssociations</code> request where <code>MaxResults</code> was used but
         *        the results exceeded the value of that parameter. Pagination continues from the end of the previous
         *        response that returned the <code>NextToken</code> value. This value is <code>null</code> when there
         *        are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results that's returned by <code>ListConfigurationPolicies</code> in each page of the
         * response. When this parameter is used, <code>ListConfigurationPolicyAssociations</code> returns the specified
         * number of results in a single page and a <code>NextToken</code> response element. You can see the remaining
         * results of the initial request by sending another <code>ListConfigurationPolicyAssociations</code> request
         * with the returned <code>NextToken</code> value. A valid range for <code>MaxResults</code> is between 1 and
         * 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results that's returned by <code>ListConfigurationPolicies</code> in each page
         *        of the response. When this parameter is used, <code>ListConfigurationPolicyAssociations</code> returns
         *        the specified number of results in a single page and a <code>NextToken</code> response element. You
         *        can see the remaining results of the initial request by sending another
         *        <code>ListConfigurationPolicyAssociations</code> request with the returned <code>NextToken</code>
         *        value. A valid range for <code>MaxResults</code> is between 1 and 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Options for filtering the <code>ListConfigurationPolicyAssociations</code> response. You can filter by the
         * Amazon Resource Name (ARN) or universally unique identifier (UUID) of a configuration,
         * <code>AssociationType</code>, or <code>AssociationStatus</code>.
         * </p>
         * 
         * @param filters
         *        Options for filtering the <code>ListConfigurationPolicyAssociations</code> response. You can filter by
         *        the Amazon Resource Name (ARN) or universally unique identifier (UUID) of a configuration,
         *        <code>AssociationType</code>, or <code>AssociationStatus</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(AssociationFilters filters);

        /**
         * <p>
         * Options for filtering the <code>ListConfigurationPolicyAssociations</code> response. You can filter by the
         * Amazon Resource Name (ARN) or universally unique identifier (UUID) of a configuration,
         * <code>AssociationType</code>, or <code>AssociationStatus</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssociationFilters.Builder} avoiding the
         * need to create one manually via {@link AssociationFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssociationFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(AssociationFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link AssociationFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(AssociationFilters)
         */
        default Builder filters(Consumer<AssociationFilters.Builder> filters) {
            return filters(AssociationFilters.builder().applyMutation(filters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private AssociationFilters filters;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationPolicyAssociationsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final AssociationFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(AssociationFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(AssociationFilters filters) {
            this.filters = filters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConfigurationPolicyAssociationsRequest build() {
            return new ListConfigurationPolicyAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
