/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The insight results returned by the <code>GetInsightResults</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightResults implements SdkPojo, Serializable, ToCopyableBuilder<InsightResults.Builder, InsightResults> {
    private static final SdkField<String> INSIGHT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InsightArn").getter(getter(InsightResults::insightArn)).setter(setter(Builder::insightArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightArn").build()).build();

    private static final SdkField<String> GROUP_BY_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupByAttribute").getter(getter(InsightResults::groupByAttribute))
            .setter(setter(Builder::groupByAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByAttribute").build()).build();

    private static final SdkField<List<InsightResultValue>> RESULT_VALUES_FIELD = SdkField
            .<List<InsightResultValue>> builder(MarshallingType.LIST)
            .memberName("ResultValues")
            .getter(getter(InsightResults::resultValues))
            .setter(setter(Builder::resultValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InsightResultValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(InsightResultValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ARN_FIELD,
            GROUP_BY_ATTRIBUTE_FIELD, RESULT_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String insightArn;

    private final String groupByAttribute;

    private final List<InsightResultValue> resultValues;

    private InsightResults(BuilderImpl builder) {
        this.insightArn = builder.insightArn;
        this.groupByAttribute = builder.groupByAttribute;
        this.resultValues = builder.resultValues;
    }

    /**
     * <p>
     * The ARN of the insight whose results are returned by the <code>GetInsightResults</code> operation.
     * </p>
     * 
     * @return The ARN of the insight whose results are returned by the <code>GetInsightResults</code> operation.
     */
    public final String insightArn() {
        return insightArn;
    }

    /**
     * <p>
     * The attribute that the findings are grouped by for the insight whose results are returned by the
     * <code>GetInsightResults</code> operation.
     * </p>
     * 
     * @return The attribute that the findings are grouped by for the insight whose results are returned by the
     *         <code>GetInsightResults</code> operation.
     */
    public final String groupByAttribute() {
        return groupByAttribute;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResultValues() {
        return resultValues != null && !(resultValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of insight result values returned by the <code>GetInsightResults</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultValues} method.
     * </p>
     * 
     * @return The list of insight result values returned by the <code>GetInsightResults</code> operation.
     */
    public final List<InsightResultValue> resultValues() {
        return resultValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(insightArn());
        hashCode = 31 * hashCode + Objects.hashCode(groupByAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(hasResultValues() ? resultValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightResults)) {
            return false;
        }
        InsightResults other = (InsightResults) obj;
        return Objects.equals(insightArn(), other.insightArn()) && Objects.equals(groupByAttribute(), other.groupByAttribute())
                && hasResultValues() == other.hasResultValues() && Objects.equals(resultValues(), other.resultValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightResults").add("InsightArn", insightArn()).add("GroupByAttribute", groupByAttribute())
                .add("ResultValues", hasResultValues() ? resultValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightArn":
            return Optional.ofNullable(clazz.cast(insightArn()));
        case "GroupByAttribute":
            return Optional.ofNullable(clazz.cast(groupByAttribute()));
        case "ResultValues":
            return Optional.ofNullable(clazz.cast(resultValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InsightArn", INSIGHT_ARN_FIELD);
        map.put("GroupByAttribute", GROUP_BY_ATTRIBUTE_FIELD);
        map.put("ResultValues", RESULT_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightResults, T> g) {
        return obj -> g.apply((InsightResults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightResults> {
        /**
         * <p>
         * The ARN of the insight whose results are returned by the <code>GetInsightResults</code> operation.
         * </p>
         * 
         * @param insightArn
         *        The ARN of the insight whose results are returned by the <code>GetInsightResults</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightArn(String insightArn);

        /**
         * <p>
         * The attribute that the findings are grouped by for the insight whose results are returned by the
         * <code>GetInsightResults</code> operation.
         * </p>
         * 
         * @param groupByAttribute
         *        The attribute that the findings are grouped by for the insight whose results are returned by the
         *        <code>GetInsightResults</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByAttribute(String groupByAttribute);

        /**
         * <p>
         * The list of insight result values returned by the <code>GetInsightResults</code> operation.
         * </p>
         * 
         * @param resultValues
         *        The list of insight result values returned by the <code>GetInsightResults</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultValues(Collection<InsightResultValue> resultValues);

        /**
         * <p>
         * The list of insight result values returned by the <code>GetInsightResults</code> operation.
         * </p>
         * 
         * @param resultValues
         *        The list of insight result values returned by the <code>GetInsightResults</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultValues(InsightResultValue... resultValues);

        /**
         * <p>
         * The list of insight result values returned by the <code>GetInsightResults</code> operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.InsightResultValue.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.InsightResultValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.InsightResultValue.Builder#build()} is called
         * immediately and its result is passed to {@link #resultValues(List<InsightResultValue>)}.
         * 
         * @param resultValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.InsightResultValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultValues(java.util.Collection<InsightResultValue>)
         */
        Builder resultValues(Consumer<InsightResultValue.Builder>... resultValues);
    }

    static final class BuilderImpl implements Builder {
        private String insightArn;

        private String groupByAttribute;

        private List<InsightResultValue> resultValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InsightResults model) {
            insightArn(model.insightArn);
            groupByAttribute(model.groupByAttribute);
            resultValues(model.resultValues);
        }

        public final String getInsightArn() {
            return insightArn;
        }

        public final void setInsightArn(String insightArn) {
            this.insightArn = insightArn;
        }

        @Override
        public final Builder insightArn(String insightArn) {
            this.insightArn = insightArn;
            return this;
        }

        public final String getGroupByAttribute() {
            return groupByAttribute;
        }

        public final void setGroupByAttribute(String groupByAttribute) {
            this.groupByAttribute = groupByAttribute;
        }

        @Override
        public final Builder groupByAttribute(String groupByAttribute) {
            this.groupByAttribute = groupByAttribute;
            return this;
        }

        public final List<InsightResultValue.Builder> getResultValues() {
            List<InsightResultValue.Builder> result = InsightResultValueListCopier.copyToBuilder(this.resultValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultValues(Collection<InsightResultValue.BuilderImpl> resultValues) {
            this.resultValues = InsightResultValueListCopier.copyFromBuilder(resultValues);
        }

        @Override
        public final Builder resultValues(Collection<InsightResultValue> resultValues) {
            this.resultValues = InsightResultValueListCopier.copy(resultValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultValues(InsightResultValue... resultValues) {
            resultValues(Arrays.asList(resultValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultValues(Consumer<InsightResultValue.Builder>... resultValues) {
            resultValues(Stream.of(resultValues).map(c -> InsightResultValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public InsightResults build() {
            return new InsightResults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
