/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the operational status and health of a connectorV2.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthCheck implements SdkPojo, Serializable, ToCopyableBuilder<HealthCheck.Builder, HealthCheck> {
    private static final SdkField<String> CONNECTOR_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorStatus").getter(getter(HealthCheck::connectorStatusAsString))
            .setter(setter(Builder::connectorStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorStatus").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(HealthCheck::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> LAST_CHECKED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastCheckedAt")
            .getter(getter(HealthCheck::lastCheckedAt))
            .setter(setter(Builder::lastCheckedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCheckedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_STATUS_FIELD,
            MESSAGE_FIELD, LAST_CHECKED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectorStatus;

    private final String message;

    private final Instant lastCheckedAt;

    private HealthCheck(BuilderImpl builder) {
        this.connectorStatus = builder.connectorStatus;
        this.message = builder.message;
        this.lastCheckedAt = builder.lastCheckedAt;
    }

    /**
     * <p>
     * The status of the connectorV2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorStatus}
     * will return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectorStatusAsString}.
     * </p>
     * 
     * @return The status of the connectorV2.
     * @see ConnectorStatus
     */
    public final ConnectorStatus connectorStatus() {
        return ConnectorStatus.fromValue(connectorStatus);
    }

    /**
     * <p>
     * The status of the connectorV2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorStatus}
     * will return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectorStatusAsString}.
     * </p>
     * 
     * @return The status of the connectorV2.
     * @see ConnectorStatus
     */
    public final String connectorStatusAsString() {
        return connectorStatus;
    }

    /**
     * <p>
     * The message for the reason of connectorStatus change.
     * </p>
     * 
     * @return The message for the reason of connectorStatus change.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * ISO 8601 UTC timestamp for the time check the health status of the connectorV2.
     * </p>
     * 
     * @return ISO 8601 UTC timestamp for the time check the health status of the connectorV2.
     */
    public final Instant lastCheckedAt() {
        return lastCheckedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(lastCheckedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheck)) {
            return false;
        }
        HealthCheck other = (HealthCheck) obj;
        return Objects.equals(connectorStatusAsString(), other.connectorStatusAsString())
                && Objects.equals(message(), other.message()) && Objects.equals(lastCheckedAt(), other.lastCheckedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HealthCheck").add("ConnectorStatus", connectorStatusAsString()).add("Message", message())
                .add("LastCheckedAt", lastCheckedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorStatus":
            return Optional.ofNullable(clazz.cast(connectorStatusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "LastCheckedAt":
            return Optional.ofNullable(clazz.cast(lastCheckedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorStatus", CONNECTOR_STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("LastCheckedAt", LAST_CHECKED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HealthCheck, T> g) {
        return obj -> g.apply((HealthCheck) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HealthCheck> {
        /**
         * <p>
         * The status of the connectorV2.
         * </p>
         * 
         * @param connectorStatus
         *        The status of the connectorV2.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder connectorStatus(String connectorStatus);

        /**
         * <p>
         * The status of the connectorV2.
         * </p>
         * 
         * @param connectorStatus
         *        The status of the connectorV2.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder connectorStatus(ConnectorStatus connectorStatus);

        /**
         * <p>
         * The message for the reason of connectorStatus change.
         * </p>
         * 
         * @param message
         *        The message for the reason of connectorStatus change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * ISO 8601 UTC timestamp for the time check the health status of the connectorV2.
         * </p>
         * 
         * @param lastCheckedAt
         *        ISO 8601 UTC timestamp for the time check the health status of the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastCheckedAt(Instant lastCheckedAt);
    }

    static final class BuilderImpl implements Builder {
        private String connectorStatus;

        private String message;

        private Instant lastCheckedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheck model) {
            connectorStatus(model.connectorStatus);
            message(model.message);
            lastCheckedAt(model.lastCheckedAt);
        }

        public final String getConnectorStatus() {
            return connectorStatus;
        }

        public final void setConnectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
        }

        @Override
        public final Builder connectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
            return this;
        }

        @Override
        public final Builder connectorStatus(ConnectorStatus connectorStatus) {
            this.connectorStatus(connectorStatus == null ? null : connectorStatus.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getLastCheckedAt() {
            return lastCheckedAt;
        }

        public final void setLastCheckedAt(Instant lastCheckedAt) {
            this.lastCheckedAt = lastCheckedAt;
        }

        @Override
        public final Builder lastCheckedAt(Instant lastCheckedAt) {
            this.lastCheckedAt = lastCheckedAt;
            return this;
        }

        @Override
        public HealthCheck build() {
            return new HealthCheck(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
