/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents finding statistics grouped by <code>GroupedByField</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupByResult implements SdkPojo, Serializable, ToCopyableBuilder<GroupByResult.Builder, GroupByResult> {
    private static final SdkField<String> GROUP_BY_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupByField").getter(getter(GroupByResult::groupByField)).setter(setter(Builder::groupByField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByField").build()).build();

    private static final SdkField<List<GroupByValue>> GROUP_BY_VALUES_FIELD = SdkField
            .<List<GroupByValue>> builder(MarshallingType.LIST)
            .memberName("GroupByValues")
            .getter(getter(GroupByResult::groupByValues))
            .setter(setter(Builder::groupByValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupByValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupByValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_FIELD_FIELD,
            GROUP_BY_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupByField;

    private final List<GroupByValue> groupByValues;

    private GroupByResult(BuilderImpl builder) {
        this.groupByField = builder.groupByField;
        this.groupByValues = builder.groupByValues;
    }

    /**
     * <p>
     * The attribute by which filtered security findings should be grouped.
     * </p>
     * 
     * @return The attribute by which filtered security findings should be grouped.
     */
    public final String groupByField() {
        return groupByField;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupByValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupByValues() {
        return groupByValues != null && !(groupByValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of grouped values and their respective counts for each <code>GroupByField</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupByValues} method.
     * </p>
     * 
     * @return An array of grouped values and their respective counts for each <code>GroupByField</code>.
     */
    public final List<GroupByValue> groupByValues() {
        return groupByValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupByField());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupByValues() ? groupByValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupByResult)) {
            return false;
        }
        GroupByResult other = (GroupByResult) obj;
        return Objects.equals(groupByField(), other.groupByField()) && hasGroupByValues() == other.hasGroupByValues()
                && Objects.equals(groupByValues(), other.groupByValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupByResult").add("GroupByField", groupByField())
                .add("GroupByValues", hasGroupByValues() ? groupByValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupByField":
            return Optional.ofNullable(clazz.cast(groupByField()));
        case "GroupByValues":
            return Optional.ofNullable(clazz.cast(groupByValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupByField", GROUP_BY_FIELD_FIELD);
        map.put("GroupByValues", GROUP_BY_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupByResult, T> g) {
        return obj -> g.apply((GroupByResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupByResult> {
        /**
         * <p>
         * The attribute by which filtered security findings should be grouped.
         * </p>
         * 
         * @param groupByField
         *        The attribute by which filtered security findings should be grouped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByField(String groupByField);

        /**
         * <p>
         * An array of grouped values and their respective counts for each <code>GroupByField</code>.
         * </p>
         * 
         * @param groupByValues
         *        An array of grouped values and their respective counts for each <code>GroupByField</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByValues(Collection<GroupByValue> groupByValues);

        /**
         * <p>
         * An array of grouped values and their respective counts for each <code>GroupByField</code>.
         * </p>
         * 
         * @param groupByValues
         *        An array of grouped values and their respective counts for each <code>GroupByField</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByValues(GroupByValue... groupByValues);

        /**
         * <p>
         * An array of grouped values and their respective counts for each <code>GroupByField</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.GroupByValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.GroupByValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.GroupByValue.Builder#build()} is called immediately
         * and its result is passed to {@link #groupByValues(List<GroupByValue>)}.
         * 
         * @param groupByValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.GroupByValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupByValues(java.util.Collection<GroupByValue>)
         */
        Builder groupByValues(Consumer<GroupByValue.Builder>... groupByValues);
    }

    static final class BuilderImpl implements Builder {
        private String groupByField;

        private List<GroupByValue> groupByValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupByResult model) {
            groupByField(model.groupByField);
            groupByValues(model.groupByValues);
        }

        public final String getGroupByField() {
            return groupByField;
        }

        public final void setGroupByField(String groupByField) {
            this.groupByField = groupByField;
        }

        @Override
        public final Builder groupByField(String groupByField) {
            this.groupByField = groupByField;
            return this;
        }

        public final List<GroupByValue.Builder> getGroupByValues() {
            List<GroupByValue.Builder> result = GroupByValuesCopier.copyToBuilder(this.groupByValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByValues(Collection<GroupByValue.BuilderImpl> groupByValues) {
            this.groupByValues = GroupByValuesCopier.copyFromBuilder(groupByValues);
        }

        @Override
        public final Builder groupByValues(Collection<GroupByValue> groupByValues) {
            this.groupByValues = GroupByValuesCopier.copy(groupByValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByValues(GroupByValue... groupByValues) {
            groupByValues(Arrays.asList(groupByValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByValues(Consumer<GroupByValue.Builder>... groupByValues) {
            groupByValues(Stream.of(groupByValues).map(c -> GroupByValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GroupByResult build() {
            return new GroupByResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
