/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum GroupByField {
    ACTIVITY_NAME("activity_name"),

    CLOUD_ACCOUNT_UID("cloud.account.uid"),

    CLOUD_PROVIDER("cloud.provider"),

    CLOUD_REGION("cloud.region"),

    COMPLIANCE_ASSESSMENTS_NAME("compliance.assessments.name"),

    COMPLIANCE_STATUS("compliance.status"),

    COMPLIANCE_CONTROL("compliance.control"),

    FINDING_INFO_TITLE("finding_info.title"),

    FINDING_INFO_RELATED_EVENTS_TRAITS_CATEGORY("finding_info.related_events.traits.category"),

    FINDING_INFO_TYPES("finding_info.types"),

    METADATA_PRODUCT_NAME("metadata.product.name"),

    METADATA_PRODUCT_UID("metadata.product.uid"),

    RESOURCES_TYPE("resources.type"),

    RESOURCES_UID("resources.uid"),

    SEVERITY("severity"),

    STATUS("status"),

    VULNERABILITIES_FIX_COVERAGE("vulnerabilities.fix_coverage"),

    CLASS_NAME("class_name"),

    VULNERABILITIES_AFFECTED_PACKAGES_NAME("vulnerabilities.affected_packages.name"),

    FINDING_INFO_ANALYTIC_NAME("finding_info.analytic.name"),

    COMPLIANCE_STANDARDS("compliance.standards"),

    CLOUD_ACCOUNT_NAME("cloud.account.name"),

    VENDOR_ATTRIBUTES_SEVERITY("vendor_attributes.severity"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GroupByField> VALUE_MAP = EnumUtils.uniqueIndex(GroupByField.class, GroupByField::toString);

    private final String value;

    private GroupByField(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return GroupByField corresponding to the value
     */
    public static GroupByField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link GroupByField}s
     */
    public static Set<GroupByField> knownValues() {
        Set<GroupByField> knownValues = EnumSet.allOf(GroupByField.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
