/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcesTrendsV2Response extends SecurityHubResponse implements
        ToCopyableBuilder<GetResourcesTrendsV2Response.Builder, GetResourcesTrendsV2Response> {
    private static final SdkField<String> GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Granularity").getter(getter(GetResourcesTrendsV2Response::granularityAsString))
            .setter(setter(Builder::granularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()).build();

    private static final SdkField<List<ResourcesTrendsMetricsResult>> TRENDS_METRICS_FIELD = SdkField
            .<List<ResourcesTrendsMetricsResult>> builder(MarshallingType.LIST)
            .memberName("TrendsMetrics")
            .getter(getter(GetResourcesTrendsV2Response::trendsMetrics))
            .setter(setter(Builder::trendsMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrendsMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcesTrendsMetricsResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcesTrendsMetricsResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetResourcesTrendsV2Response::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANULARITY_FIELD,
            TRENDS_METRICS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String granularity;

    private final List<ResourcesTrendsMetricsResult> trendsMetrics;

    private final String nextToken;

    private GetResourcesTrendsV2Response(BuilderImpl builder) {
        super(builder);
        this.granularity = builder.granularity;
        this.trendsMetrics = builder.trendsMetrics;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The time interval granularity for the returned trend data (such as DAILY or WEEKLY).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link GranularityField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The time interval granularity for the returned trend data (such as DAILY or WEEKLY).
     * @see GranularityField
     */
    public final GranularityField granularity() {
        return GranularityField.fromValue(granularity);
    }

    /**
     * <p>
     * The time interval granularity for the returned trend data (such as DAILY or WEEKLY).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link GranularityField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The time interval granularity for the returned trend data (such as DAILY or WEEKLY).
     * @see GranularityField
     */
    public final String granularityAsString() {
        return granularity;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrendsMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrendsMetrics() {
        return trendsMetrics != null && !(trendsMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The collection of time-series trend metrics, including counts of resources across the specified time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrendsMetrics} method.
     * </p>
     * 
     * @return The collection of time-series trend metrics, including counts of resources across the specified time
     *         period.
     */
    public final List<ResourcesTrendsMetricsResult> trendsMetrics() {
        return trendsMetrics;
    }

    /**
     * <p>
     * The token to use for retrieving the next page of results, if more trend data is available.
     * </p>
     * 
     * @return The token to use for retrieving the next page of results, if more trend data is available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrendsMetrics() ? trendsMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesTrendsV2Response)) {
            return false;
        }
        GetResourcesTrendsV2Response other = (GetResourcesTrendsV2Response) obj;
        return Objects.equals(granularityAsString(), other.granularityAsString())
                && hasTrendsMetrics() == other.hasTrendsMetrics() && Objects.equals(trendsMetrics(), other.trendsMetrics())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourcesTrendsV2Response").add("Granularity", granularityAsString())
                .add("TrendsMetrics", hasTrendsMetrics() ? trendsMetrics() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Granularity":
            return Optional.ofNullable(clazz.cast(granularityAsString()));
        case "TrendsMetrics":
            return Optional.ofNullable(clazz.cast(trendsMetrics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Granularity", GRANULARITY_FIELD);
        map.put("TrendsMetrics", TRENDS_METRICS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesTrendsV2Response, T> g) {
        return obj -> g.apply((GetResourcesTrendsV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetResourcesTrendsV2Response> {
        /**
         * <p>
         * The time interval granularity for the returned trend data (such as DAILY or WEEKLY).
         * </p>
         * 
         * @param granularity
         *        The time interval granularity for the returned trend data (such as DAILY or WEEKLY).
         * @see GranularityField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GranularityField
         */
        Builder granularity(String granularity);

        /**
         * <p>
         * The time interval granularity for the returned trend data (such as DAILY or WEEKLY).
         * </p>
         * 
         * @param granularity
         *        The time interval granularity for the returned trend data (such as DAILY or WEEKLY).
         * @see GranularityField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GranularityField
         */
        Builder granularity(GranularityField granularity);

        /**
         * <p>
         * The collection of time-series trend metrics, including counts of resources across the specified time period.
         * </p>
         * 
         * @param trendsMetrics
         *        The collection of time-series trend metrics, including counts of resources across the specified time
         *        period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trendsMetrics(Collection<ResourcesTrendsMetricsResult> trendsMetrics);

        /**
         * <p>
         * The collection of time-series trend metrics, including counts of resources across the specified time period.
         * </p>
         * 
         * @param trendsMetrics
         *        The collection of time-series trend metrics, including counts of resources across the specified time
         *        period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trendsMetrics(ResourcesTrendsMetricsResult... trendsMetrics);

        /**
         * <p>
         * The collection of time-series trend metrics, including counts of resources across the specified time period.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesTrendsMetricsResult.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesTrendsMetricsResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesTrendsMetricsResult.Builder#build()} is
         * called immediately and its result is passed to {@link #trendsMetrics(List<ResourcesTrendsMetricsResult>)}.
         * 
         * @param trendsMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ResourcesTrendsMetricsResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trendsMetrics(java.util.Collection<ResourcesTrendsMetricsResult>)
         */
        Builder trendsMetrics(Consumer<ResourcesTrendsMetricsResult.Builder>... trendsMetrics);

        /**
         * <p>
         * The token to use for retrieving the next page of results, if more trend data is available.
         * </p>
         * 
         * @param nextToken
         *        The token to use for retrieving the next page of results, if more trend data is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String granularity;

        private List<ResourcesTrendsMetricsResult> trendsMetrics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesTrendsV2Response model) {
            super(model);
            granularity(model.granularity);
            trendsMetrics(model.trendsMetrics);
            nextToken(model.nextToken);
        }

        public final String getGranularity() {
            return granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(GranularityField granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final List<ResourcesTrendsMetricsResult.Builder> getTrendsMetrics() {
            List<ResourcesTrendsMetricsResult.Builder> result = ResourcesTrendsMetricsCopier.copyToBuilder(this.trendsMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrendsMetrics(Collection<ResourcesTrendsMetricsResult.BuilderImpl> trendsMetrics) {
            this.trendsMetrics = ResourcesTrendsMetricsCopier.copyFromBuilder(trendsMetrics);
        }

        @Override
        public final Builder trendsMetrics(Collection<ResourcesTrendsMetricsResult> trendsMetrics) {
            this.trendsMetrics = ResourcesTrendsMetricsCopier.copy(trendsMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trendsMetrics(ResourcesTrendsMetricsResult... trendsMetrics) {
            trendsMetrics(Arrays.asList(trendsMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trendsMetrics(Consumer<ResourcesTrendsMetricsResult.Builder>... trendsMetrics) {
            trendsMetrics(Stream.of(trendsMetrics).map(c -> ResourcesTrendsMetricsResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetResourcesTrendsV2Response build() {
            return new GetResourcesTrendsV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
