/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcesStatisticsV2Response extends SecurityHubResponse implements
        ToCopyableBuilder<GetResourcesStatisticsV2Response.Builder, GetResourcesStatisticsV2Response> {
    private static final SdkField<List<GroupByResult>> GROUP_BY_RESULTS_FIELD = SdkField
            .<List<GroupByResult>> builder(MarshallingType.LIST)
            .memberName("GroupByResults")
            .getter(getter(GetResourcesStatisticsV2Response::groupByResults))
            .setter(setter(Builder::groupByResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupByResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupByResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<GroupByResult> groupByResults;

    private GetResourcesStatisticsV2Response(BuilderImpl builder) {
        super(builder);
        this.groupByResults = builder.groupByResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupByResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupByResults() {
        return groupByResults != null && !(groupByResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The aggregated statistics about resources based on the specified grouping rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupByResults} method.
     * </p>
     * 
     * @return The aggregated statistics about resources based on the specified grouping rule.
     */
    public final List<GroupByResult> groupByResults() {
        return groupByResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupByResults() ? groupByResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesStatisticsV2Response)) {
            return false;
        }
        GetResourcesStatisticsV2Response other = (GetResourcesStatisticsV2Response) obj;
        return hasGroupByResults() == other.hasGroupByResults() && Objects.equals(groupByResults(), other.groupByResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourcesStatisticsV2Response")
                .add("GroupByResults", hasGroupByResults() ? groupByResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupByResults":
            return Optional.ofNullable(clazz.cast(groupByResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupByResults", GROUP_BY_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesStatisticsV2Response, T> g) {
        return obj -> g.apply((GetResourcesStatisticsV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourcesStatisticsV2Response> {
        /**
         * <p>
         * The aggregated statistics about resources based on the specified grouping rule.
         * </p>
         * 
         * @param groupByResults
         *        The aggregated statistics about resources based on the specified grouping rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByResults(Collection<GroupByResult> groupByResults);

        /**
         * <p>
         * The aggregated statistics about resources based on the specified grouping rule.
         * </p>
         * 
         * @param groupByResults
         *        The aggregated statistics about resources based on the specified grouping rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByResults(GroupByResult... groupByResults);

        /**
         * <p>
         * The aggregated statistics about resources based on the specified grouping rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.GroupByResult.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.GroupByResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.GroupByResult.Builder#build()} is called immediately
         * and its result is passed to {@link #groupByResults(List<GroupByResult>)}.
         * 
         * @param groupByResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.GroupByResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupByResults(java.util.Collection<GroupByResult>)
         */
        Builder groupByResults(Consumer<GroupByResult.Builder>... groupByResults);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<GroupByResult> groupByResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesStatisticsV2Response model) {
            super(model);
            groupByResults(model.groupByResults);
        }

        public final List<GroupByResult.Builder> getGroupByResults() {
            List<GroupByResult.Builder> result = GroupByResultsCopier.copyToBuilder(this.groupByResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByResults(Collection<GroupByResult.BuilderImpl> groupByResults) {
            this.groupByResults = GroupByResultsCopier.copyFromBuilder(groupByResults);
        }

        @Override
        public final Builder groupByResults(Collection<GroupByResult> groupByResults) {
            this.groupByResults = GroupByResultsCopier.copy(groupByResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByResults(GroupByResult... groupByResults) {
            groupByResults(Arrays.asList(groupByResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByResults(Consumer<GroupByResult.Builder>... groupByResults) {
            groupByResults(Stream.of(groupByResults).map(c -> GroupByResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetResourcesStatisticsV2Response build() {
            return new GetResourcesStatisticsV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
