/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFindingHistoryResponse extends SecurityHubResponse implements
        ToCopyableBuilder<GetFindingHistoryResponse.Builder, GetFindingHistoryResponse> {
    private static final SdkField<List<FindingHistoryRecord>> RECORDS_FIELD = SdkField
            .<List<FindingHistoryRecord>> builder(MarshallingType.LIST)
            .memberName("Records")
            .getter(getter(GetFindingHistoryResponse::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingHistoryRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingHistoryRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetFindingHistoryResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FindingHistoryRecord> records;

    private final String nextToken;

    private GetFindingHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of events that altered the specified finding during the specified time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return A list of events that altered the specified finding during the specified time period.
     */
    public final List<FindingHistoryRecord> records() {
        return records;
    }

    /**
     * <p>
     * A token for pagination purposes. Provide this token in the subsequent request to <code>GetFindingsHistory</code>
     * to get up to an additional 100 results of history for the same finding that you specified in your initial
     * request.
     * </p>
     * 
     * @return A token for pagination purposes. Provide this token in the subsequent request to
     *         <code>GetFindingsHistory</code> to get up to an additional 100 results of history for the same finding
     *         that you specified in your initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingHistoryResponse)) {
            return false;
        }
        GetFindingHistoryResponse other = (GetFindingHistoryResponse) obj;
        return hasRecords() == other.hasRecords() && Objects.equals(records(), other.records())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFindingHistoryResponse").add("Records", hasRecords() ? records() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Records":
            return Optional.ofNullable(clazz.cast(records()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Records", RECORDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFindingHistoryResponse, T> g) {
        return obj -> g.apply((GetFindingHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFindingHistoryResponse> {
        /**
         * <p>
         * A list of events that altered the specified finding during the specified time period.
         * </p>
         * 
         * @param records
         *        A list of events that altered the specified finding during the specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<FindingHistoryRecord> records);

        /**
         * <p>
         * A list of events that altered the specified finding during the specified time period.
         * </p>
         * 
         * @param records
         *        A list of events that altered the specified finding during the specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(FindingHistoryRecord... records);

        /**
         * <p>
         * A list of events that altered the specified finding during the specified time period.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.FindingHistoryRecord.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.FindingHistoryRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.FindingHistoryRecord.Builder#build()} is called
         * immediately and its result is passed to {@link #records(List<FindingHistoryRecord>)}.
         * 
         * @param records
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.FindingHistoryRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(java.util.Collection<FindingHistoryRecord>)
         */
        Builder records(Consumer<FindingHistoryRecord.Builder>... records);

        /**
         * <p>
         * A token for pagination purposes. Provide this token in the subsequent request to
         * <code>GetFindingsHistory</code> to get up to an additional 100 results of history for the same finding that
         * you specified in your initial request.
         * </p>
         * 
         * @param nextToken
         *        A token for pagination purposes. Provide this token in the subsequent request to
         *        <code>GetFindingsHistory</code> to get up to an additional 100 results of history for the same finding
         *        that you specified in your initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<FindingHistoryRecord> records = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingHistoryResponse model) {
            super(model);
            records(model.records);
            nextToken(model.nextToken);
        }

        public final List<FindingHistoryRecord.Builder> getRecords() {
            List<FindingHistoryRecord.Builder> result = FindingHistoryRecordListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<FindingHistoryRecord.BuilderImpl> records) {
            this.records = FindingHistoryRecordListCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<FindingHistoryRecord> records) {
            this.records = FindingHistoryRecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(FindingHistoryRecord... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<FindingHistoryRecord.Builder>... records) {
            records(Stream.of(records).map(c -> FindingHistoryRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetFindingHistoryResponse build() {
            return new GetFindingHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
