/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the behavior of the firewall.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallPolicyDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<FirewallPolicyDetails.Builder, FirewallPolicyDetails> {
    private static final SdkField<List<FirewallPolicyStatefulRuleGroupReferencesDetails>> STATEFUL_RULE_GROUP_REFERENCES_FIELD = SdkField
            .<List<FirewallPolicyStatefulRuleGroupReferencesDetails>> builder(MarshallingType.LIST)
            .memberName("StatefulRuleGroupReferences")
            .getter(getter(FirewallPolicyDetails::statefulRuleGroupReferences))
            .setter(setter(Builder::statefulRuleGroupReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRuleGroupReferences")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FirewallPolicyStatefulRuleGroupReferencesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(FirewallPolicyStatefulRuleGroupReferencesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FirewallPolicyStatelessCustomActionsDetails>> STATELESS_CUSTOM_ACTIONS_FIELD = SdkField
            .<List<FirewallPolicyStatelessCustomActionsDetails>> builder(MarshallingType.LIST)
            .memberName("StatelessCustomActions")
            .getter(getter(FirewallPolicyDetails::statelessCustomActions))
            .setter(setter(Builder::statelessCustomActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessCustomActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FirewallPolicyStatelessCustomActionsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(FirewallPolicyStatelessCustomActionsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATELESS_DEFAULT_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StatelessDefaultActions")
            .getter(getter(FirewallPolicyDetails::statelessDefaultActions))
            .setter(setter(Builder::statelessDefaultActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessDefaultActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StatelessFragmentDefaultActions")
            .getter(getter(FirewallPolicyDetails::statelessFragmentDefaultActions))
            .setter(setter(Builder::statelessFragmentDefaultActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessFragmentDefaultActions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FirewallPolicyStatelessRuleGroupReferencesDetails>> STATELESS_RULE_GROUP_REFERENCES_FIELD = SdkField
            .<List<FirewallPolicyStatelessRuleGroupReferencesDetails>> builder(MarshallingType.LIST)
            .memberName("StatelessRuleGroupReferences")
            .getter(getter(FirewallPolicyDetails::statelessRuleGroupReferences))
            .setter(setter(Builder::statelessRuleGroupReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRuleGroupReferences")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FirewallPolicyStatelessRuleGroupReferencesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(FirewallPolicyStatelessRuleGroupReferencesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STATEFUL_RULE_GROUP_REFERENCES_FIELD, STATELESS_CUSTOM_ACTIONS_FIELD, STATELESS_DEFAULT_ACTIONS_FIELD,
            STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD, STATELESS_RULE_GROUP_REFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FirewallPolicyStatefulRuleGroupReferencesDetails> statefulRuleGroupReferences;

    private final List<FirewallPolicyStatelessCustomActionsDetails> statelessCustomActions;

    private final List<String> statelessDefaultActions;

    private final List<String> statelessFragmentDefaultActions;

    private final List<FirewallPolicyStatelessRuleGroupReferencesDetails> statelessRuleGroupReferences;

    private FirewallPolicyDetails(BuilderImpl builder) {
        this.statefulRuleGroupReferences = builder.statefulRuleGroupReferences;
        this.statelessCustomActions = builder.statelessCustomActions;
        this.statelessDefaultActions = builder.statelessDefaultActions;
        this.statelessFragmentDefaultActions = builder.statelessFragmentDefaultActions;
        this.statelessRuleGroupReferences = builder.statelessRuleGroupReferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatefulRuleGroupReferences property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatefulRuleGroupReferences() {
        return statefulRuleGroupReferences != null && !(statefulRuleGroupReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stateful rule groups that are used in the firewall policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatefulRuleGroupReferences} method.
     * </p>
     * 
     * @return The stateful rule groups that are used in the firewall policy.
     */
    public final List<FirewallPolicyStatefulRuleGroupReferencesDetails> statefulRuleGroupReferences() {
        return statefulRuleGroupReferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatelessCustomActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatelessCustomActions() {
        return statelessCustomActions != null && !(statelessCustomActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom action definitions that are available to use in the firewall policy's
     * <code>StatelessDefaultActions</code> setting.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatelessCustomActions} method.
     * </p>
     * 
     * @return The custom action definitions that are available to use in the firewall policy's
     *         <code>StatelessDefaultActions</code> setting.
     */
    public final List<FirewallPolicyStatelessCustomActionsDetails> statelessCustomActions() {
        return statelessCustomActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatelessDefaultActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatelessDefaultActions() {
        return statelessDefaultActions != null && !(statelessDefaultActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to take on a packet if it doesn't match any of the stateless rules in the policy.
     * </p>
     * <p>
     * You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>, <code>aws:forward_to_sfe</code>
     * ), and can optionally include a custom action from <code>StatelessCustomActions</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatelessDefaultActions} method.
     * </p>
     * 
     * @return The actions to take on a packet if it doesn't match any of the stateless rules in the policy.</p>
     *         <p>
     *         You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>,
     *         <code>aws:forward_to_sfe</code>), and can optionally include a custom action from
     *         <code>StatelessCustomActions</code>.
     */
    public final List<String> statelessDefaultActions() {
        return statelessDefaultActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatelessFragmentDefaultActions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasStatelessFragmentDefaultActions() {
        return statelessFragmentDefaultActions != null && !(statelessFragmentDefaultActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the policy.
     * </p>
     * <p>
     * You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>, <code>aws:forward_to_sfe</code>
     * ), and can optionally include a custom action from <code>StatelessCustomActions</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatelessFragmentDefaultActions}
     * method.
     * </p>
     * 
     * @return The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the
     *         policy.</p>
     *         <p>
     *         You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>,
     *         <code>aws:forward_to_sfe</code>), and can optionally include a custom action from
     *         <code>StatelessCustomActions</code>.
     */
    public final List<String> statelessFragmentDefaultActions() {
        return statelessFragmentDefaultActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatelessRuleGroupReferences property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatelessRuleGroupReferences() {
        return statelessRuleGroupReferences != null && !(statelessRuleGroupReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stateless rule groups that are used in the firewall policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatelessRuleGroupReferences} method.
     * </p>
     * 
     * @return The stateless rule groups that are used in the firewall policy.
     */
    public final List<FirewallPolicyStatelessRuleGroupReferencesDetails> statelessRuleGroupReferences() {
        return statelessRuleGroupReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStatefulRuleGroupReferences() ? statefulRuleGroupReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessCustomActions() ? statelessCustomActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessDefaultActions() ? statelessDefaultActions() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasStatelessFragmentDefaultActions() ? statelessFragmentDefaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessRuleGroupReferences() ? statelessRuleGroupReferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallPolicyDetails)) {
            return false;
        }
        FirewallPolicyDetails other = (FirewallPolicyDetails) obj;
        return hasStatefulRuleGroupReferences() == other.hasStatefulRuleGroupReferences()
                && Objects.equals(statefulRuleGroupReferences(), other.statefulRuleGroupReferences())
                && hasStatelessCustomActions() == other.hasStatelessCustomActions()
                && Objects.equals(statelessCustomActions(), other.statelessCustomActions())
                && hasStatelessDefaultActions() == other.hasStatelessDefaultActions()
                && Objects.equals(statelessDefaultActions(), other.statelessDefaultActions())
                && hasStatelessFragmentDefaultActions() == other.hasStatelessFragmentDefaultActions()
                && Objects.equals(statelessFragmentDefaultActions(), other.statelessFragmentDefaultActions())
                && hasStatelessRuleGroupReferences() == other.hasStatelessRuleGroupReferences()
                && Objects.equals(statelessRuleGroupReferences(), other.statelessRuleGroupReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("FirewallPolicyDetails")
                .add("StatefulRuleGroupReferences", hasStatefulRuleGroupReferences() ? statefulRuleGroupReferences() : null)
                .add("StatelessCustomActions", hasStatelessCustomActions() ? statelessCustomActions() : null)
                .add("StatelessDefaultActions", hasStatelessDefaultActions() ? statelessDefaultActions() : null)
                .add("StatelessFragmentDefaultActions",
                        hasStatelessFragmentDefaultActions() ? statelessFragmentDefaultActions() : null)
                .add("StatelessRuleGroupReferences", hasStatelessRuleGroupReferences() ? statelessRuleGroupReferences() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatefulRuleGroupReferences":
            return Optional.ofNullable(clazz.cast(statefulRuleGroupReferences()));
        case "StatelessCustomActions":
            return Optional.ofNullable(clazz.cast(statelessCustomActions()));
        case "StatelessDefaultActions":
            return Optional.ofNullable(clazz.cast(statelessDefaultActions()));
        case "StatelessFragmentDefaultActions":
            return Optional.ofNullable(clazz.cast(statelessFragmentDefaultActions()));
        case "StatelessRuleGroupReferences":
            return Optional.ofNullable(clazz.cast(statelessRuleGroupReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StatefulRuleGroupReferences", STATEFUL_RULE_GROUP_REFERENCES_FIELD);
        map.put("StatelessCustomActions", STATELESS_CUSTOM_ACTIONS_FIELD);
        map.put("StatelessDefaultActions", STATELESS_DEFAULT_ACTIONS_FIELD);
        map.put("StatelessFragmentDefaultActions", STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD);
        map.put("StatelessRuleGroupReferences", STATELESS_RULE_GROUP_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FirewallPolicyDetails, T> g) {
        return obj -> g.apply((FirewallPolicyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallPolicyDetails> {
        /**
         * <p>
         * The stateful rule groups that are used in the firewall policy.
         * </p>
         * 
         * @param statefulRuleGroupReferences
         *        The stateful rule groups that are used in the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRuleGroupReferences(
                Collection<FirewallPolicyStatefulRuleGroupReferencesDetails> statefulRuleGroupReferences);

        /**
         * <p>
         * The stateful rule groups that are used in the firewall policy.
         * </p>
         * 
         * @param statefulRuleGroupReferences
         *        The stateful rule groups that are used in the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRuleGroupReferences(FirewallPolicyStatefulRuleGroupReferencesDetails... statefulRuleGroupReferences);

        /**
         * <p>
         * The stateful rule groups that are used in the firewall policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #statefulRuleGroupReferences(List<FirewallPolicyStatefulRuleGroupReferencesDetails>)}.
         * 
         * @param statefulRuleGroupReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statefulRuleGroupReferences(java.util.Collection<FirewallPolicyStatefulRuleGroupReferencesDetails>)
         */
        Builder statefulRuleGroupReferences(
                Consumer<FirewallPolicyStatefulRuleGroupReferencesDetails.Builder>... statefulRuleGroupReferences);

        /**
         * <p>
         * The custom action definitions that are available to use in the firewall policy's
         * <code>StatelessDefaultActions</code> setting.
         * </p>
         * 
         * @param statelessCustomActions
         *        The custom action definitions that are available to use in the firewall policy's
         *        <code>StatelessDefaultActions</code> setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessCustomActions(Collection<FirewallPolicyStatelessCustomActionsDetails> statelessCustomActions);

        /**
         * <p>
         * The custom action definitions that are available to use in the firewall policy's
         * <code>StatelessDefaultActions</code> setting.
         * </p>
         * 
         * @param statelessCustomActions
         *        The custom action definitions that are available to use in the firewall policy's
         *        <code>StatelessDefaultActions</code> setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessCustomActions(FirewallPolicyStatelessCustomActionsDetails... statelessCustomActions);

        /**
         * <p>
         * The custom action definitions that are available to use in the firewall policy's
         * <code>StatelessDefaultActions</code> setting.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessCustomActionsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessCustomActionsDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessCustomActionsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #statelessCustomActions(List<FirewallPolicyStatelessCustomActionsDetails>)}.
         * 
         * @param statelessCustomActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessCustomActionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statelessCustomActions(java.util.Collection<FirewallPolicyStatelessCustomActionsDetails>)
         */
        Builder statelessCustomActions(Consumer<FirewallPolicyStatelessCustomActionsDetails.Builder>... statelessCustomActions);

        /**
         * <p>
         * The actions to take on a packet if it doesn't match any of the stateless rules in the policy.
         * </p>
         * <p>
         * You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>,
         * <code>aws:forward_to_sfe</code>), and can optionally include a custom action from
         * <code>StatelessCustomActions</code>.
         * </p>
         * 
         * @param statelessDefaultActions
         *        The actions to take on a packet if it doesn't match any of the stateless rules in the policy.</p>
         *        <p>
         *        You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>,
         *        <code>aws:forward_to_sfe</code>), and can optionally include a custom action from
         *        <code>StatelessCustomActions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessDefaultActions(Collection<String> statelessDefaultActions);

        /**
         * <p>
         * The actions to take on a packet if it doesn't match any of the stateless rules in the policy.
         * </p>
         * <p>
         * You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>,
         * <code>aws:forward_to_sfe</code>), and can optionally include a custom action from
         * <code>StatelessCustomActions</code>.
         * </p>
         * 
         * @param statelessDefaultActions
         *        The actions to take on a packet if it doesn't match any of the stateless rules in the policy.</p>
         *        <p>
         *        You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>,
         *        <code>aws:forward_to_sfe</code>), and can optionally include a custom action from
         *        <code>StatelessCustomActions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessDefaultActions(String... statelessDefaultActions);

        /**
         * <p>
         * The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the policy.
         * </p>
         * <p>
         * You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>,
         * <code>aws:forward_to_sfe</code>), and can optionally include a custom action from
         * <code>StatelessCustomActions</code>.
         * </p>
         * 
         * @param statelessFragmentDefaultActions
         *        The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the
         *        policy.</p>
         *        <p>
         *        You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>,
         *        <code>aws:forward_to_sfe</code>), and can optionally include a custom action from
         *        <code>StatelessCustomActions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions);

        /**
         * <p>
         * The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the policy.
         * </p>
         * <p>
         * You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>,
         * <code>aws:forward_to_sfe</code>), and can optionally include a custom action from
         * <code>StatelessCustomActions</code>.
         * </p>
         * 
         * @param statelessFragmentDefaultActions
         *        The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the
         *        policy.</p>
         *        <p>
         *        You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>,
         *        <code>aws:forward_to_sfe</code>), and can optionally include a custom action from
         *        <code>StatelessCustomActions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessFragmentDefaultActions(String... statelessFragmentDefaultActions);

        /**
         * <p>
         * The stateless rule groups that are used in the firewall policy.
         * </p>
         * 
         * @param statelessRuleGroupReferences
         *        The stateless rule groups that are used in the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRuleGroupReferences(
                Collection<FirewallPolicyStatelessRuleGroupReferencesDetails> statelessRuleGroupReferences);

        /**
         * <p>
         * The stateless rule groups that are used in the firewall policy.
         * </p>
         * 
         * @param statelessRuleGroupReferences
         *        The stateless rule groups that are used in the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRuleGroupReferences(FirewallPolicyStatelessRuleGroupReferencesDetails... statelessRuleGroupReferences);

        /**
         * <p>
         * The stateless rule groups that are used in the firewall policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #statelessRuleGroupReferences(List<FirewallPolicyStatelessRuleGroupReferencesDetails>)}.
         * 
         * @param statelessRuleGroupReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statelessRuleGroupReferences(java.util.Collection<FirewallPolicyStatelessRuleGroupReferencesDetails>)
         */
        Builder statelessRuleGroupReferences(
                Consumer<FirewallPolicyStatelessRuleGroupReferencesDetails.Builder>... statelessRuleGroupReferences);
    }

    static final class BuilderImpl implements Builder {
        private List<FirewallPolicyStatefulRuleGroupReferencesDetails> statefulRuleGroupReferences = DefaultSdkAutoConstructList
                .getInstance();

        private List<FirewallPolicyStatelessCustomActionsDetails> statelessCustomActions = DefaultSdkAutoConstructList
                .getInstance();

        private List<String> statelessDefaultActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> statelessFragmentDefaultActions = DefaultSdkAutoConstructList.getInstance();

        private List<FirewallPolicyStatelessRuleGroupReferencesDetails> statelessRuleGroupReferences = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallPolicyDetails model) {
            statefulRuleGroupReferences(model.statefulRuleGroupReferences);
            statelessCustomActions(model.statelessCustomActions);
            statelessDefaultActions(model.statelessDefaultActions);
            statelessFragmentDefaultActions(model.statelessFragmentDefaultActions);
            statelessRuleGroupReferences(model.statelessRuleGroupReferences);
        }

        public final List<FirewallPolicyStatefulRuleGroupReferencesDetails.Builder> getStatefulRuleGroupReferences() {
            List<FirewallPolicyStatefulRuleGroupReferencesDetails.Builder> result = FirewallPolicyStatefulRuleGroupReferencesListCopier
                    .copyToBuilder(this.statefulRuleGroupReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatefulRuleGroupReferences(
                Collection<FirewallPolicyStatefulRuleGroupReferencesDetails.BuilderImpl> statefulRuleGroupReferences) {
            this.statefulRuleGroupReferences = FirewallPolicyStatefulRuleGroupReferencesListCopier
                    .copyFromBuilder(statefulRuleGroupReferences);
        }

        @Override
        public final Builder statefulRuleGroupReferences(
                Collection<FirewallPolicyStatefulRuleGroupReferencesDetails> statefulRuleGroupReferences) {
            this.statefulRuleGroupReferences = FirewallPolicyStatefulRuleGroupReferencesListCopier
                    .copy(statefulRuleGroupReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRuleGroupReferences(
                FirewallPolicyStatefulRuleGroupReferencesDetails... statefulRuleGroupReferences) {
            statefulRuleGroupReferences(Arrays.asList(statefulRuleGroupReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRuleGroupReferences(
                Consumer<FirewallPolicyStatefulRuleGroupReferencesDetails.Builder>... statefulRuleGroupReferences) {
            statefulRuleGroupReferences(Stream.of(statefulRuleGroupReferences)
                    .map(c -> FirewallPolicyStatefulRuleGroupReferencesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FirewallPolicyStatelessCustomActionsDetails.Builder> getStatelessCustomActions() {
            List<FirewallPolicyStatelessCustomActionsDetails.Builder> result = FirewallPolicyStatelessCustomActionsListCopier
                    .copyToBuilder(this.statelessCustomActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatelessCustomActions(
                Collection<FirewallPolicyStatelessCustomActionsDetails.BuilderImpl> statelessCustomActions) {
            this.statelessCustomActions = FirewallPolicyStatelessCustomActionsListCopier.copyFromBuilder(statelessCustomActions);
        }

        @Override
        public final Builder statelessCustomActions(Collection<FirewallPolicyStatelessCustomActionsDetails> statelessCustomActions) {
            this.statelessCustomActions = FirewallPolicyStatelessCustomActionsListCopier.copy(statelessCustomActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessCustomActions(FirewallPolicyStatelessCustomActionsDetails... statelessCustomActions) {
            statelessCustomActions(Arrays.asList(statelessCustomActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessCustomActions(
                Consumer<FirewallPolicyStatelessCustomActionsDetails.Builder>... statelessCustomActions) {
            statelessCustomActions(Stream.of(statelessCustomActions)
                    .map(c -> FirewallPolicyStatelessCustomActionsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getStatelessDefaultActions() {
            if (statelessDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return statelessDefaultActions;
        }

        public final void setStatelessDefaultActions(Collection<String> statelessDefaultActions) {
            this.statelessDefaultActions = NonEmptyStringListCopier.copy(statelessDefaultActions);
        }

        @Override
        public final Builder statelessDefaultActions(Collection<String> statelessDefaultActions) {
            this.statelessDefaultActions = NonEmptyStringListCopier.copy(statelessDefaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessDefaultActions(String... statelessDefaultActions) {
            statelessDefaultActions(Arrays.asList(statelessDefaultActions));
            return this;
        }

        public final Collection<String> getStatelessFragmentDefaultActions() {
            if (statelessFragmentDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return statelessFragmentDefaultActions;
        }

        public final void setStatelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions = NonEmptyStringListCopier.copy(statelessFragmentDefaultActions);
        }

        @Override
        public final Builder statelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions = NonEmptyStringListCopier.copy(statelessFragmentDefaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessFragmentDefaultActions(String... statelessFragmentDefaultActions) {
            statelessFragmentDefaultActions(Arrays.asList(statelessFragmentDefaultActions));
            return this;
        }

        public final List<FirewallPolicyStatelessRuleGroupReferencesDetails.Builder> getStatelessRuleGroupReferences() {
            List<FirewallPolicyStatelessRuleGroupReferencesDetails.Builder> result = FirewallPolicyStatelessRuleGroupReferencesListCopier
                    .copyToBuilder(this.statelessRuleGroupReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatelessRuleGroupReferences(
                Collection<FirewallPolicyStatelessRuleGroupReferencesDetails.BuilderImpl> statelessRuleGroupReferences) {
            this.statelessRuleGroupReferences = FirewallPolicyStatelessRuleGroupReferencesListCopier
                    .copyFromBuilder(statelessRuleGroupReferences);
        }

        @Override
        public final Builder statelessRuleGroupReferences(
                Collection<FirewallPolicyStatelessRuleGroupReferencesDetails> statelessRuleGroupReferences) {
            this.statelessRuleGroupReferences = FirewallPolicyStatelessRuleGroupReferencesListCopier
                    .copy(statelessRuleGroupReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRuleGroupReferences(
                FirewallPolicyStatelessRuleGroupReferencesDetails... statelessRuleGroupReferences) {
            statelessRuleGroupReferences(Arrays.asList(statelessRuleGroupReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRuleGroupReferences(
                Consumer<FirewallPolicyStatelessRuleGroupReferencesDetails.Builder>... statelessRuleGroupReferences) {
            statelessRuleGroupReferences(Stream.of(statelessRuleGroupReferences)
                    .map(c -> FirewallPolicyStatelessRuleGroupReferencesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FirewallPolicyDetails build() {
            return new FirewallPolicyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
