/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the file paths that were affected by the threat.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilePaths implements SdkPojo, Serializable, ToCopyableBuilder<FilePaths.Builder, FilePaths> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilePath").getter(getter(FilePaths::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePath").build()).build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileName").getter(getter(FilePaths::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(FilePaths::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Hash")
            .getter(getter(FilePaths::hash)).setter(setter(Builder::hash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hash").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD,
            FILE_NAME_FIELD, RESOURCE_ID_FIELD, HASH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filePath;

    private final String fileName;

    private final String resourceId;

    private final String hash;

    private FilePaths(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.fileName = builder.fileName;
        this.resourceId = builder.resourceId;
        this.hash = builder.hash;
    }

    /**
     * <p>
     * Path to the infected or suspicious file on the resource it was detected on.
     * </p>
     * <p>
     * Length Constraints: Minimum of 1 length. Maximum of 128 length.
     * </p>
     * 
     * @return Path to the infected or suspicious file on the resource it was detected on. </p>
     *         <p>
     *         Length Constraints: Minimum of 1 length. Maximum of 128 length.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The name of the infected or suspicious file corresponding to the hash.
     * </p>
     * <p>
     * Length Constraints: Minimum of 1 length. Maximum of 128 length.
     * </p>
     * 
     * @return The name of the infected or suspicious file corresponding to the hash. </p>
     *         <p>
     *         Length Constraints: Minimum of 1 length. Maximum of 128 length.
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource on which the threat was detected.
     * </p>
     * <p>
     * Length Constraints: Minimum of 1 length. Maximum of 128 length.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource on which the threat was detected. </p>
     *         <p>
     *         Length Constraints: Minimum of 1 length. Maximum of 128 length.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The hash value for the infected or suspicious file.
     * </p>
     * <p>
     * Length Constraints: Minimum of 1 length. Maximum of 128 length.
     * </p>
     * 
     * @return The hash value for the infected or suspicious file. </p>
     *         <p>
     *         Length Constraints: Minimum of 1 length. Maximum of 128 length.
     */
    public final String hash() {
        return hash;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(hash());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilePaths)) {
            return false;
        }
        FilePaths other = (FilePaths) obj;
        return Objects.equals(filePath(), other.filePath()) && Objects.equals(fileName(), other.fileName())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(hash(), other.hash());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilePaths").add("FilePath", filePath()).add("FileName", fileName())
                .add("ResourceId", resourceId()).add("Hash", hash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "FileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "Hash":
            return Optional.ofNullable(clazz.cast(hash()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilePath", FILE_PATH_FIELD);
        map.put("FileName", FILE_NAME_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("Hash", HASH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilePaths, T> g) {
        return obj -> g.apply((FilePaths) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilePaths> {
        /**
         * <p>
         * Path to the infected or suspicious file on the resource it was detected on.
         * </p>
         * <p>
         * Length Constraints: Minimum of 1 length. Maximum of 128 length.
         * </p>
         * 
         * @param filePath
         *        Path to the infected or suspicious file on the resource it was detected on. </p>
         *        <p>
         *        Length Constraints: Minimum of 1 length. Maximum of 128 length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The name of the infected or suspicious file corresponding to the hash.
         * </p>
         * <p>
         * Length Constraints: Minimum of 1 length. Maximum of 128 length.
         * </p>
         * 
         * @param fileName
         *        The name of the infected or suspicious file corresponding to the hash. </p>
         *        <p>
         *        Length Constraints: Minimum of 1 length. Maximum of 128 length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource on which the threat was detected.
         * </p>
         * <p>
         * Length Constraints: Minimum of 1 length. Maximum of 128 length.
         * </p>
         * 
         * @param resourceId
         *        The Amazon Resource Name (ARN) of the resource on which the threat was detected. </p>
         *        <p>
         *        Length Constraints: Minimum of 1 length. Maximum of 128 length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The hash value for the infected or suspicious file.
         * </p>
         * <p>
         * Length Constraints: Minimum of 1 length. Maximum of 128 length.
         * </p>
         * 
         * @param hash
         *        The hash value for the infected or suspicious file. </p>
         *        <p>
         *        Length Constraints: Minimum of 1 length. Maximum of 128 length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hash(String hash);
    }

    static final class BuilderImpl implements Builder {
        private String filePath;

        private String fileName;

        private String resourceId;

        private String hash;

        private BuilderImpl() {
        }

        private BuilderImpl(FilePaths model) {
            filePath(model.filePath);
            fileName(model.fileName);
            resourceId(model.resourceId);
            hash(model.hash);
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getHash() {
            return hash;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        @Override
        public FilePaths build() {
            return new FilePaths(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
