/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableSecurityHubV2Response extends SecurityHubResponse implements
        ToCopyableBuilder<EnableSecurityHubV2Response.Builder, EnableSecurityHubV2Response> {
    private static final SdkField<String> HUB_V2_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubV2Arn").getter(getter(EnableSecurityHubV2Response::hubV2Arn)).setter(setter(Builder::hubV2Arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubV2Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_V2_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hubV2Arn;

    private EnableSecurityHubV2Response(BuilderImpl builder) {
        super(builder);
        this.hubV2Arn = builder.hubV2Arn;
    }

    /**
     * <p>
     * The ARN of the V2 resource that was created.
     * </p>
     * 
     * @return The ARN of the V2 resource that was created.
     */
    public final String hubV2Arn() {
        return hubV2Arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubV2Arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableSecurityHubV2Response)) {
            return false;
        }
        EnableSecurityHubV2Response other = (EnableSecurityHubV2Response) obj;
        return Objects.equals(hubV2Arn(), other.hubV2Arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableSecurityHubV2Response").add("HubV2Arn", hubV2Arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubV2Arn":
            return Optional.ofNullable(clazz.cast(hubV2Arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HubV2Arn", HUB_V2_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableSecurityHubV2Response, T> g) {
        return obj -> g.apply((EnableSecurityHubV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, EnableSecurityHubV2Response> {
        /**
         * <p>
         * The ARN of the V2 resource that was created.
         * </p>
         * 
         * @param hubV2Arn
         *        The ARN of the V2 resource that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubV2Arn(String hubV2Arn);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String hubV2Arn;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableSecurityHubV2Response model) {
            super(model);
            hubV2Arn(model.hubV2Arn);
        }

        public final String getHubV2Arn() {
            return hubV2Arn;
        }

        public final void setHubV2Arn(String hubV2Arn) {
            this.hubV2Arn = hubV2Arn;
        }

        @Override
        public final Builder hubV2Arn(String hubV2Arn) {
            this.hubV2Arn = hubV2Arn;
            return this;
        }

        @Override
        public EnableSecurityHubV2Response build() {
            return new EnableSecurityHubV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
