/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSecurityHubV2Response extends SecurityHubResponse implements
        ToCopyableBuilder<DescribeSecurityHubV2Response.Builder, DescribeSecurityHubV2Response> {
    private static final SdkField<String> HUB_V2_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubV2Arn").getter(getter(DescribeSecurityHubV2Response::hubV2Arn)).setter(setter(Builder::hubV2Arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubV2Arn").build()).build();

    private static final SdkField<String> SUBSCRIBED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscribedAt").getter(getter(DescribeSecurityHubV2Response::subscribedAt))
            .setter(setter(Builder::subscribedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_V2_ARN_FIELD,
            SUBSCRIBED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hubV2Arn;

    private final String subscribedAt;

    private DescribeSecurityHubV2Response(BuilderImpl builder) {
        super(builder);
        this.hubV2Arn = builder.hubV2Arn;
        this.subscribedAt = builder.subscribedAt;
    }

    /**
     * <p>
     * The ARN of the service resource.
     * </p>
     * 
     * @return The ARN of the service resource.
     */
    public final String hubV2Arn() {
        return hubV2Arn;
    }

    /**
     * <p>
     * The date and time when the service was enabled in the account.
     * </p>
     * 
     * @return The date and time when the service was enabled in the account.
     */
    public final String subscribedAt() {
        return subscribedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubV2Arn());
        hashCode = 31 * hashCode + Objects.hashCode(subscribedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityHubV2Response)) {
            return false;
        }
        DescribeSecurityHubV2Response other = (DescribeSecurityHubV2Response) obj;
        return Objects.equals(hubV2Arn(), other.hubV2Arn()) && Objects.equals(subscribedAt(), other.subscribedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSecurityHubV2Response").add("HubV2Arn", hubV2Arn()).add("SubscribedAt", subscribedAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubV2Arn":
            return Optional.ofNullable(clazz.cast(hubV2Arn()));
        case "SubscribedAt":
            return Optional.ofNullable(clazz.cast(subscribedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HubV2Arn", HUB_V2_ARN_FIELD);
        map.put("SubscribedAt", SUBSCRIBED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecurityHubV2Response, T> g) {
        return obj -> g.apply((DescribeSecurityHubV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSecurityHubV2Response> {
        /**
         * <p>
         * The ARN of the service resource.
         * </p>
         * 
         * @param hubV2Arn
         *        The ARN of the service resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubV2Arn(String hubV2Arn);

        /**
         * <p>
         * The date and time when the service was enabled in the account.
         * </p>
         * 
         * @param subscribedAt
         *        The date and time when the service was enabled in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedAt(String subscribedAt);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String hubV2Arn;

        private String subscribedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityHubV2Response model) {
            super(model);
            hubV2Arn(model.hubV2Arn);
            subscribedAt(model.subscribedAt);
        }

        public final String getHubV2Arn() {
            return hubV2Arn;
        }

        public final void setHubV2Arn(String hubV2Arn) {
            this.hubV2Arn = hubV2Arn;
        }

        @Override
        public final Builder hubV2Arn(String hubV2Arn) {
            this.hubV2Arn = hubV2Arn;
            return this;
        }

        public final String getSubscribedAt() {
            return subscribedAt;
        }

        public final void setSubscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
        }

        @Override
        public final Builder subscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
            return this;
        }

        @Override
        public DescribeSecurityHubV2Response build() {
            return new DescribeSecurityHubV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
