/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHubResponse extends SecurityHubResponse implements
        ToCopyableBuilder<DescribeHubResponse.Builder, DescribeHubResponse> {
    private static final SdkField<String> HUB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HubArn")
            .getter(getter(DescribeHubResponse::hubArn)).setter(setter(Builder::hubArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubArn").build()).build();

    private static final SdkField<String> SUBSCRIBED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscribedAt").getter(getter(DescribeHubResponse::subscribedAt)).setter(setter(Builder::subscribedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribedAt").build()).build();

    private static final SdkField<Boolean> AUTO_ENABLE_CONTROLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEnableControls").getter(getter(DescribeHubResponse::autoEnableControls))
            .setter(setter(Builder::autoEnableControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnableControls").build())
            .build();

    private static final SdkField<String> CONTROL_FINDING_GENERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlFindingGenerator").getter(getter(DescribeHubResponse::controlFindingGeneratorAsString))
            .setter(setter(Builder::controlFindingGenerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlFindingGenerator").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_ARN_FIELD,
            SUBSCRIBED_AT_FIELD, AUTO_ENABLE_CONTROLS_FIELD, CONTROL_FINDING_GENERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hubArn;

    private final String subscribedAt;

    private final Boolean autoEnableControls;

    private final String controlFindingGenerator;

    private DescribeHubResponse(BuilderImpl builder) {
        super(builder);
        this.hubArn = builder.hubArn;
        this.subscribedAt = builder.subscribedAt;
        this.autoEnableControls = builder.autoEnableControls;
        this.controlFindingGenerator = builder.controlFindingGenerator;
    }

    /**
     * <p>
     * The ARN of the Hub resource that was retrieved.
     * </p>
     * 
     * @return The ARN of the Hub resource that was retrieved.
     */
    public final String hubArn() {
        return hubArn;
    }

    /**
     * <p>
     * The date and time when Security Hub was enabled in the account.
     * </p>
     * 
     * @return The date and time when Security Hub was enabled in the account.
     */
    public final String subscribedAt() {
        return subscribedAt;
    }

    /**
     * <p>
     * Whether to automatically enable new controls when they are added to standards that are enabled.
     * </p>
     * <p>
     * If set to <code>true</code>, then new controls for enabled standards are enabled automatically. If set to
     * <code>false</code>, then new controls are not enabled.
     * </p>
     * <p>
     * When you automatically enable new controls, you can interact with the controls in the console and
     * programmatically immediately after release. However, automatically enabled controls have a temporary default
     * status of <code>DISABLED</code>. It can take up to several days for Security Hub to process the control release
     * and designate the control as <code>ENABLED</code> in your account. During the processing period, you can manually
     * enable or disable a control, and Security Hub will maintain that designation regardless of whether you have
     * <code>AutoEnableControls</code> set to <code>true</code>.
     * </p>
     * 
     * @return Whether to automatically enable new controls when they are added to standards that are enabled.</p>
     *         <p>
     *         If set to <code>true</code>, then new controls for enabled standards are enabled automatically. If set to
     *         <code>false</code>, then new controls are not enabled.
     *         </p>
     *         <p>
     *         When you automatically enable new controls, you can interact with the controls in the console and
     *         programmatically immediately after release. However, automatically enabled controls have a temporary
     *         default status of <code>DISABLED</code>. It can take up to several days for Security Hub to process the
     *         control release and designate the control as <code>ENABLED</code> in your account. During the processing
     *         period, you can manually enable or disable a control, and Security Hub will maintain that designation
     *         regardless of whether you have <code>AutoEnableControls</code> set to <code>true</code>.
     */
    public final Boolean autoEnableControls() {
        return autoEnableControls;
    }

    /**
     * <p>
     * Specifies whether the calling account has consolidated control findings turned on. If the value for this field is
     * set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control check even when the
     * check applies to multiple enabled standards.
     * </p>
     * <p>
     * If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate findings for
     * a control check when the check applies to multiple enabled standards.
     * </p>
     * <p>
     * The value for this field in a member account matches the value in the administrator account. For accounts that
     * aren't part of an organization, the default value of this field is <code>SECURITY_CONTROL</code> if you enabled
     * Security Hub on or after February 23, 2023.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #controlFindingGenerator} will return {@link ControlFindingGenerator#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #controlFindingGeneratorAsString}.
     * </p>
     * 
     * @return Specifies whether the calling account has consolidated control findings turned on. If the value for this
     *         field is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control
     *         check even when the check applies to multiple enabled standards.</p>
     *         <p>
     *         If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate
     *         findings for a control check when the check applies to multiple enabled standards.
     *         </p>
     *         <p>
     *         The value for this field in a member account matches the value in the administrator account. For accounts
     *         that aren't part of an organization, the default value of this field is <code>SECURITY_CONTROL</code> if
     *         you enabled Security Hub on or after February 23, 2023.
     * @see ControlFindingGenerator
     */
    public final ControlFindingGenerator controlFindingGenerator() {
        return ControlFindingGenerator.fromValue(controlFindingGenerator);
    }

    /**
     * <p>
     * Specifies whether the calling account has consolidated control findings turned on. If the value for this field is
     * set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control check even when the
     * check applies to multiple enabled standards.
     * </p>
     * <p>
     * If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate findings for
     * a control check when the check applies to multiple enabled standards.
     * </p>
     * <p>
     * The value for this field in a member account matches the value in the administrator account. For accounts that
     * aren't part of an organization, the default value of this field is <code>SECURITY_CONTROL</code> if you enabled
     * Security Hub on or after February 23, 2023.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #controlFindingGenerator} will return {@link ControlFindingGenerator#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #controlFindingGeneratorAsString}.
     * </p>
     * 
     * @return Specifies whether the calling account has consolidated control findings turned on. If the value for this
     *         field is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control
     *         check even when the check applies to multiple enabled standards.</p>
     *         <p>
     *         If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate
     *         findings for a control check when the check applies to multiple enabled standards.
     *         </p>
     *         <p>
     *         The value for this field in a member account matches the value in the administrator account. For accounts
     *         that aren't part of an organization, the default value of this field is <code>SECURITY_CONTROL</code> if
     *         you enabled Security Hub on or after February 23, 2023.
     * @see ControlFindingGenerator
     */
    public final String controlFindingGeneratorAsString() {
        return controlFindingGenerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubArn());
        hashCode = 31 * hashCode + Objects.hashCode(subscribedAt());
        hashCode = 31 * hashCode + Objects.hashCode(autoEnableControls());
        hashCode = 31 * hashCode + Objects.hashCode(controlFindingGeneratorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHubResponse)) {
            return false;
        }
        DescribeHubResponse other = (DescribeHubResponse) obj;
        return Objects.equals(hubArn(), other.hubArn()) && Objects.equals(subscribedAt(), other.subscribedAt())
                && Objects.equals(autoEnableControls(), other.autoEnableControls())
                && Objects.equals(controlFindingGeneratorAsString(), other.controlFindingGeneratorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHubResponse").add("HubArn", hubArn()).add("SubscribedAt", subscribedAt())
                .add("AutoEnableControls", autoEnableControls())
                .add("ControlFindingGenerator", controlFindingGeneratorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubArn":
            return Optional.ofNullable(clazz.cast(hubArn()));
        case "SubscribedAt":
            return Optional.ofNullable(clazz.cast(subscribedAt()));
        case "AutoEnableControls":
            return Optional.ofNullable(clazz.cast(autoEnableControls()));
        case "ControlFindingGenerator":
            return Optional.ofNullable(clazz.cast(controlFindingGeneratorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HubArn", HUB_ARN_FIELD);
        map.put("SubscribedAt", SUBSCRIBED_AT_FIELD);
        map.put("AutoEnableControls", AUTO_ENABLE_CONTROLS_FIELD);
        map.put("ControlFindingGenerator", CONTROL_FINDING_GENERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHubResponse, T> g) {
        return obj -> g.apply((DescribeHubResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeHubResponse> {
        /**
         * <p>
         * The ARN of the Hub resource that was retrieved.
         * </p>
         * 
         * @param hubArn
         *        The ARN of the Hub resource that was retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubArn(String hubArn);

        /**
         * <p>
         * The date and time when Security Hub was enabled in the account.
         * </p>
         * 
         * @param subscribedAt
         *        The date and time when Security Hub was enabled in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedAt(String subscribedAt);

        /**
         * <p>
         * Whether to automatically enable new controls when they are added to standards that are enabled.
         * </p>
         * <p>
         * If set to <code>true</code>, then new controls for enabled standards are enabled automatically. If set to
         * <code>false</code>, then new controls are not enabled.
         * </p>
         * <p>
         * When you automatically enable new controls, you can interact with the controls in the console and
         * programmatically immediately after release. However, automatically enabled controls have a temporary default
         * status of <code>DISABLED</code>. It can take up to several days for Security Hub to process the control
         * release and designate the control as <code>ENABLED</code> in your account. During the processing period, you
         * can manually enable or disable a control, and Security Hub will maintain that designation regardless of
         * whether you have <code>AutoEnableControls</code> set to <code>true</code>.
         * </p>
         * 
         * @param autoEnableControls
         *        Whether to automatically enable new controls when they are added to standards that are enabled.</p>
         *        <p>
         *        If set to <code>true</code>, then new controls for enabled standards are enabled automatically. If set
         *        to <code>false</code>, then new controls are not enabled.
         *        </p>
         *        <p>
         *        When you automatically enable new controls, you can interact with the controls in the console and
         *        programmatically immediately after release. However, automatically enabled controls have a temporary
         *        default status of <code>DISABLED</code>. It can take up to several days for Security Hub to process
         *        the control release and designate the control as <code>ENABLED</code> in your account. During the
         *        processing period, you can manually enable or disable a control, and Security Hub will maintain that
         *        designation regardless of whether you have <code>AutoEnableControls</code> set to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnableControls(Boolean autoEnableControls);

        /**
         * <p>
         * Specifies whether the calling account has consolidated control findings turned on. If the value for this
         * field is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control check
         * even when the check applies to multiple enabled standards.
         * </p>
         * <p>
         * If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate findings
         * for a control check when the check applies to multiple enabled standards.
         * </p>
         * <p>
         * The value for this field in a member account matches the value in the administrator account. For accounts
         * that aren't part of an organization, the default value of this field is <code>SECURITY_CONTROL</code> if you
         * enabled Security Hub on or after February 23, 2023.
         * </p>
         * 
         * @param controlFindingGenerator
         *        Specifies whether the calling account has consolidated control findings turned on. If the value for
         *        this field is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a
         *        control check even when the check applies to multiple enabled standards.</p>
         *        <p>
         *        If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate
         *        findings for a control check when the check applies to multiple enabled standards.
         *        </p>
         *        <p>
         *        The value for this field in a member account matches the value in the administrator account. For
         *        accounts that aren't part of an organization, the default value of this field is
         *        <code>SECURITY_CONTROL</code> if you enabled Security Hub on or after February 23, 2023.
         * @see ControlFindingGenerator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlFindingGenerator
         */
        Builder controlFindingGenerator(String controlFindingGenerator);

        /**
         * <p>
         * Specifies whether the calling account has consolidated control findings turned on. If the value for this
         * field is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control check
         * even when the check applies to multiple enabled standards.
         * </p>
         * <p>
         * If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate findings
         * for a control check when the check applies to multiple enabled standards.
         * </p>
         * <p>
         * The value for this field in a member account matches the value in the administrator account. For accounts
         * that aren't part of an organization, the default value of this field is <code>SECURITY_CONTROL</code> if you
         * enabled Security Hub on or after February 23, 2023.
         * </p>
         * 
         * @param controlFindingGenerator
         *        Specifies whether the calling account has consolidated control findings turned on. If the value for
         *        this field is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a
         *        control check even when the check applies to multiple enabled standards.</p>
         *        <p>
         *        If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate
         *        findings for a control check when the check applies to multiple enabled standards.
         *        </p>
         *        <p>
         *        The value for this field in a member account matches the value in the administrator account. For
         *        accounts that aren't part of an organization, the default value of this field is
         *        <code>SECURITY_CONTROL</code> if you enabled Security Hub on or after February 23, 2023.
         * @see ControlFindingGenerator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlFindingGenerator
         */
        Builder controlFindingGenerator(ControlFindingGenerator controlFindingGenerator);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String hubArn;

        private String subscribedAt;

        private Boolean autoEnableControls;

        private String controlFindingGenerator;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHubResponse model) {
            super(model);
            hubArn(model.hubArn);
            subscribedAt(model.subscribedAt);
            autoEnableControls(model.autoEnableControls);
            controlFindingGenerator(model.controlFindingGenerator);
        }

        public final String getHubArn() {
            return hubArn;
        }

        public final void setHubArn(String hubArn) {
            this.hubArn = hubArn;
        }

        @Override
        public final Builder hubArn(String hubArn) {
            this.hubArn = hubArn;
            return this;
        }

        public final String getSubscribedAt() {
            return subscribedAt;
        }

        public final void setSubscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
        }

        @Override
        public final Builder subscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
            return this;
        }

        public final Boolean getAutoEnableControls() {
            return autoEnableControls;
        }

        public final void setAutoEnableControls(Boolean autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
        }

        @Override
        public final Builder autoEnableControls(Boolean autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
            return this;
        }

        public final String getControlFindingGenerator() {
            return controlFindingGenerator;
        }

        public final void setControlFindingGenerator(String controlFindingGenerator) {
            this.controlFindingGenerator = controlFindingGenerator;
        }

        @Override
        public final Builder controlFindingGenerator(String controlFindingGenerator) {
            this.controlFindingGenerator = controlFindingGenerator;
            return this;
        }

        @Override
        public final Builder controlFindingGenerator(ControlFindingGenerator controlFindingGenerator) {
            this.controlFindingGenerator(controlFindingGenerator == null ? null : controlFindingGenerator.toString());
            return this;
        }

        @Override
        public DescribeHubResponse build() {
            return new DescribeHubResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
