/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A date filter for querying findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateFilter implements SdkPojo, Serializable, ToCopyableBuilder<DateFilter.Builder, DateFilter> {
    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Start")
            .getter(getter(DateFilter::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()).build();

    private static final SdkField<String> END_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("End")
            .getter(getter(DateFilter::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final SdkField<DateRange> DATE_RANGE_FIELD = SdkField.<DateRange> builder(MarshallingType.SDK_POJO)
            .memberName("DateRange").getter(getter(DateFilter::dateRange)).setter(setter(Builder::dateRange))
            .constructor(DateRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD,
            DATE_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String start;

    private final String end;

    private final DateRange dateRange;

    private DateFilter(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.dateRange = builder.dateRange;
    }

    /**
     * <p>
     * A timestamp that provides the start date for the date filter.
     * </p>
     * <p>
     * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     * </p>
     * 
     * @return A timestamp that provides the start date for the date filter.</p>
     *         <p>
     *         For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     */
    public final String start() {
        return start;
    }

    /**
     * <p>
     * A timestamp that provides the end date for the date filter.
     * </p>
     * <p>
     * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     * </p>
     * 
     * @return A timestamp that provides the end date for the date filter.</p>
     *         <p>
     *         For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     */
    public final String end() {
        return end;
    }

    /**
     * <p>
     * A date range for the date filter.
     * </p>
     * 
     * @return A date range for the date filter.
     */
    public final DateRange dateRange() {
        return dateRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(dateRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateFilter)) {
            return false;
        }
        DateFilter other = (DateFilter) obj;
        return Objects.equals(start(), other.start()) && Objects.equals(end(), other.end())
                && Objects.equals(dateRange(), other.dateRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateFilter").add("Start", start()).add("End", end()).add("DateRange", dateRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        case "DateRange":
            return Optional.ofNullable(clazz.cast(dateRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Start", START_FIELD);
        map.put("End", END_FIELD);
        map.put("DateRange", DATE_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateFilter, T> g) {
        return obj -> g.apply((DateFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateFilter> {
        /**
         * <p>
         * A timestamp that provides the start date for the date filter.
         * </p>
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * </p>
         * 
         * @param start
         *        A timestamp that provides the start date for the date filter.</p>
         *        <p>
         *        For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         *        href
         *        ="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);

        /**
         * <p>
         * A timestamp that provides the end date for the date filter.
         * </p>
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * </p>
         * 
         * @param end
         *        A timestamp that provides the end date for the date filter.</p>
         *        <p>
         *        For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         *        href
         *        ="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(String end);

        /**
         * <p>
         * A date range for the date filter.
         * </p>
         * 
         * @param dateRange
         *        A date range for the date filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateRange(DateRange dateRange);

        /**
         * <p>
         * A date range for the date filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateRange.Builder} avoiding the need to
         * create one manually via {@link DateRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateRange.Builder#build()} is called immediately and its result
         * is passed to {@link #dateRange(DateRange)}.
         * 
         * @param dateRange
         *        a consumer that will call methods on {@link DateRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateRange(DateRange)
         */
        default Builder dateRange(Consumer<DateRange.Builder> dateRange) {
            return dateRange(DateRange.builder().applyMutation(dateRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String start;

        private String end;

        private DateRange dateRange;

        private BuilderImpl() {
        }

        private BuilderImpl(DateFilter model) {
            start(model.start);
            end(model.end);
            dateRange(model.dateRange);
        }

        public final String getStart() {
            return start;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final String getEnd() {
            return end;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final DateRange.Builder getDateRange() {
            return dateRange != null ? dateRange.toBuilder() : null;
        }

        public final void setDateRange(DateRange.BuilderImpl dateRange) {
            this.dateRange = dateRange != null ? dateRange.build() : null;
        }

        @Override
        public final Builder dateRange(DateRange dateRange) {
            this.dateRange = dateRange;
            return this;
        }

        @Override
        public DateFilter build() {
            return new DateFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
