/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTicketV2Response extends SecurityHubResponse implements
        ToCopyableBuilder<CreateTicketV2Response.Builder, CreateTicketV2Response> {
    private static final SdkField<String> TICKET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TicketId").getter(getter(CreateTicketV2Response::ticketId)).setter(setter(Builder::ticketId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketId").build()).build();

    private static final SdkField<String> TICKET_SRC_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TicketSrcUrl").getter(getter(CreateTicketV2Response::ticketSrcUrl))
            .setter(setter(Builder::ticketSrcUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketSrcUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICKET_ID_FIELD,
            TICKET_SRC_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ticketId;

    private final String ticketSrcUrl;

    private CreateTicketV2Response(BuilderImpl builder) {
        super(builder);
        this.ticketId = builder.ticketId;
        this.ticketSrcUrl = builder.ticketSrcUrl;
    }

    /**
     * <p>
     * The ID for the ticketv2.
     * </p>
     * 
     * @return The ID for the ticketv2.
     */
    public final String ticketId() {
        return ticketId;
    }

    /**
     * <p>
     * The url to the created ticket.
     * </p>
     * 
     * @return The url to the created ticket.
     */
    public final String ticketSrcUrl() {
        return ticketSrcUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ticketId());
        hashCode = 31 * hashCode + Objects.hashCode(ticketSrcUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTicketV2Response)) {
            return false;
        }
        CreateTicketV2Response other = (CreateTicketV2Response) obj;
        return Objects.equals(ticketId(), other.ticketId()) && Objects.equals(ticketSrcUrl(), other.ticketSrcUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTicketV2Response").add("TicketId", ticketId()).add("TicketSrcUrl", ticketSrcUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TicketId":
            return Optional.ofNullable(clazz.cast(ticketId()));
        case "TicketSrcUrl":
            return Optional.ofNullable(clazz.cast(ticketSrcUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TicketId", TICKET_ID_FIELD);
        map.put("TicketSrcUrl", TICKET_SRC_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTicketV2Response, T> g) {
        return obj -> g.apply((CreateTicketV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTicketV2Response> {
        /**
         * <p>
         * The ID for the ticketv2.
         * </p>
         * 
         * @param ticketId
         *        The ID for the ticketv2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ticketId(String ticketId);

        /**
         * <p>
         * The url to the created ticket.
         * </p>
         * 
         * @param ticketSrcUrl
         *        The url to the created ticket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ticketSrcUrl(String ticketSrcUrl);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String ticketId;

        private String ticketSrcUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTicketV2Response model) {
            super(model);
            ticketId(model.ticketId);
            ticketSrcUrl(model.ticketSrcUrl);
        }

        public final String getTicketId() {
            return ticketId;
        }

        public final void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        @Override
        public final Builder ticketId(String ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public final String getTicketSrcUrl() {
            return ticketSrcUrl;
        }

        public final void setTicketSrcUrl(String ticketSrcUrl) {
            this.ticketSrcUrl = ticketSrcUrl;
        }

        @Override
        public final Builder ticketSrcUrl(String ticketSrcUrl) {
            this.ticketSrcUrl = ticketSrcUrl;
            return this;
        }

        @Override
        public CreateTicketV2Response build() {
            return new CreateTicketV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
