/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTicketV2Request extends SecurityHubRequest implements
        ToCopyableBuilder<CreateTicketV2Request.Builder, CreateTicketV2Request> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorId").getter(getter(CreateTicketV2Request::connectorId)).setter(setter(Builder::connectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()).build();

    private static final SdkField<String> FINDING_METADATA_UID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FindingMetadataUid").getter(getter(CreateTicketV2Request::findingMetadataUid))
            .setter(setter(Builder::findingMetadataUid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingMetadataUid").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateTicketV2Request::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(CreateTicketV2Request::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD,
            FINDING_METADATA_UID_FIELD, CLIENT_TOKEN_FIELD, MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectorId;

    private final String findingMetadataUid;

    private final String clientToken;

    private final String mode;

    private CreateTicketV2Request(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.findingMetadataUid = builder.findingMetadataUid;
        this.clientToken = builder.clientToken;
        this.mode = builder.mode;
    }

    /**
     * <p>
     * The UUID of the connectorV2 to identify connectorV2 resource.
     * </p>
     * 
     * @return The UUID of the connectorV2 to identify connectorV2 resource.
     */
    public final String connectorId() {
        return connectorId;
    }

    /**
     * <p>
     * The the unique ID for the finding.
     * </p>
     * 
     * @return The the unique ID for the finding.
     */
    public final String findingMetadataUid() {
        return findingMetadataUid;
    }

    /**
     * <p>
     * The client idempotency token.
     * </p>
     * 
     * @return The client idempotency token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The mode for ticket creation. When set to DRYRUN, the ticket is created using a Security Hub owned template test
     * finding to verify the integration is working correctly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link TicketCreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode for ticket creation. When set to DRYRUN, the ticket is created using a Security Hub owned
     *         template test finding to verify the integration is working correctly.
     * @see TicketCreationMode
     */
    public final TicketCreationMode mode() {
        return TicketCreationMode.fromValue(mode);
    }

    /**
     * <p>
     * The mode for ticket creation. When set to DRYRUN, the ticket is created using a Security Hub owned template test
     * finding to verify the integration is working correctly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link TicketCreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode for ticket creation. When set to DRYRUN, the ticket is created using a Security Hub owned
     *         template test finding to verify the integration is working correctly.
     * @see TicketCreationMode
     */
    public final String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(findingMetadataUid());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTicketV2Request)) {
            return false;
        }
        CreateTicketV2Request other = (CreateTicketV2Request) obj;
        return Objects.equals(connectorId(), other.connectorId())
                && Objects.equals(findingMetadataUid(), other.findingMetadataUid())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(modeAsString(), other.modeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTicketV2Request").add("ConnectorId", connectorId())
                .add("FindingMetadataUid", findingMetadataUid()).add("ClientToken", clientToken()).add("Mode", modeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorId":
            return Optional.ofNullable(clazz.cast(connectorId()));
        case "FindingMetadataUid":
            return Optional.ofNullable(clazz.cast(findingMetadataUid()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("FindingMetadataUid", FINDING_METADATA_UID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Mode", MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTicketV2Request, T> g) {
        return obj -> g.apply((CreateTicketV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTicketV2Request> {
        /**
         * <p>
         * The UUID of the connectorV2 to identify connectorV2 resource.
         * </p>
         * 
         * @param connectorId
         *        The UUID of the connectorV2 to identify connectorV2 resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorId(String connectorId);

        /**
         * <p>
         * The the unique ID for the finding.
         * </p>
         * 
         * @param findingMetadataUid
         *        The the unique ID for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingMetadataUid(String findingMetadataUid);

        /**
         * <p>
         * The client idempotency token.
         * </p>
         * 
         * @param clientToken
         *        The client idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The mode for ticket creation. When set to DRYRUN, the ticket is created using a Security Hub owned template
         * test finding to verify the integration is working correctly.
         * </p>
         * 
         * @param mode
         *        The mode for ticket creation. When set to DRYRUN, the ticket is created using a Security Hub owned
         *        template test finding to verify the integration is working correctly.
         * @see TicketCreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TicketCreationMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The mode for ticket creation. When set to DRYRUN, the ticket is created using a Security Hub owned template
         * test finding to verify the integration is working correctly.
         * </p>
         * 
         * @param mode
         *        The mode for ticket creation. When set to DRYRUN, the ticket is created using a Security Hub owned
         *        template test finding to verify the integration is working correctly.
         * @see TicketCreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TicketCreationMode
         */
        Builder mode(TicketCreationMode mode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String connectorId;

        private String findingMetadataUid;

        private String clientToken;

        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTicketV2Request model) {
            super(model);
            connectorId(model.connectorId);
            findingMetadataUid(model.findingMetadataUid);
            clientToken(model.clientToken);
            mode(model.mode);
        }

        public final String getConnectorId() {
            return connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getFindingMetadataUid() {
            return findingMetadataUid;
        }

        public final void setFindingMetadataUid(String findingMetadataUid) {
            this.findingMetadataUid = findingMetadataUid;
        }

        @Override
        public final Builder findingMetadataUid(String findingMetadataUid) {
            this.findingMetadataUid = findingMetadataUid;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(TicketCreationMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTicketV2Request build() {
            return new CreateTicketV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
