/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInsightResponse extends SecurityHubResponse implements
        ToCopyableBuilder<CreateInsightResponse.Builder, CreateInsightResponse> {
    private static final SdkField<String> INSIGHT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InsightArn").getter(getter(CreateInsightResponse::insightArn)).setter(setter(Builder::insightArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String insightArn;

    private CreateInsightResponse(BuilderImpl builder) {
        super(builder);
        this.insightArn = builder.insightArn;
    }

    /**
     * <p>
     * The ARN of the insight created.
     * </p>
     * 
     * @return The ARN of the insight created.
     */
    public final String insightArn() {
        return insightArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(insightArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInsightResponse)) {
            return false;
        }
        CreateInsightResponse other = (CreateInsightResponse) obj;
        return Objects.equals(insightArn(), other.insightArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInsightResponse").add("InsightArn", insightArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightArn":
            return Optional.ofNullable(clazz.cast(insightArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InsightArn", INSIGHT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInsightResponse, T> g) {
        return obj -> g.apply((CreateInsightResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateInsightResponse> {
        /**
         * <p>
         * The ARN of the insight created.
         * </p>
         * 
         * @param insightArn
         *        The ARN of the insight created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightArn(String insightArn);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String insightArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInsightResponse model) {
            super(model);
            insightArn(model.insightArn);
        }

        public final String getInsightArn() {
            return insightArn;
        }

        public final void setInsightArn(String insightArn) {
            this.insightArn = insightArn;
        }

        @Override
        public final Builder insightArn(String insightArn) {
            this.insightArn = insightArn;
            return this;
        }

        @Override
        public CreateInsightResponse build() {
            return new CreateInsightResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
