/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectorV2Response extends SecurityHubResponse implements
        ToCopyableBuilder<CreateConnectorV2Response.Builder, CreateConnectorV2Response> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorArn").getter(getter(CreateConnectorV2Response::connectorArn))
            .setter(setter(Builder::connectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorArn").build()).build();

    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorId").getter(getter(CreateConnectorV2Response::connectorId))
            .setter(setter(Builder::connectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()).build();

    private static final SdkField<String> AUTH_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthUrl").getter(getter(CreateConnectorV2Response::authUrl)).setter(setter(Builder::authUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthUrl").build()).build();

    private static final SdkField<String> CONNECTOR_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorStatus").getter(getter(CreateConnectorV2Response::connectorStatusAsString))
            .setter(setter(Builder::connectorStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD,
            CONNECTOR_ID_FIELD, AUTH_URL_FIELD, CONNECTOR_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectorArn;

    private final String connectorId;

    private final String authUrl;

    private final String connectorStatus;

    private CreateConnectorV2Response(BuilderImpl builder) {
        super(builder);
        this.connectorArn = builder.connectorArn;
        this.connectorId = builder.connectorId;
        this.authUrl = builder.authUrl;
        this.connectorStatus = builder.connectorStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connectorV2.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connectorV2.
     */
    public final String connectorArn() {
        return connectorArn;
    }

    /**
     * <p>
     * The UUID of the connectorV2 to identify connectorV2 resource.
     * </p>
     * 
     * @return The UUID of the connectorV2 to identify connectorV2 resource.
     */
    public final String connectorId() {
        return connectorId;
    }

    /**
     * <p>
     * The Url provide to customers for OAuth auth code flow.
     * </p>
     * 
     * @return The Url provide to customers for OAuth auth code flow.
     */
    public final String authUrl() {
        return authUrl;
    }

    /**
     * <p>
     * The current status of the connectorV2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorStatus}
     * will return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectorStatusAsString}.
     * </p>
     * 
     * @return The current status of the connectorV2.
     * @see ConnectorStatus
     */
    public final ConnectorStatus connectorStatus() {
        return ConnectorStatus.fromValue(connectorStatus);
    }

    /**
     * <p>
     * The current status of the connectorV2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorStatus}
     * will return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectorStatusAsString}.
     * </p>
     * 
     * @return The current status of the connectorV2.
     * @see ConnectorStatus
     */
    public final String connectorStatusAsString() {
        return connectorStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(authUrl());
        hashCode = 31 * hashCode + Objects.hashCode(connectorStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorV2Response)) {
            return false;
        }
        CreateConnectorV2Response other = (CreateConnectorV2Response) obj;
        return Objects.equals(connectorArn(), other.connectorArn()) && Objects.equals(connectorId(), other.connectorId())
                && Objects.equals(authUrl(), other.authUrl())
                && Objects.equals(connectorStatusAsString(), other.connectorStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectorV2Response").add("ConnectorArn", connectorArn())
                .add("ConnectorId", connectorId()).add("AuthUrl", authUrl()).add("ConnectorStatus", connectorStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorArn":
            return Optional.ofNullable(clazz.cast(connectorArn()));
        case "ConnectorId":
            return Optional.ofNullable(clazz.cast(connectorId()));
        case "AuthUrl":
            return Optional.ofNullable(clazz.cast(authUrl()));
        case "ConnectorStatus":
            return Optional.ofNullable(clazz.cast(connectorStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorArn", CONNECTOR_ARN_FIELD);
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("AuthUrl", AUTH_URL_FIELD);
        map.put("ConnectorStatus", CONNECTOR_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorV2Response, T> g) {
        return obj -> g.apply((CreateConnectorV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectorV2Response> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connectorV2.
         * </p>
         * 
         * @param connectorArn
         *        The Amazon Resource Name (ARN) of the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorArn(String connectorArn);

        /**
         * <p>
         * The UUID of the connectorV2 to identify connectorV2 resource.
         * </p>
         * 
         * @param connectorId
         *        The UUID of the connectorV2 to identify connectorV2 resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorId(String connectorId);

        /**
         * <p>
         * The Url provide to customers for OAuth auth code flow.
         * </p>
         * 
         * @param authUrl
         *        The Url provide to customers for OAuth auth code flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authUrl(String authUrl);

        /**
         * <p>
         * The current status of the connectorV2.
         * </p>
         * 
         * @param connectorStatus
         *        The current status of the connectorV2.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder connectorStatus(String connectorStatus);

        /**
         * <p>
         * The current status of the connectorV2.
         * </p>
         * 
         * @param connectorStatus
         *        The current status of the connectorV2.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder connectorStatus(ConnectorStatus connectorStatus);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String connectorArn;

        private String connectorId;

        private String authUrl;

        private String connectorStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorV2Response model) {
            super(model);
            connectorArn(model.connectorArn);
            connectorId(model.connectorId);
            authUrl(model.authUrl);
            connectorStatus(model.connectorStatus);
        }

        public final String getConnectorArn() {
            return connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final String getConnectorId() {
            return connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getAuthUrl() {
            return authUrl;
        }

        public final void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }

        @Override
        public final Builder authUrl(String authUrl) {
            this.authUrl = authUrl;
            return this;
        }

        public final String getConnectorStatus() {
            return connectorStatus;
        }

        public final void setConnectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
        }

        @Override
        public final Builder connectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
            return this;
        }

        @Override
        public final Builder connectorStatus(ConnectorStatus connectorStatus) {
            this.connectorStatus(connectorStatus == null ? null : connectorStatus.toString());
            return this;
        }

        @Override
        public CreateConnectorV2Response build() {
            return new CreateConnectorV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
