/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfigurationPolicyRequest extends SecurityHubRequest implements
        ToCopyableBuilder<CreateConfigurationPolicyRequest.Builder, CreateConfigurationPolicyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateConfigurationPolicyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateConfigurationPolicyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Policy> CONFIGURATION_POLICY_FIELD = SdkField.<Policy> builder(MarshallingType.SDK_POJO)
            .memberName("ConfigurationPolicy").getter(getter(CreateConfigurationPolicyRequest::configurationPolicy))
            .setter(setter(Builder::configurationPolicy)).constructor(Policy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicy").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateConfigurationPolicyRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CONFIGURATION_POLICY_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final Policy configurationPolicy;

    private final Map<String, String> tags;

    private CreateConfigurationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.configurationPolicy = builder.configurationPolicy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the configuration policy. Alphanumeric characters and the following ASCII characters are permitted:
     * <code>-, ., !, *, /</code>.
     * </p>
     * 
     * @return The name of the configuration policy. Alphanumeric characters and the following ASCII characters are
     *         permitted: <code>-, ., !, *, /</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the configuration policy.
     * </p>
     * 
     * @return The description of the configuration policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or disabled, a
     * list of enabled security standards, a list of enabled or disabled security controls, and a list of custom
     * parameter values for specified controls. If you provide a list of security controls that are enabled in the
     * configuration policy, Security Hub disables all other controls (including newly released controls). If you
     * provide a list of security controls that are disabled in the configuration policy, Security Hub enables all other
     * controls (including newly released controls).
     * </p>
     * 
     * @return An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or
     *         disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a
     *         list of custom parameter values for specified controls. If you provide a list of security controls that
     *         are enabled in the configuration policy, Security Hub disables all other controls (including newly
     *         released controls). If you provide a list of security controls that are disabled in the configuration
     *         policy, Security Hub enables all other controls (including newly released controls).
     */
    public final Policy configurationPolicy() {
        return configurationPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * User-defined tags associated with a configuration policy. For more information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/tagging-resources.html">Tagging Security Hub
     * resources</a> in the <i>Security Hub user guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return User-defined tags associated with a configuration policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/securityhub/latest/userguide/tagging-resources.html">Tagging Security
     *         Hub resources</a> in the <i>Security Hub user guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(configurationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationPolicyRequest)) {
            return false;
        }
        CreateConfigurationPolicyRequest other = (CreateConfigurationPolicyRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(configurationPolicy(), other.configurationPolicy()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConfigurationPolicyRequest").add("Name", name()).add("Description", description())
                .add("ConfigurationPolicy", configurationPolicy()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ConfigurationPolicy":
            return Optional.ofNullable(clazz.cast(configurationPolicy()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ConfigurationPolicy", CONFIGURATION_POLICY_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationPolicyRequest, T> g) {
        return obj -> g.apply((CreateConfigurationPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConfigurationPolicyRequest> {
        /**
         * <p>
         * The name of the configuration policy. Alphanumeric characters and the following ASCII characters are
         * permitted: <code>-, ., !, *, /</code>.
         * </p>
         * 
         * @param name
         *        The name of the configuration policy. Alphanumeric characters and the following ASCII characters are
         *        permitted: <code>-, ., !, *, /</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the configuration policy.
         * </p>
         * 
         * @param description
         *        The description of the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or
         * disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list
         * of custom parameter values for specified controls. If you provide a list of security controls that are
         * enabled in the configuration policy, Security Hub disables all other controls (including newly released
         * controls). If you provide a list of security controls that are disabled in the configuration policy, Security
         * Hub enables all other controls (including newly released controls).
         * </p>
         * 
         * @param configurationPolicy
         *        An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or
         *        disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a
         *        list of custom parameter values for specified controls. If you provide a list of security controls
         *        that are enabled in the configuration policy, Security Hub disables all other controls (including
         *        newly released controls). If you provide a list of security controls that are disabled in the
         *        configuration policy, Security Hub enables all other controls (including newly released controls).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationPolicy(Policy configurationPolicy);

        /**
         * <p>
         * An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or
         * disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list
         * of custom parameter values for specified controls. If you provide a list of security controls that are
         * enabled in the configuration policy, Security Hub disables all other controls (including newly released
         * controls). If you provide a list of security controls that are disabled in the configuration policy, Security
         * Hub enables all other controls (including newly released controls).
         * </p>
         * This is a convenience method that creates an instance of the {@link Policy.Builder} avoiding the need to
         * create one manually via {@link Policy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Policy.Builder#build()} is called immediately and its result is
         * passed to {@link #configurationPolicy(Policy)}.
         * 
         * @param configurationPolicy
         *        a consumer that will call methods on {@link Policy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationPolicy(Policy)
         */
        default Builder configurationPolicy(Consumer<Policy.Builder> configurationPolicy) {
            return configurationPolicy(Policy.builder().applyMutation(configurationPolicy).build());
        }

        /**
         * <p>
         * User-defined tags associated with a configuration policy. For more information, see <a
         * href="https://docs.aws.amazon.com/securityhub/latest/userguide/tagging-resources.html">Tagging Security Hub
         * resources</a> in the <i>Security Hub user guide</i>.
         * </p>
         * 
         * @param tags
         *        User-defined tags associated with a configuration policy. For more information, see <a
         *        href="https://docs.aws.amazon.com/securityhub/latest/userguide/tagging-resources.html">Tagging
         *        Security Hub resources</a> in the <i>Security Hub user guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private Policy configurationPolicy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationPolicyRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            configurationPolicy(model.configurationPolicy);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Policy.Builder getConfigurationPolicy() {
            return configurationPolicy != null ? configurationPolicy.toBuilder() : null;
        }

        public final void setConfigurationPolicy(Policy.BuilderImpl configurationPolicy) {
            this.configurationPolicy = configurationPolicy != null ? configurationPolicy.build() : null;
        }

        @Override
        public final Builder configurationPolicy(Policy configurationPolicy) {
            this.configurationPolicy = configurationPolicy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationPolicyRequest build() {
            return new CreateConfigurationPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
