/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A condensed overview of the connectorV2..
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorSummary.Builder, ConnectorSummary> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorArn").getter(getter(ConnectorSummary::connectorArn)).setter(setter(Builder::connectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorArn").build()).build();

    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorId").getter(getter(ConnectorSummary::connectorId)).setter(setter(Builder::connectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ConnectorSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ConnectorSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ProviderSummary> PROVIDER_SUMMARY_FIELD = SdkField
            .<ProviderSummary> builder(MarshallingType.SDK_POJO).memberName("ProviderSummary")
            .getter(getter(ConnectorSummary::providerSummary)).setter(setter(Builder::providerSummary))
            .constructor(ProviderSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderSummary").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(ConnectorSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD,
            CONNECTOR_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, PROVIDER_SUMMARY_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectorArn;

    private final String connectorId;

    private final String name;

    private final String description;

    private final ProviderSummary providerSummary;

    private final Instant createdAt;

    private ConnectorSummary(BuilderImpl builder) {
        this.connectorArn = builder.connectorArn;
        this.connectorId = builder.connectorId;
        this.name = builder.name;
        this.description = builder.description;
        this.providerSummary = builder.providerSummary;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connectorV2.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connectorV2.
     */
    public final String connectorArn() {
        return connectorArn;
    }

    /**
     * <p>
     * The UUID of the connectorV2 to identify connectorV2 resource.
     * </p>
     * 
     * @return The UUID of the connectorV2 to identify connectorV2 resource.
     */
    public final String connectorId() {
        return connectorId;
    }

    /**
     * <p>
     * The Name field contains the user-defined name assigned to the integration connector. This helps identify and
     * manage multiple connectors within Security Hub.
     * </p>
     * 
     * @return The Name field contains the user-defined name assigned to the integration connector. This helps identify
     *         and manage multiple connectors within Security Hub.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the connectorV2.
     * </p>
     * 
     * @return The description of the connectorV2.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The connectorV2 third party provider configuration summary.
     * </p>
     * 
     * @return The connectorV2 third party provider configuration summary.
     */
    public final ProviderSummary providerSummary() {
        return providerSummary;
    }

    /**
     * <p>
     * ISO 8601 UTC timestamp for the time create the connectorV2.
     * </p>
     * 
     * @return ISO 8601 UTC timestamp for the time create the connectorV2.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(providerSummary());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorSummary)) {
            return false;
        }
        ConnectorSummary other = (ConnectorSummary) obj;
        return Objects.equals(connectorArn(), other.connectorArn()) && Objects.equals(connectorId(), other.connectorId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(providerSummary(), other.providerSummary()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorSummary").add("ConnectorArn", connectorArn()).add("ConnectorId", connectorId())
                .add("Name", name()).add("Description", description()).add("ProviderSummary", providerSummary())
                .add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorArn":
            return Optional.ofNullable(clazz.cast(connectorArn()));
        case "ConnectorId":
            return Optional.ofNullable(clazz.cast(connectorId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ProviderSummary":
            return Optional.ofNullable(clazz.cast(providerSummary()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorArn", CONNECTOR_ARN_FIELD);
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ProviderSummary", PROVIDER_SUMMARY_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorSummary, T> g) {
        return obj -> g.apply((ConnectorSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connectorV2.
         * </p>
         * 
         * @param connectorArn
         *        The Amazon Resource Name (ARN) of the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorArn(String connectorArn);

        /**
         * <p>
         * The UUID of the connectorV2 to identify connectorV2 resource.
         * </p>
         * 
         * @param connectorId
         *        The UUID of the connectorV2 to identify connectorV2 resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorId(String connectorId);

        /**
         * <p>
         * The Name field contains the user-defined name assigned to the integration connector. This helps identify and
         * manage multiple connectors within Security Hub.
         * </p>
         * 
         * @param name
         *        The Name field contains the user-defined name assigned to the integration connector. This helps
         *        identify and manage multiple connectors within Security Hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the connectorV2.
         * </p>
         * 
         * @param description
         *        The description of the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The connectorV2 third party provider configuration summary.
         * </p>
         * 
         * @param providerSummary
         *        The connectorV2 third party provider configuration summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerSummary(ProviderSummary providerSummary);

        /**
         * <p>
         * The connectorV2 third party provider configuration summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProviderSummary.Builder} avoiding the
         * need to create one manually via {@link ProviderSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #providerSummary(ProviderSummary)}.
         * 
         * @param providerSummary
         *        a consumer that will call methods on {@link ProviderSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providerSummary(ProviderSummary)
         */
        default Builder providerSummary(Consumer<ProviderSummary.Builder> providerSummary) {
            return providerSummary(ProviderSummary.builder().applyMutation(providerSummary).build());
        }

        /**
         * <p>
         * ISO 8601 UTC timestamp for the time create the connectorV2.
         * </p>
         * 
         * @param createdAt
         *        ISO 8601 UTC timestamp for the time create the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String connectorArn;

        private String connectorId;

        private String name;

        private String description;

        private ProviderSummary providerSummary;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorSummary model) {
            connectorArn(model.connectorArn);
            connectorId(model.connectorId);
            name(model.name);
            description(model.description);
            providerSummary(model.providerSummary);
            createdAt(model.createdAt);
        }

        public final String getConnectorArn() {
            return connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final String getConnectorId() {
            return connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ProviderSummary.Builder getProviderSummary() {
            return providerSummary != null ? providerSummary.toBuilder() : null;
        }

        public final void setProviderSummary(ProviderSummary.BuilderImpl providerSummary) {
            this.providerSummary = providerSummary != null ? providerSummary.build() : null;
        }

        @Override
        public final Builder providerSummary(ProviderSummary providerSummary) {
            this.providerSummary = providerSummary;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public ConnectorSummary build() {
            return new ConnectorSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
