/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the details of an Security Hub configuration policy that’s returned in a
 * <code>ListConfigurationPolicies</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationPolicySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationPolicySummary.Builder, ConfigurationPolicySummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ConfigurationPolicySummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ConfigurationPolicySummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ConfigurationPolicySummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ConfigurationPolicySummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt")
            .getter(getter(ConfigurationPolicySummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> SERVICE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ServiceEnabled").getter(getter(ConfigurationPolicySummary::serviceEnabled))
            .setter(setter(Builder::serviceEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, UPDATED_AT_FIELD, SERVICE_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String name;

    private final String description;

    private final Instant updatedAt;

    private final Boolean serviceEnabled;

    private ConfigurationPolicySummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.updatedAt = builder.updatedAt;
        this.serviceEnabled = builder.serviceEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configuration policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configuration policy.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The universally unique identifier (UUID) of the configuration policy.
     * </p>
     * 
     * @return The universally unique identifier (UUID) of the configuration policy.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the configuration policy. Alphanumeric characters and the following ASCII characters are permitted:
     * <code>-, ., !, *, /</code>.
     * </p>
     * 
     * @return The name of the configuration policy. Alphanumeric characters and the following ASCII characters are
     *         permitted: <code>-, ., !, *, /</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the configuration policy.
     * </p>
     * 
     * @return The description of the configuration policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time, in UTC and ISO 8601 format, that the configuration policy was last updated.
     * </p>
     * 
     * @return The date and time, in UTC and ISO 8601 format, that the configuration policy was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * Indicates whether the service that the configuration policy applies to is enabled in the policy.
     * </p>
     * 
     * @return Indicates whether the service that the configuration policy applies to is enabled in the policy.
     */
    public final Boolean serviceEnabled() {
        return serviceEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(serviceEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationPolicySummary)) {
            return false;
        }
        ConfigurationPolicySummary other = (ConfigurationPolicySummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(serviceEnabled(), other.serviceEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationPolicySummary").add("Arn", arn()).add("Id", id()).add("Name", name())
                .add("Description", description()).add("UpdatedAt", updatedAt()).add("ServiceEnabled", serviceEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "ServiceEnabled":
            return Optional.ofNullable(clazz.cast(serviceEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("ServiceEnabled", SERVICE_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationPolicySummary, T> g) {
        return obj -> g.apply((ConfigurationPolicySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationPolicySummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configuration policy.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The universally unique identifier (UUID) of the configuration policy.
         * </p>
         * 
         * @param id
         *        The universally unique identifier (UUID) of the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the configuration policy. Alphanumeric characters and the following ASCII characters are
         * permitted: <code>-, ., !, *, /</code>.
         * </p>
         * 
         * @param name
         *        The name of the configuration policy. Alphanumeric characters and the following ASCII characters are
         *        permitted: <code>-, ., !, *, /</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the configuration policy.
         * </p>
         * 
         * @param description
         *        The description of the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time, in UTC and ISO 8601 format, that the configuration policy was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time, in UTC and ISO 8601 format, that the configuration policy was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Indicates whether the service that the configuration policy applies to is enabled in the policy.
         * </p>
         * 
         * @param serviceEnabled
         *        Indicates whether the service that the configuration policy applies to is enabled in the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceEnabled(Boolean serviceEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String name;

        private String description;

        private Instant updatedAt;

        private Boolean serviceEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationPolicySummary model) {
            arn(model.arn);
            id(model.id);
            name(model.name);
            description(model.description);
            updatedAt(model.updatedAt);
            serviceEnabled(model.serviceEnabled);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Boolean getServiceEnabled() {
            return serviceEnabled;
        }

        public final void setServiceEnabled(Boolean serviceEnabled) {
            this.serviceEnabled = serviceEnabled;
        }

        @Override
        public final Builder serviceEnabled(Boolean serviceEnabled) {
            this.serviceEnabled = serviceEnabled;
            return this;
        }

        @Override
        public ConfigurationPolicySummary build() {
            return new ConfigurationPolicySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
