/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for customizing a security control parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationOptions.Builder, ConfigurationOptions> {
    private static final SdkField<IntegerConfigurationOptions> INTEGER_FIELD = SdkField
            .<IntegerConfigurationOptions> builder(MarshallingType.SDK_POJO).memberName("Integer")
            .getter(getter(ConfigurationOptions::integer)).setter(setter(Builder::integer))
            .constructor(IntegerConfigurationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Integer").build()).build();

    private static final SdkField<IntegerListConfigurationOptions> INTEGER_LIST_FIELD = SdkField
            .<IntegerListConfigurationOptions> builder(MarshallingType.SDK_POJO).memberName("IntegerList")
            .getter(getter(ConfigurationOptions::integerList)).setter(setter(Builder::integerList))
            .constructor(IntegerListConfigurationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerList").build()).build();

    private static final SdkField<DoubleConfigurationOptions> DOUBLE_FIELD = SdkField
            .<DoubleConfigurationOptions> builder(MarshallingType.SDK_POJO).memberName("Double")
            .getter(getter(ConfigurationOptions::doubleValue)).setter(setter(Builder::doubleValue))
            .constructor(DoubleConfigurationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Double").build()).build();

    private static final SdkField<StringConfigurationOptions> STRING_FIELD = SdkField
            .<StringConfigurationOptions> builder(MarshallingType.SDK_POJO).memberName("String")
            .getter(getter(ConfigurationOptions::string)).setter(setter(Builder::string))
            .constructor(StringConfigurationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("String").build()).build();

    private static final SdkField<StringListConfigurationOptions> STRING_LIST_FIELD = SdkField
            .<StringListConfigurationOptions> builder(MarshallingType.SDK_POJO).memberName("StringList")
            .getter(getter(ConfigurationOptions::stringList)).setter(setter(Builder::stringList))
            .constructor(StringListConfigurationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringList").build()).build();

    private static final SdkField<BooleanConfigurationOptions> BOOLEAN_FIELD = SdkField
            .<BooleanConfigurationOptions> builder(MarshallingType.SDK_POJO).memberName("Boolean")
            .getter(getter(ConfigurationOptions::booleanValue)).setter(setter(Builder::booleanValue))
            .constructor(BooleanConfigurationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Boolean").build()).build();

    private static final SdkField<EnumConfigurationOptions> ENUM_FIELD = SdkField
            .<EnumConfigurationOptions> builder(MarshallingType.SDK_POJO).memberName("Enum")
            .getter(getter(ConfigurationOptions::enumValue)).setter(setter(Builder::enumValue))
            .constructor(EnumConfigurationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enum").build()).build();

    private static final SdkField<EnumListConfigurationOptions> ENUM_LIST_FIELD = SdkField
            .<EnumListConfigurationOptions> builder(MarshallingType.SDK_POJO).memberName("EnumList")
            .getter(getter(ConfigurationOptions::enumList)).setter(setter(Builder::enumList))
            .constructor(EnumListConfigurationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnumList").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_FIELD,
            INTEGER_LIST_FIELD, DOUBLE_FIELD, STRING_FIELD, STRING_LIST_FIELD, BOOLEAN_FIELD, ENUM_FIELD, ENUM_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IntegerConfigurationOptions integer;

    private final IntegerListConfigurationOptions integerList;

    private final DoubleConfigurationOptions doubleValue;

    private final StringConfigurationOptions string;

    private final StringListConfigurationOptions stringList;

    private final BooleanConfigurationOptions booleanValue;

    private final EnumConfigurationOptions enumValue;

    private final EnumListConfigurationOptions enumList;

    private final Type type;

    private ConfigurationOptions(BuilderImpl builder) {
        this.integer = builder.integer;
        this.integerList = builder.integerList;
        this.doubleValue = builder.doubleValue;
        this.string = builder.string;
        this.stringList = builder.stringList;
        this.booleanValue = builder.booleanValue;
        this.enumValue = builder.enumValue;
        this.enumList = builder.enumList;
        this.type = builder.type;
    }

    /**
     * <p>
     * The options for customizing a security control parameter that is an integer.
     * </p>
     * 
     * @return The options for customizing a security control parameter that is an integer.
     */
    public final IntegerConfigurationOptions integer() {
        return integer;
    }

    /**
     * <p>
     * The options for customizing a security control parameter that is a list of integers.
     * </p>
     * 
     * @return The options for customizing a security control parameter that is a list of integers.
     */
    public final IntegerListConfigurationOptions integerList() {
        return integerList;
    }

    /**
     * <p>
     * The options for customizing a security control parameter that is a double.
     * </p>
     * 
     * @return The options for customizing a security control parameter that is a double.
     */
    public final DoubleConfigurationOptions doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * The options for customizing a security control parameter that is a string data type.
     * </p>
     * 
     * @return The options for customizing a security control parameter that is a string data type.
     */
    public final StringConfigurationOptions string() {
        return string;
    }

    /**
     * <p>
     * The options for customizing a security control parameter that is a list of strings.
     * </p>
     * 
     * @return The options for customizing a security control parameter that is a list of strings.
     */
    public final StringListConfigurationOptions stringList() {
        return stringList;
    }

    /**
     * <p>
     * The options for customizing a security control parameter that is a boolean. For a boolean parameter, the options
     * are <code>true</code> and <code>false</code>.
     * </p>
     * 
     * @return The options for customizing a security control parameter that is a boolean. For a boolean parameter, the
     *         options are <code>true</code> and <code>false</code>.
     */
    public final BooleanConfigurationOptions booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * The options for customizing a security control parameter that is an enum.
     * </p>
     * 
     * @return The options for customizing a security control parameter that is an enum.
     */
    public final EnumConfigurationOptions enumValue() {
        return enumValue;
    }

    /**
     * <p>
     * The options for customizing a security control parameter that is a list of enums.
     * </p>
     * 
     * @return The options for customizing a security control parameter that is a list of enums.
     */
    public final EnumListConfigurationOptions enumList() {
        return enumList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(integer());
        hashCode = 31 * hashCode + Objects.hashCode(integerList());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(string());
        hashCode = 31 * hashCode + Objects.hashCode(stringList());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(enumValue());
        hashCode = 31 * hashCode + Objects.hashCode(enumList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationOptions)) {
            return false;
        }
        ConfigurationOptions other = (ConfigurationOptions) obj;
        return Objects.equals(integer(), other.integer()) && Objects.equals(integerList(), other.integerList())
                && Objects.equals(doubleValue(), other.doubleValue()) && Objects.equals(string(), other.string())
                && Objects.equals(stringList(), other.stringList()) && Objects.equals(booleanValue(), other.booleanValue())
                && Objects.equals(enumValue(), other.enumValue()) && Objects.equals(enumList(), other.enumList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationOptions").add("Integer", integer()).add("IntegerList", integerList())
                .add("Double", doubleValue()).add("String", string()).add("StringList", stringList())
                .add("Boolean", booleanValue()).add("Enum", enumValue()).add("EnumList", enumList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Integer":
            return Optional.ofNullable(clazz.cast(integer()));
        case "IntegerList":
            return Optional.ofNullable(clazz.cast(integerList()));
        case "Double":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "String":
            return Optional.ofNullable(clazz.cast(string()));
        case "StringList":
            return Optional.ofNullable(clazz.cast(stringList()));
        case "Boolean":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "Enum":
            return Optional.ofNullable(clazz.cast(enumValue()));
        case "EnumList":
            return Optional.ofNullable(clazz.cast(enumList()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #integer()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is an integer.
     * </p>
     * 
     * @param integer
     *        The options for customizing a security control parameter that is an integer.
     */
    public static ConfigurationOptions fromInteger(IntegerConfigurationOptions integer) {
        return builder().integer(integer).build();
    }

    /**
     * Create an instance of this class with {@link #integer()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is an integer.
     * </p>
     * 
     * @param integer
     *        The options for customizing a security control parameter that is an integer.
     */
    public static ConfigurationOptions fromInteger(Consumer<IntegerConfigurationOptions.Builder> integer) {
        IntegerConfigurationOptions.Builder builder = IntegerConfigurationOptions.builder();
        integer.accept(builder);
        return fromInteger(builder.build());
    }

    /**
     * Create an instance of this class with {@link #integerList()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is a list of integers.
     * </p>
     * 
     * @param integerList
     *        The options for customizing a security control parameter that is a list of integers.
     */
    public static ConfigurationOptions fromIntegerList(IntegerListConfigurationOptions integerList) {
        return builder().integerList(integerList).build();
    }

    /**
     * Create an instance of this class with {@link #integerList()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is a list of integers.
     * </p>
     * 
     * @param integerList
     *        The options for customizing a security control parameter that is a list of integers.
     */
    public static ConfigurationOptions fromIntegerList(Consumer<IntegerListConfigurationOptions.Builder> integerList) {
        IntegerListConfigurationOptions.Builder builder = IntegerListConfigurationOptions.builder();
        integerList.accept(builder);
        return fromIntegerList(builder.build());
    }

    /**
     * Create an instance of this class with {@link #doubleValue()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is a double.
     * </p>
     * 
     * @param doubleValue
     *        The options for customizing a security control parameter that is a double.
     */
    public static ConfigurationOptions fromDoubleValue(DoubleConfigurationOptions doubleValue) {
        return builder().doubleValue(doubleValue).build();
    }

    /**
     * Create an instance of this class with {@link #doubleValue()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is a double.
     * </p>
     * 
     * @param doubleValue
     *        The options for customizing a security control parameter that is a double.
     */
    public static ConfigurationOptions fromDoubleValue(Consumer<DoubleConfigurationOptions.Builder> doubleValue) {
        DoubleConfigurationOptions.Builder builder = DoubleConfigurationOptions.builder();
        doubleValue.accept(builder);
        return fromDoubleValue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #string()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is a string data type.
     * </p>
     * 
     * @param string
     *        The options for customizing a security control parameter that is a string data type.
     */
    public static ConfigurationOptions fromString(StringConfigurationOptions string) {
        return builder().string(string).build();
    }

    /**
     * Create an instance of this class with {@link #string()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is a string data type.
     * </p>
     * 
     * @param string
     *        The options for customizing a security control parameter that is a string data type.
     */
    public static ConfigurationOptions fromString(Consumer<StringConfigurationOptions.Builder> string) {
        StringConfigurationOptions.Builder builder = StringConfigurationOptions.builder();
        string.accept(builder);
        return fromString(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stringList()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is a list of strings.
     * </p>
     * 
     * @param stringList
     *        The options for customizing a security control parameter that is a list of strings.
     */
    public static ConfigurationOptions fromStringList(StringListConfigurationOptions stringList) {
        return builder().stringList(stringList).build();
    }

    /**
     * Create an instance of this class with {@link #stringList()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is a list of strings.
     * </p>
     * 
     * @param stringList
     *        The options for customizing a security control parameter that is a list of strings.
     */
    public static ConfigurationOptions fromStringList(Consumer<StringListConfigurationOptions.Builder> stringList) {
        StringListConfigurationOptions.Builder builder = StringListConfigurationOptions.builder();
        stringList.accept(builder);
        return fromStringList(builder.build());
    }

    /**
     * Create an instance of this class with {@link #booleanValue()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is a boolean. For a boolean parameter, the options
     * are <code>true</code> and <code>false</code>.
     * </p>
     * 
     * @param booleanValue
     *        The options for customizing a security control parameter that is a boolean. For a boolean parameter, the
     *        options are <code>true</code> and <code>false</code>.
     */
    public static ConfigurationOptions fromBooleanValue(BooleanConfigurationOptions booleanValue) {
        return builder().booleanValue(booleanValue).build();
    }

    /**
     * Create an instance of this class with {@link #booleanValue()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is a boolean. For a boolean parameter, the options
     * are <code>true</code> and <code>false</code>.
     * </p>
     * 
     * @param booleanValue
     *        The options for customizing a security control parameter that is a boolean. For a boolean parameter, the
     *        options are <code>true</code> and <code>false</code>.
     */
    public static ConfigurationOptions fromBooleanValue(Consumer<BooleanConfigurationOptions.Builder> booleanValue) {
        BooleanConfigurationOptions.Builder builder = BooleanConfigurationOptions.builder();
        booleanValue.accept(builder);
        return fromBooleanValue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #enumValue()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is an enum.
     * </p>
     * 
     * @param enumValue
     *        The options for customizing a security control parameter that is an enum.
     */
    public static ConfigurationOptions fromEnumValue(EnumConfigurationOptions enumValue) {
        return builder().enumValue(enumValue).build();
    }

    /**
     * Create an instance of this class with {@link #enumValue()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is an enum.
     * </p>
     * 
     * @param enumValue
     *        The options for customizing a security control parameter that is an enum.
     */
    public static ConfigurationOptions fromEnumValue(Consumer<EnumConfigurationOptions.Builder> enumValue) {
        EnumConfigurationOptions.Builder builder = EnumConfigurationOptions.builder();
        enumValue.accept(builder);
        return fromEnumValue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #enumList()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is a list of enums.
     * </p>
     * 
     * @param enumList
     *        The options for customizing a security control parameter that is a list of enums.
     */
    public static ConfigurationOptions fromEnumList(EnumListConfigurationOptions enumList) {
        return builder().enumList(enumList).build();
    }

    /**
     * Create an instance of this class with {@link #enumList()} initialized to the given value.
     *
     * <p>
     * The options for customizing a security control parameter that is a list of enums.
     * </p>
     * 
     * @param enumList
     *        The options for customizing a security control parameter that is a list of enums.
     */
    public static ConfigurationOptions fromEnumList(Consumer<EnumListConfigurationOptions.Builder> enumList) {
        EnumListConfigurationOptions.Builder builder = EnumListConfigurationOptions.builder();
        enumList.accept(builder);
        return fromEnumList(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Integer", INTEGER_FIELD);
        map.put("IntegerList", INTEGER_LIST_FIELD);
        map.put("Double", DOUBLE_FIELD);
        map.put("String", STRING_FIELD);
        map.put("StringList", STRING_LIST_FIELD);
        map.put("Boolean", BOOLEAN_FIELD);
        map.put("Enum", ENUM_FIELD);
        map.put("EnumList", ENUM_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationOptions, T> g) {
        return obj -> g.apply((ConfigurationOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationOptions> {
        /**
         * <p>
         * The options for customizing a security control parameter that is an integer.
         * </p>
         * 
         * @param integer
         *        The options for customizing a security control parameter that is an integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integer(IntegerConfigurationOptions integer);

        /**
         * <p>
         * The options for customizing a security control parameter that is an integer.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntegerConfigurationOptions.Builder}
         * avoiding the need to create one manually via {@link IntegerConfigurationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntegerConfigurationOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #integer(IntegerConfigurationOptions)}.
         * 
         * @param integer
         *        a consumer that will call methods on {@link IntegerConfigurationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integer(IntegerConfigurationOptions)
         */
        default Builder integer(Consumer<IntegerConfigurationOptions.Builder> integer) {
            return integer(IntegerConfigurationOptions.builder().applyMutation(integer).build());
        }

        /**
         * <p>
         * The options for customizing a security control parameter that is a list of integers.
         * </p>
         * 
         * @param integerList
         *        The options for customizing a security control parameter that is a list of integers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerList(IntegerListConfigurationOptions integerList);

        /**
         * <p>
         * The options for customizing a security control parameter that is a list of integers.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntegerListConfigurationOptions.Builder}
         * avoiding the need to create one manually via {@link IntegerListConfigurationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntegerListConfigurationOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #integerList(IntegerListConfigurationOptions)}.
         * 
         * @param integerList
         *        a consumer that will call methods on {@link IntegerListConfigurationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integerList(IntegerListConfigurationOptions)
         */
        default Builder integerList(Consumer<IntegerListConfigurationOptions.Builder> integerList) {
            return integerList(IntegerListConfigurationOptions.builder().applyMutation(integerList).build());
        }

        /**
         * <p>
         * The options for customizing a security control parameter that is a double.
         * </p>
         * 
         * @param doubleValue
         *        The options for customizing a security control parameter that is a double.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(DoubleConfigurationOptions doubleValue);

        /**
         * <p>
         * The options for customizing a security control parameter that is a double.
         * </p>
         * This is a convenience method that creates an instance of the {@link DoubleConfigurationOptions.Builder}
         * avoiding the need to create one manually via {@link DoubleConfigurationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DoubleConfigurationOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #doubleValue(DoubleConfigurationOptions)}.
         * 
         * @param doubleValue
         *        a consumer that will call methods on {@link DoubleConfigurationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #doubleValue(DoubleConfigurationOptions)
         */
        default Builder doubleValue(Consumer<DoubleConfigurationOptions.Builder> doubleValue) {
            return doubleValue(DoubleConfigurationOptions.builder().applyMutation(doubleValue).build());
        }

        /**
         * <p>
         * The options for customizing a security control parameter that is a string data type.
         * </p>
         * 
         * @param string
         *        The options for customizing a security control parameter that is a string data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder string(StringConfigurationOptions string);

        /**
         * <p>
         * The options for customizing a security control parameter that is a string data type.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringConfigurationOptions.Builder}
         * avoiding the need to create one manually via {@link StringConfigurationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringConfigurationOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #string(StringConfigurationOptions)}.
         * 
         * @param string
         *        a consumer that will call methods on {@link StringConfigurationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #string(StringConfigurationOptions)
         */
        default Builder string(Consumer<StringConfigurationOptions.Builder> string) {
            return string(StringConfigurationOptions.builder().applyMutation(string).build());
        }

        /**
         * <p>
         * The options for customizing a security control parameter that is a list of strings.
         * </p>
         * 
         * @param stringList
         *        The options for customizing a security control parameter that is a list of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringList(StringListConfigurationOptions stringList);

        /**
         * <p>
         * The options for customizing a security control parameter that is a list of strings.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringListConfigurationOptions.Builder}
         * avoiding the need to create one manually via {@link StringListConfigurationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringListConfigurationOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #stringList(StringListConfigurationOptions)}.
         * 
         * @param stringList
         *        a consumer that will call methods on {@link StringListConfigurationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringList(StringListConfigurationOptions)
         */
        default Builder stringList(Consumer<StringListConfigurationOptions.Builder> stringList) {
            return stringList(StringListConfigurationOptions.builder().applyMutation(stringList).build());
        }

        /**
         * <p>
         * The options for customizing a security control parameter that is a boolean. For a boolean parameter, the
         * options are <code>true</code> and <code>false</code>.
         * </p>
         * 
         * @param booleanValue
         *        The options for customizing a security control parameter that is a boolean. For a boolean parameter,
         *        the options are <code>true</code> and <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(BooleanConfigurationOptions booleanValue);

        /**
         * <p>
         * The options for customizing a security control parameter that is a boolean. For a boolean parameter, the
         * options are <code>true</code> and <code>false</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BooleanConfigurationOptions.Builder}
         * avoiding the need to create one manually via {@link BooleanConfigurationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BooleanConfigurationOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #booleanValue(BooleanConfigurationOptions)}.
         * 
         * @param booleanValue
         *        a consumer that will call methods on {@link BooleanConfigurationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #booleanValue(BooleanConfigurationOptions)
         */
        default Builder booleanValue(Consumer<BooleanConfigurationOptions.Builder> booleanValue) {
            return booleanValue(BooleanConfigurationOptions.builder().applyMutation(booleanValue).build());
        }

        /**
         * <p>
         * The options for customizing a security control parameter that is an enum.
         * </p>
         * 
         * @param enumValue
         *        The options for customizing a security control parameter that is an enum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumValue(EnumConfigurationOptions enumValue);

        /**
         * <p>
         * The options for customizing a security control parameter that is an enum.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnumConfigurationOptions.Builder}
         * avoiding the need to create one manually via {@link EnumConfigurationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnumConfigurationOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #enumValue(EnumConfigurationOptions)}.
         * 
         * @param enumValue
         *        a consumer that will call methods on {@link EnumConfigurationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enumValue(EnumConfigurationOptions)
         */
        default Builder enumValue(Consumer<EnumConfigurationOptions.Builder> enumValue) {
            return enumValue(EnumConfigurationOptions.builder().applyMutation(enumValue).build());
        }

        /**
         * <p>
         * The options for customizing a security control parameter that is a list of enums.
         * </p>
         * 
         * @param enumList
         *        The options for customizing a security control parameter that is a list of enums.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumList(EnumListConfigurationOptions enumList);

        /**
         * <p>
         * The options for customizing a security control parameter that is a list of enums.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnumListConfigurationOptions.Builder}
         * avoiding the need to create one manually via {@link EnumListConfigurationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnumListConfigurationOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #enumList(EnumListConfigurationOptions)}.
         * 
         * @param enumList
         *        a consumer that will call methods on {@link EnumListConfigurationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enumList(EnumListConfigurationOptions)
         */
        default Builder enumList(Consumer<EnumListConfigurationOptions.Builder> enumList) {
            return enumList(EnumListConfigurationOptions.builder().applyMutation(enumList).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IntegerConfigurationOptions integer;

        private IntegerListConfigurationOptions integerList;

        private DoubleConfigurationOptions doubleValue;

        private StringConfigurationOptions string;

        private StringListConfigurationOptions stringList;

        private BooleanConfigurationOptions booleanValue;

        private EnumConfigurationOptions enumValue;

        private EnumListConfigurationOptions enumList;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationOptions model) {
            integer(model.integer);
            integerList(model.integerList);
            doubleValue(model.doubleValue);
            string(model.string);
            stringList(model.stringList);
            booleanValue(model.booleanValue);
            enumValue(model.enumValue);
            enumList(model.enumList);
        }

        public final IntegerConfigurationOptions.Builder getInteger() {
            return integer != null ? integer.toBuilder() : null;
        }

        public final void setInteger(IntegerConfigurationOptions.BuilderImpl integer) {
            Object oldValue = this.integer;
            this.integer = integer != null ? integer.build() : null;
            handleUnionValueChange(Type.INTEGER, oldValue, this.integer);
        }

        @Override
        public final Builder integer(IntegerConfigurationOptions integer) {
            Object oldValue = this.integer;
            this.integer = integer;
            handleUnionValueChange(Type.INTEGER, oldValue, this.integer);
            return this;
        }

        public final IntegerListConfigurationOptions.Builder getIntegerList() {
            return integerList != null ? integerList.toBuilder() : null;
        }

        public final void setIntegerList(IntegerListConfigurationOptions.BuilderImpl integerList) {
            Object oldValue = this.integerList;
            this.integerList = integerList != null ? integerList.build() : null;
            handleUnionValueChange(Type.INTEGER_LIST, oldValue, this.integerList);
        }

        @Override
        public final Builder integerList(IntegerListConfigurationOptions integerList) {
            Object oldValue = this.integerList;
            this.integerList = integerList;
            handleUnionValueChange(Type.INTEGER_LIST, oldValue, this.integerList);
            return this;
        }

        public final DoubleConfigurationOptions.Builder getDoubleValue() {
            return doubleValue != null ? doubleValue.toBuilder() : null;
        }

        public final void setDoubleValue(DoubleConfigurationOptions.BuilderImpl doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue != null ? doubleValue.build() : null;
            handleUnionValueChange(Type.DOUBLE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(DoubleConfigurationOptions doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE, oldValue, this.doubleValue);
            return this;
        }

        public final StringConfigurationOptions.Builder getString() {
            return string != null ? string.toBuilder() : null;
        }

        public final void setString(StringConfigurationOptions.BuilderImpl string) {
            Object oldValue = this.string;
            this.string = string != null ? string.build() : null;
            handleUnionValueChange(Type.STRING, oldValue, this.string);
        }

        @Override
        public final Builder string(StringConfigurationOptions string) {
            Object oldValue = this.string;
            this.string = string;
            handleUnionValueChange(Type.STRING, oldValue, this.string);
            return this;
        }

        public final StringListConfigurationOptions.Builder getStringList() {
            return stringList != null ? stringList.toBuilder() : null;
        }

        public final void setStringList(StringListConfigurationOptions.BuilderImpl stringList) {
            Object oldValue = this.stringList;
            this.stringList = stringList != null ? stringList.build() : null;
            handleUnionValueChange(Type.STRING_LIST, oldValue, this.stringList);
        }

        @Override
        public final Builder stringList(StringListConfigurationOptions stringList) {
            Object oldValue = this.stringList;
            this.stringList = stringList;
            handleUnionValueChange(Type.STRING_LIST, oldValue, this.stringList);
            return this;
        }

        public final BooleanConfigurationOptions.Builder getBooleanValue() {
            return booleanValue != null ? booleanValue.toBuilder() : null;
        }

        public final void setBooleanValue(BooleanConfigurationOptions.BuilderImpl booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue != null ? booleanValue.build() : null;
            handleUnionValueChange(Type.BOOLEAN, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(BooleanConfigurationOptions booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN, oldValue, this.booleanValue);
            return this;
        }

        public final EnumConfigurationOptions.Builder getEnumValue() {
            return enumValue != null ? enumValue.toBuilder() : null;
        }

        public final void setEnumValue(EnumConfigurationOptions.BuilderImpl enumValue) {
            Object oldValue = this.enumValue;
            this.enumValue = enumValue != null ? enumValue.build() : null;
            handleUnionValueChange(Type.ENUM, oldValue, this.enumValue);
        }

        @Override
        public final Builder enumValue(EnumConfigurationOptions enumValue) {
            Object oldValue = this.enumValue;
            this.enumValue = enumValue;
            handleUnionValueChange(Type.ENUM, oldValue, this.enumValue);
            return this;
        }

        public final EnumListConfigurationOptions.Builder getEnumList() {
            return enumList != null ? enumList.toBuilder() : null;
        }

        public final void setEnumList(EnumListConfigurationOptions.BuilderImpl enumList) {
            Object oldValue = this.enumList;
            this.enumList = enumList != null ? enumList.build() : null;
            handleUnionValueChange(Type.ENUM_LIST, oldValue, this.enumList);
        }

        @Override
        public final Builder enumList(EnumListConfigurationOptions enumList) {
            Object oldValue = this.enumList;
            this.enumList = enumList;
            handleUnionValueChange(Type.ENUM_LIST, oldValue, this.enumList);
            return this;
        }

        @Override
        public ConfigurationOptions build() {
            return new ConfigurationOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ConfigurationOptions#type()
     */
    public enum Type {
        INTEGER,

        INTEGER_LIST,

        DOUBLE,

        STRING,

        STRING_LIST,

        BOOLEAN,

        ENUM,

        ENUM_LIST,

        UNKNOWN_TO_SDK_VERSION
    }
}
