/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the sensitive data that was detected on the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClassificationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ClassificationResult.Builder, ClassificationResult> {
    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MimeType").getter(getter(ClassificationResult::mimeType)).setter(setter(Builder::mimeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MimeType").build()).build();

    private static final SdkField<Long> SIZE_CLASSIFIED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SizeClassified").getter(getter(ClassificationResult::sizeClassified))
            .setter(setter(Builder::sizeClassified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeClassified").build()).build();

    private static final SdkField<Boolean> ADDITIONAL_OCCURRENCES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AdditionalOccurrences").getter(getter(ClassificationResult::additionalOccurrences))
            .setter(setter(Builder::additionalOccurrences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOccurrences").build())
            .build();

    private static final SdkField<ClassificationStatus> STATUS_FIELD = SdkField
            .<ClassificationStatus> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(ClassificationResult::status)).setter(setter(Builder::status))
            .constructor(ClassificationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<SensitiveDataResult>> SENSITIVE_DATA_FIELD = SdkField
            .<List<SensitiveDataResult>> builder(MarshallingType.LIST)
            .memberName("SensitiveData")
            .getter(getter(ClassificationResult::sensitiveData))
            .setter(setter(Builder::sensitiveData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SensitiveData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SensitiveDataResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(SensitiveDataResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CustomDataIdentifiersResult> CUSTOM_DATA_IDENTIFIERS_FIELD = SdkField
            .<CustomDataIdentifiersResult> builder(MarshallingType.SDK_POJO).memberName("CustomDataIdentifiers")
            .getter(getter(ClassificationResult::customDataIdentifiers)).setter(setter(Builder::customDataIdentifiers))
            .constructor(CustomDataIdentifiersResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDataIdentifiers").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIME_TYPE_FIELD,
            SIZE_CLASSIFIED_FIELD, ADDITIONAL_OCCURRENCES_FIELD, STATUS_FIELD, SENSITIVE_DATA_FIELD,
            CUSTOM_DATA_IDENTIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mimeType;

    private final Long sizeClassified;

    private final Boolean additionalOccurrences;

    private final ClassificationStatus status;

    private final List<SensitiveDataResult> sensitiveData;

    private final CustomDataIdentifiersResult customDataIdentifiers;

    private ClassificationResult(BuilderImpl builder) {
        this.mimeType = builder.mimeType;
        this.sizeClassified = builder.sizeClassified;
        this.additionalOccurrences = builder.additionalOccurrences;
        this.status = builder.status;
        this.sensitiveData = builder.sensitiveData;
        this.customDataIdentifiers = builder.customDataIdentifiers;
    }

    /**
     * <p>
     * The type of content that the finding applies to.
     * </p>
     * 
     * @return The type of content that the finding applies to.
     */
    public final String mimeType() {
        return mimeType;
    }

    /**
     * <p>
     * The total size in bytes of the affected data.
     * </p>
     * 
     * @return The total size in bytes of the affected data.
     */
    public final Long sizeClassified() {
        return sizeClassified;
    }

    /**
     * <p>
     * Indicates whether there are additional occurrences of sensitive data that are not included in the finding. This
     * occurs when the number of occurrences exceeds the maximum that can be included.
     * </p>
     * 
     * @return Indicates whether there are additional occurrences of sensitive data that are not included in the
     *         finding. This occurs when the number of occurrences exceeds the maximum that can be included.
     */
    public final Boolean additionalOccurrences() {
        return additionalOccurrences;
    }

    /**
     * <p>
     * The current status of the sensitive data detection.
     * </p>
     * 
     * @return The current status of the sensitive data detection.
     */
    public final ClassificationStatus status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the SensitiveData property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSensitiveData() {
        return sensitiveData != null && !(sensitiveData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides details about sensitive data that was identified based on built-in configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSensitiveData} method.
     * </p>
     * 
     * @return Provides details about sensitive data that was identified based on built-in configuration.
     */
    public final List<SensitiveDataResult> sensitiveData() {
        return sensitiveData;
    }

    /**
     * <p>
     * Provides details about sensitive data that was identified based on customer-defined configuration.
     * </p>
     * 
     * @return Provides details about sensitive data that was identified based on customer-defined configuration.
     */
    public final CustomDataIdentifiersResult customDataIdentifiers() {
        return customDataIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mimeType());
        hashCode = 31 * hashCode + Objects.hashCode(sizeClassified());
        hashCode = 31 * hashCode + Objects.hashCode(additionalOccurrences());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasSensitiveData() ? sensitiveData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customDataIdentifiers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassificationResult)) {
            return false;
        }
        ClassificationResult other = (ClassificationResult) obj;
        return Objects.equals(mimeType(), other.mimeType()) && Objects.equals(sizeClassified(), other.sizeClassified())
                && Objects.equals(additionalOccurrences(), other.additionalOccurrences())
                && Objects.equals(status(), other.status()) && hasSensitiveData() == other.hasSensitiveData()
                && Objects.equals(sensitiveData(), other.sensitiveData())
                && Objects.equals(customDataIdentifiers(), other.customDataIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClassificationResult").add("MimeType", mimeType()).add("SizeClassified", sizeClassified())
                .add("AdditionalOccurrences", additionalOccurrences()).add("Status", status())
                .add("SensitiveData", hasSensitiveData() ? sensitiveData() : null)
                .add("CustomDataIdentifiers", customDataIdentifiers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MimeType":
            return Optional.ofNullable(clazz.cast(mimeType()));
        case "SizeClassified":
            return Optional.ofNullable(clazz.cast(sizeClassified()));
        case "AdditionalOccurrences":
            return Optional.ofNullable(clazz.cast(additionalOccurrences()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "SensitiveData":
            return Optional.ofNullable(clazz.cast(sensitiveData()));
        case "CustomDataIdentifiers":
            return Optional.ofNullable(clazz.cast(customDataIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MimeType", MIME_TYPE_FIELD);
        map.put("SizeClassified", SIZE_CLASSIFIED_FIELD);
        map.put("AdditionalOccurrences", ADDITIONAL_OCCURRENCES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SensitiveData", SENSITIVE_DATA_FIELD);
        map.put("CustomDataIdentifiers", CUSTOM_DATA_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClassificationResult, T> g) {
        return obj -> g.apply((ClassificationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClassificationResult> {
        /**
         * <p>
         * The type of content that the finding applies to.
         * </p>
         * 
         * @param mimeType
         *        The type of content that the finding applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mimeType(String mimeType);

        /**
         * <p>
         * The total size in bytes of the affected data.
         * </p>
         * 
         * @param sizeClassified
         *        The total size in bytes of the affected data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeClassified(Long sizeClassified);

        /**
         * <p>
         * Indicates whether there are additional occurrences of sensitive data that are not included in the finding.
         * This occurs when the number of occurrences exceeds the maximum that can be included.
         * </p>
         * 
         * @param additionalOccurrences
         *        Indicates whether there are additional occurrences of sensitive data that are not included in the
         *        finding. This occurs when the number of occurrences exceeds the maximum that can be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalOccurrences(Boolean additionalOccurrences);

        /**
         * <p>
         * The current status of the sensitive data detection.
         * </p>
         * 
         * @param status
         *        The current status of the sensitive data detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ClassificationStatus status);

        /**
         * <p>
         * The current status of the sensitive data detection.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClassificationStatus.Builder} avoiding
         * the need to create one manually via {@link ClassificationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClassificationStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(ClassificationStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ClassificationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ClassificationStatus)
         */
        default Builder status(Consumer<ClassificationStatus.Builder> status) {
            return status(ClassificationStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * Provides details about sensitive data that was identified based on built-in configuration.
         * </p>
         * 
         * @param sensitiveData
         *        Provides details about sensitive data that was identified based on built-in configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitiveData(Collection<SensitiveDataResult> sensitiveData);

        /**
         * <p>
         * Provides details about sensitive data that was identified based on built-in configuration.
         * </p>
         * 
         * @param sensitiveData
         *        Provides details about sensitive data that was identified based on built-in configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitiveData(SensitiveDataResult... sensitiveData);

        /**
         * <p>
         * Provides details about sensitive data that was identified based on built-in configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.SensitiveDataResult.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.SensitiveDataResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.SensitiveDataResult.Builder#build()} is called
         * immediately and its result is passed to {@link #sensitiveData(List<SensitiveDataResult>)}.
         * 
         * @param sensitiveData
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.SensitiveDataResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sensitiveData(java.util.Collection<SensitiveDataResult>)
         */
        Builder sensitiveData(Consumer<SensitiveDataResult.Builder>... sensitiveData);

        /**
         * <p>
         * Provides details about sensitive data that was identified based on customer-defined configuration.
         * </p>
         * 
         * @param customDataIdentifiers
         *        Provides details about sensitive data that was identified based on customer-defined configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataIdentifiers(CustomDataIdentifiersResult customDataIdentifiers);

        /**
         * <p>
         * Provides details about sensitive data that was identified based on customer-defined configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomDataIdentifiersResult.Builder}
         * avoiding the need to create one manually via {@link CustomDataIdentifiersResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomDataIdentifiersResult.Builder#build()} is called
         * immediately and its result is passed to {@link #customDataIdentifiers(CustomDataIdentifiersResult)}.
         * 
         * @param customDataIdentifiers
         *        a consumer that will call methods on {@link CustomDataIdentifiersResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDataIdentifiers(CustomDataIdentifiersResult)
         */
        default Builder customDataIdentifiers(Consumer<CustomDataIdentifiersResult.Builder> customDataIdentifiers) {
            return customDataIdentifiers(CustomDataIdentifiersResult.builder().applyMutation(customDataIdentifiers).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String mimeType;

        private Long sizeClassified;

        private Boolean additionalOccurrences;

        private ClassificationStatus status;

        private List<SensitiveDataResult> sensitiveData = DefaultSdkAutoConstructList.getInstance();

        private CustomDataIdentifiersResult customDataIdentifiers;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassificationResult model) {
            mimeType(model.mimeType);
            sizeClassified(model.sizeClassified);
            additionalOccurrences(model.additionalOccurrences);
            status(model.status);
            sensitiveData(model.sensitiveData);
            customDataIdentifiers(model.customDataIdentifiers);
        }

        public final String getMimeType() {
            return mimeType;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public final Long getSizeClassified() {
            return sizeClassified;
        }

        public final void setSizeClassified(Long sizeClassified) {
            this.sizeClassified = sizeClassified;
        }

        @Override
        public final Builder sizeClassified(Long sizeClassified) {
            this.sizeClassified = sizeClassified;
            return this;
        }

        public final Boolean getAdditionalOccurrences() {
            return additionalOccurrences;
        }

        public final void setAdditionalOccurrences(Boolean additionalOccurrences) {
            this.additionalOccurrences = additionalOccurrences;
        }

        @Override
        public final Builder additionalOccurrences(Boolean additionalOccurrences) {
            this.additionalOccurrences = additionalOccurrences;
            return this;
        }

        public final ClassificationStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ClassificationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ClassificationStatus status) {
            this.status = status;
            return this;
        }

        public final List<SensitiveDataResult.Builder> getSensitiveData() {
            List<SensitiveDataResult.Builder> result = SensitiveDataResultListCopier.copyToBuilder(this.sensitiveData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSensitiveData(Collection<SensitiveDataResult.BuilderImpl> sensitiveData) {
            this.sensitiveData = SensitiveDataResultListCopier.copyFromBuilder(sensitiveData);
        }

        @Override
        public final Builder sensitiveData(Collection<SensitiveDataResult> sensitiveData) {
            this.sensitiveData = SensitiveDataResultListCopier.copy(sensitiveData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensitiveData(SensitiveDataResult... sensitiveData) {
            sensitiveData(Arrays.asList(sensitiveData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensitiveData(Consumer<SensitiveDataResult.Builder>... sensitiveData) {
            sensitiveData(Stream.of(sensitiveData).map(c -> SensitiveDataResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CustomDataIdentifiersResult.Builder getCustomDataIdentifiers() {
            return customDataIdentifiers != null ? customDataIdentifiers.toBuilder() : null;
        }

        public final void setCustomDataIdentifiers(CustomDataIdentifiersResult.BuilderImpl customDataIdentifiers) {
            this.customDataIdentifiers = customDataIdentifiers != null ? customDataIdentifiers.build() : null;
        }

        @Override
        public final Builder customDataIdentifiers(CustomDataIdentifiersResult customDataIdentifiers) {
            this.customDataIdentifiers = customDataIdentifiers;
            return this;
        }

        @Override
        public ClassificationResult build() {
            return new ClassificationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
