/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of findings that were not updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateFindingsV2UnprocessedFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchUpdateFindingsV2UnprocessedFinding.Builder, BatchUpdateFindingsV2UnprocessedFinding> {
    private static final SdkField<OcsfFindingIdentifier> FINDING_IDENTIFIER_FIELD = SdkField
            .<OcsfFindingIdentifier> builder(MarshallingType.SDK_POJO).memberName("FindingIdentifier")
            .getter(getter(BatchUpdateFindingsV2UnprocessedFinding::findingIdentifier))
            .setter(setter(Builder::findingIdentifier)).constructor(OcsfFindingIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingIdentifier").build()).build();

    private static final SdkField<String> METADATA_UID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataUid").getter(getter(BatchUpdateFindingsV2UnprocessedFinding::metadataUid))
            .setter(setter(Builder::metadataUid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataUid").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(BatchUpdateFindingsV2UnprocessedFinding::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(BatchUpdateFindingsV2UnprocessedFinding::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_IDENTIFIER_FIELD,
            METADATA_UID_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OcsfFindingIdentifier findingIdentifier;

    private final String metadataUid;

    private final String errorCode;

    private final String errorMessage;

    private BatchUpdateFindingsV2UnprocessedFinding(BuilderImpl builder) {
        this.findingIdentifier = builder.findingIdentifier;
        this.metadataUid = builder.metadataUid;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The finding identifier of an unprocessed finding.
     * </p>
     * 
     * @return The finding identifier of an unprocessed finding.
     */
    public final OcsfFindingIdentifier findingIdentifier() {
        return findingIdentifier;
    }

    /**
     * <p>
     * The metadata.uid of an unprocessed finding.
     * </p>
     * 
     * @return The metadata.uid of an unprocessed finding.
     */
    public final String metadataUid() {
        return metadataUid;
    }

    /**
     * <p>
     * Indicates the specific type of error preventing successful processing of a finding during a batch update
     * operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchUpdateFindingsV2UnprocessedFindingErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return Indicates the specific type of error preventing successful processing of a finding during a batch update
     *         operation.
     * @see BatchUpdateFindingsV2UnprocessedFindingErrorCode
     */
    public final BatchUpdateFindingsV2UnprocessedFindingErrorCode errorCode() {
        return BatchUpdateFindingsV2UnprocessedFindingErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * Indicates the specific type of error preventing successful processing of a finding during a batch update
     * operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchUpdateFindingsV2UnprocessedFindingErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return Indicates the specific type of error preventing successful processing of a finding during a batch update
     *         operation.
     * @see BatchUpdateFindingsV2UnprocessedFindingErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * A detailed description of why a finding could not be processed during a batch update operation.
     * </p>
     * 
     * @return A detailed description of why a finding could not be processed during a batch update operation.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(findingIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(metadataUid());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFindingsV2UnprocessedFinding)) {
            return false;
        }
        BatchUpdateFindingsV2UnprocessedFinding other = (BatchUpdateFindingsV2UnprocessedFinding) obj;
        return Objects.equals(findingIdentifier(), other.findingIdentifier())
                && Objects.equals(metadataUid(), other.metadataUid())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateFindingsV2UnprocessedFinding").add("FindingIdentifier", findingIdentifier())
                .add("MetadataUid", metadataUid()).add("ErrorCode", errorCodeAsString()).add("ErrorMessage", errorMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FindingIdentifier":
            return Optional.ofNullable(clazz.cast(findingIdentifier()));
        case "MetadataUid":
            return Optional.ofNullable(clazz.cast(metadataUid()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FindingIdentifier", FINDING_IDENTIFIER_FIELD);
        map.put("MetadataUid", METADATA_UID_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFindingsV2UnprocessedFinding, T> g) {
        return obj -> g.apply((BatchUpdateFindingsV2UnprocessedFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchUpdateFindingsV2UnprocessedFinding> {
        /**
         * <p>
         * The finding identifier of an unprocessed finding.
         * </p>
         * 
         * @param findingIdentifier
         *        The finding identifier of an unprocessed finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIdentifier(OcsfFindingIdentifier findingIdentifier);

        /**
         * <p>
         * The finding identifier of an unprocessed finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link OcsfFindingIdentifier.Builder} avoiding
         * the need to create one manually via {@link OcsfFindingIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OcsfFindingIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #findingIdentifier(OcsfFindingIdentifier)}.
         * 
         * @param findingIdentifier
         *        a consumer that will call methods on {@link OcsfFindingIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingIdentifier(OcsfFindingIdentifier)
         */
        default Builder findingIdentifier(Consumer<OcsfFindingIdentifier.Builder> findingIdentifier) {
            return findingIdentifier(OcsfFindingIdentifier.builder().applyMutation(findingIdentifier).build());
        }

        /**
         * <p>
         * The metadata.uid of an unprocessed finding.
         * </p>
         * 
         * @param metadataUid
         *        The metadata.uid of an unprocessed finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataUid(String metadataUid);

        /**
         * <p>
         * Indicates the specific type of error preventing successful processing of a finding during a batch update
         * operation.
         * </p>
         * 
         * @param errorCode
         *        Indicates the specific type of error preventing successful processing of a finding during a batch
         *        update operation.
         * @see BatchUpdateFindingsV2UnprocessedFindingErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchUpdateFindingsV2UnprocessedFindingErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * Indicates the specific type of error preventing successful processing of a finding during a batch update
         * operation.
         * </p>
         * 
         * @param errorCode
         *        Indicates the specific type of error preventing successful processing of a finding during a batch
         *        update operation.
         * @see BatchUpdateFindingsV2UnprocessedFindingErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchUpdateFindingsV2UnprocessedFindingErrorCode
         */
        Builder errorCode(BatchUpdateFindingsV2UnprocessedFindingErrorCode errorCode);

        /**
         * <p>
         * A detailed description of why a finding could not be processed during a batch update operation.
         * </p>
         * 
         * @param errorMessage
         *        A detailed description of why a finding could not be processed during a batch update operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private OcsfFindingIdentifier findingIdentifier;

        private String metadataUid;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFindingsV2UnprocessedFinding model) {
            findingIdentifier(model.findingIdentifier);
            metadataUid(model.metadataUid);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final OcsfFindingIdentifier.Builder getFindingIdentifier() {
            return findingIdentifier != null ? findingIdentifier.toBuilder() : null;
        }

        public final void setFindingIdentifier(OcsfFindingIdentifier.BuilderImpl findingIdentifier) {
            this.findingIdentifier = findingIdentifier != null ? findingIdentifier.build() : null;
        }

        @Override
        public final Builder findingIdentifier(OcsfFindingIdentifier findingIdentifier) {
            this.findingIdentifier = findingIdentifier;
            return this;
        }

        public final String getMetadataUid() {
            return metadataUid;
        }

        public final void setMetadataUid(String metadataUid) {
            this.metadataUid = metadataUid;
        }

        @Override
        public final Builder metadataUid(String metadataUid) {
            this.metadataUid = metadataUid;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(BatchUpdateFindingsV2UnprocessedFindingErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public BatchUpdateFindingsV2UnprocessedFinding build() {
            return new BatchUpdateFindingsV2UnprocessedFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
