/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateFindingsV2Request extends SecurityHubRequest implements
        ToCopyableBuilder<BatchUpdateFindingsV2Request.Builder, BatchUpdateFindingsV2Request> {
    private static final SdkField<List<String>> METADATA_UIDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MetadataUids")
            .getter(getter(BatchUpdateFindingsV2Request::metadataUids))
            .setter(setter(Builder::metadataUids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataUids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OcsfFindingIdentifier>> FINDING_IDENTIFIERS_FIELD = SdkField
            .<List<OcsfFindingIdentifier>> builder(MarshallingType.LIST)
            .memberName("FindingIdentifiers")
            .getter(getter(BatchUpdateFindingsV2Request::findingIdentifiers))
            .setter(setter(Builder::findingIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OcsfFindingIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(OcsfFindingIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Comment")
            .getter(getter(BatchUpdateFindingsV2Request::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()).build();

    private static final SdkField<Integer> SEVERITY_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SeverityId").getter(getter(BatchUpdateFindingsV2Request::severityId))
            .setter(setter(Builder::severityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityId").build()).build();

    private static final SdkField<Integer> STATUS_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusId").getter(getter(BatchUpdateFindingsV2Request::statusId)).setter(setter(Builder::statusId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_UIDS_FIELD,
            FINDING_IDENTIFIERS_FIELD, COMMENT_FIELD, SEVERITY_ID_FIELD, STATUS_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> metadataUids;

    private final List<OcsfFindingIdentifier> findingIdentifiers;

    private final String comment;

    private final Integer severityId;

    private final Integer statusId;

    private BatchUpdateFindingsV2Request(BuilderImpl builder) {
        super(builder);
        this.metadataUids = builder.metadataUids;
        this.findingIdentifiers = builder.findingIdentifiers;
        this.comment = builder.comment;
        this.severityId = builder.severityId;
        this.statusId = builder.statusId;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetadataUids property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetadataUids() {
        return metadataUids != null && !(metadataUids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of finding <code>metadata.uid</code> to indicate findings to update. Finding <code>metadata.uid</code>
     * is a globally unique identifier associated with the finding. Customers cannot use <code>MetadataUids</code>
     * together with <code>FindingIdentifiers</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadataUids} method.
     * </p>
     * 
     * @return The list of finding <code>metadata.uid</code> to indicate findings to update. Finding
     *         <code>metadata.uid</code> is a globally unique identifier associated with the finding. Customers cannot
     *         use <code>MetadataUids</code> together with <code>FindingIdentifiers</code>.
     */
    public final List<String> metadataUids() {
        return metadataUids;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFindingIdentifiers() {
        return findingIdentifiers != null && !(findingIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information to identify a specific V2 finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingIdentifiers} method.
     * </p>
     * 
     * @return Provides information to identify a specific V2 finding.
     */
    public final List<OcsfFindingIdentifier> findingIdentifiers() {
        return findingIdentifiers;
    }

    /**
     * <p>
     * The updated value for a user provided comment about the finding. Minimum character length 1. Maximum character
     * length 512.
     * </p>
     * 
     * @return The updated value for a user provided comment about the finding. Minimum character length 1. Maximum
     *         character length 512.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The updated value for the normalized severity identifier. The severity ID is an integer with the allowed enum
     * values [0, 1, 2, 3, 4, 5, 99]. When customer provides the updated severity ID, the string sibling severity will
     * automatically be updated in the finding.
     * </p>
     * 
     * @return The updated value for the normalized severity identifier. The severity ID is an integer with the allowed
     *         enum values [0, 1, 2, 3, 4, 5, 99]. When customer provides the updated severity ID, the string sibling
     *         severity will automatically be updated in the finding.
     */
    public final Integer severityId() {
        return severityId;
    }

    /**
     * <p>
     * The updated value for the normalized status identifier. The status ID is an integer with the allowed enum values
     * [0, 1, 2, 3, 4, 5, 6, 99]. When customer provides the updated status ID, the string sibling status will
     * automatically be updated in the finding.
     * </p>
     * 
     * @return The updated value for the normalized status identifier. The status ID is an integer with the allowed enum
     *         values [0, 1, 2, 3, 4, 5, 6, 99]. When customer provides the updated status ID, the string sibling status
     *         will automatically be updated in the finding.
     */
    public final Integer statusId() {
        return statusId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadataUids() ? metadataUids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingIdentifiers() ? findingIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(severityId());
        hashCode = 31 * hashCode + Objects.hashCode(statusId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFindingsV2Request)) {
            return false;
        }
        BatchUpdateFindingsV2Request other = (BatchUpdateFindingsV2Request) obj;
        return hasMetadataUids() == other.hasMetadataUids() && Objects.equals(metadataUids(), other.metadataUids())
                && hasFindingIdentifiers() == other.hasFindingIdentifiers()
                && Objects.equals(findingIdentifiers(), other.findingIdentifiers()) && Objects.equals(comment(), other.comment())
                && Objects.equals(severityId(), other.severityId()) && Objects.equals(statusId(), other.statusId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateFindingsV2Request").add("MetadataUids", hasMetadataUids() ? metadataUids() : null)
                .add("FindingIdentifiers", hasFindingIdentifiers() ? findingIdentifiers() : null).add("Comment", comment())
                .add("SeverityId", severityId()).add("StatusId", statusId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetadataUids":
            return Optional.ofNullable(clazz.cast(metadataUids()));
        case "FindingIdentifiers":
            return Optional.ofNullable(clazz.cast(findingIdentifiers()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "SeverityId":
            return Optional.ofNullable(clazz.cast(severityId()));
        case "StatusId":
            return Optional.ofNullable(clazz.cast(statusId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetadataUids", METADATA_UIDS_FIELD);
        map.put("FindingIdentifiers", FINDING_IDENTIFIERS_FIELD);
        map.put("Comment", COMMENT_FIELD);
        map.put("SeverityId", SEVERITY_ID_FIELD);
        map.put("StatusId", STATUS_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFindingsV2Request, T> g) {
        return obj -> g.apply((BatchUpdateFindingsV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateFindingsV2Request> {
        /**
         * <p>
         * The list of finding <code>metadata.uid</code> to indicate findings to update. Finding
         * <code>metadata.uid</code> is a globally unique identifier associated with the finding. Customers cannot use
         * <code>MetadataUids</code> together with <code>FindingIdentifiers</code>.
         * </p>
         * 
         * @param metadataUids
         *        The list of finding <code>metadata.uid</code> to indicate findings to update. Finding
         *        <code>metadata.uid</code> is a globally unique identifier associated with the finding. Customers
         *        cannot use <code>MetadataUids</code> together with <code>FindingIdentifiers</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataUids(Collection<String> metadataUids);

        /**
         * <p>
         * The list of finding <code>metadata.uid</code> to indicate findings to update. Finding
         * <code>metadata.uid</code> is a globally unique identifier associated with the finding. Customers cannot use
         * <code>MetadataUids</code> together with <code>FindingIdentifiers</code>.
         * </p>
         * 
         * @param metadataUids
         *        The list of finding <code>metadata.uid</code> to indicate findings to update. Finding
         *        <code>metadata.uid</code> is a globally unique identifier associated with the finding. Customers
         *        cannot use <code>MetadataUids</code> together with <code>FindingIdentifiers</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataUids(String... metadataUids);

        /**
         * <p>
         * Provides information to identify a specific V2 finding.
         * </p>
         * 
         * @param findingIdentifiers
         *        Provides information to identify a specific V2 finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIdentifiers(Collection<OcsfFindingIdentifier> findingIdentifiers);

        /**
         * <p>
         * Provides information to identify a specific V2 finding.
         * </p>
         * 
         * @param findingIdentifiers
         *        Provides information to identify a specific V2 finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIdentifiers(OcsfFindingIdentifier... findingIdentifiers);

        /**
         * <p>
         * Provides information to identify a specific V2 finding.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfFindingIdentifier.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfFindingIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfFindingIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #findingIdentifiers(List<OcsfFindingIdentifier>)}.
         * 
         * @param findingIdentifiers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.OcsfFindingIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingIdentifiers(java.util.Collection<OcsfFindingIdentifier>)
         */
        Builder findingIdentifiers(Consumer<OcsfFindingIdentifier.Builder>... findingIdentifiers);

        /**
         * <p>
         * The updated value for a user provided comment about the finding. Minimum character length 1. Maximum
         * character length 512.
         * </p>
         * 
         * @param comment
         *        The updated value for a user provided comment about the finding. Minimum character length 1. Maximum
         *        character length 512.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The updated value for the normalized severity identifier. The severity ID is an integer with the allowed enum
         * values [0, 1, 2, 3, 4, 5, 99]. When customer provides the updated severity ID, the string sibling severity
         * will automatically be updated in the finding.
         * </p>
         * 
         * @param severityId
         *        The updated value for the normalized severity identifier. The severity ID is an integer with the
         *        allowed enum values [0, 1, 2, 3, 4, 5, 99]. When customer provides the updated severity ID, the string
         *        sibling severity will automatically be updated in the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityId(Integer severityId);

        /**
         * <p>
         * The updated value for the normalized status identifier. The status ID is an integer with the allowed enum
         * values [0, 1, 2, 3, 4, 5, 6, 99]. When customer provides the updated status ID, the string sibling status
         * will automatically be updated in the finding.
         * </p>
         * 
         * @param statusId
         *        The updated value for the normalized status identifier. The status ID is an integer with the allowed
         *        enum values [0, 1, 2, 3, 4, 5, 6, 99]. When customer provides the updated status ID, the string
         *        sibling status will automatically be updated in the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusId(Integer statusId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private List<String> metadataUids = DefaultSdkAutoConstructList.getInstance();

        private List<OcsfFindingIdentifier> findingIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String comment;

        private Integer severityId;

        private Integer statusId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFindingsV2Request model) {
            super(model);
            metadataUids(model.metadataUids);
            findingIdentifiers(model.findingIdentifiers);
            comment(model.comment);
            severityId(model.severityId);
            statusId(model.statusId);
        }

        public final Collection<String> getMetadataUids() {
            if (metadataUids instanceof SdkAutoConstructList) {
                return null;
            }
            return metadataUids;
        }

        public final void setMetadataUids(Collection<String> metadataUids) {
            this.metadataUids = MetadataUidListCopier.copy(metadataUids);
        }

        @Override
        public final Builder metadataUids(Collection<String> metadataUids) {
            this.metadataUids = MetadataUidListCopier.copy(metadataUids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataUids(String... metadataUids) {
            metadataUids(Arrays.asList(metadataUids));
            return this;
        }

        public final List<OcsfFindingIdentifier.Builder> getFindingIdentifiers() {
            List<OcsfFindingIdentifier.Builder> result = OcsfFindingIdentifierListCopier.copyToBuilder(this.findingIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingIdentifiers(Collection<OcsfFindingIdentifier.BuilderImpl> findingIdentifiers) {
            this.findingIdentifiers = OcsfFindingIdentifierListCopier.copyFromBuilder(findingIdentifiers);
        }

        @Override
        public final Builder findingIdentifiers(Collection<OcsfFindingIdentifier> findingIdentifiers) {
            this.findingIdentifiers = OcsfFindingIdentifierListCopier.copy(findingIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIdentifiers(OcsfFindingIdentifier... findingIdentifiers) {
            findingIdentifiers(Arrays.asList(findingIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIdentifiers(Consumer<OcsfFindingIdentifier.Builder>... findingIdentifiers) {
            findingIdentifiers(Stream.of(findingIdentifiers).map(c -> OcsfFindingIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Integer getSeverityId() {
            return severityId;
        }

        public final void setSeverityId(Integer severityId) {
            this.severityId = severityId;
        }

        @Override
        public final Builder severityId(Integer severityId) {
            this.severityId = severityId;
            return this;
        }

        public final Integer getStatusId() {
            return statusId;
        }

        public final void setStatusId(Integer statusId) {
            this.statusId = statusId;
        }

        @Override
        public final Builder statusId(Integer statusId) {
            this.statusId = statusId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateFindingsV2Request build() {
            return new BatchUpdateFindingsV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
