/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class BatchUpdateFindingsV2ProcessedFindingsListCopier {
    static List<BatchUpdateFindingsV2ProcessedFinding> copy(
            Collection<? extends BatchUpdateFindingsV2ProcessedFinding> batchUpdateFindingsV2ProcessedFindingsListParam) {
        List<BatchUpdateFindingsV2ProcessedFinding> list;
        if (batchUpdateFindingsV2ProcessedFindingsListParam == null
                || batchUpdateFindingsV2ProcessedFindingsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchUpdateFindingsV2ProcessedFinding> modifiableList = new ArrayList<>(
                    batchUpdateFindingsV2ProcessedFindingsListParam.size());
            batchUpdateFindingsV2ProcessedFindingsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchUpdateFindingsV2ProcessedFinding> copyFromBuilder(
            Collection<? extends BatchUpdateFindingsV2ProcessedFinding.Builder> batchUpdateFindingsV2ProcessedFindingsListParam) {
        List<BatchUpdateFindingsV2ProcessedFinding> list;
        if (batchUpdateFindingsV2ProcessedFindingsListParam == null
                || batchUpdateFindingsV2ProcessedFindingsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchUpdateFindingsV2ProcessedFinding> modifiableList = new ArrayList<>(
                    batchUpdateFindingsV2ProcessedFindingsListParam.size());
            batchUpdateFindingsV2ProcessedFindingsListParam.forEach(entry -> {
                BatchUpdateFindingsV2ProcessedFinding member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchUpdateFindingsV2ProcessedFinding.Builder> copyToBuilder(
            Collection<? extends BatchUpdateFindingsV2ProcessedFinding> batchUpdateFindingsV2ProcessedFindingsListParam) {
        List<BatchUpdateFindingsV2ProcessedFinding.Builder> list;
        if (batchUpdateFindingsV2ProcessedFindingsListParam == null
                || batchUpdateFindingsV2ProcessedFindingsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchUpdateFindingsV2ProcessedFinding.Builder> modifiableList = new ArrayList<>(
                    batchUpdateFindingsV2ProcessedFindingsListParam.size());
            batchUpdateFindingsV2ProcessedFindingsListParam.forEach(entry -> {
                BatchUpdateFindingsV2ProcessedFinding.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
