/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetSecurityControlsResponse extends SecurityHubResponse implements
        ToCopyableBuilder<BatchGetSecurityControlsResponse.Builder, BatchGetSecurityControlsResponse> {
    private static final SdkField<List<SecurityControl>> SECURITY_CONTROLS_FIELD = SdkField
            .<List<SecurityControl>> builder(MarshallingType.LIST)
            .memberName("SecurityControls")
            .getter(getter(BatchGetSecurityControlsResponse::securityControls))
            .setter(setter(Builder::securityControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityControl> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityControl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedSecurityControl>> UNPROCESSED_IDS_FIELD = SdkField
            .<List<UnprocessedSecurityControl>> builder(MarshallingType.LIST)
            .memberName("UnprocessedIds")
            .getter(getter(BatchGetSecurityControlsResponse::unprocessedIds))
            .setter(setter(Builder::unprocessedIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedSecurityControl> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedSecurityControl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONTROLS_FIELD,
            UNPROCESSED_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SecurityControl> securityControls;

    private final List<UnprocessedSecurityControl> unprocessedIds;

    private BatchGetSecurityControlsResponse(BuilderImpl builder) {
        super(builder);
        this.securityControls = builder.securityControls;
        this.unprocessedIds = builder.unprocessedIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityControls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityControls() {
        return securityControls != null && !(securityControls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that returns the identifier, Amazon Resource Name (ARN), and other details about a security control. The
     * same information is returned whether the request includes <code>SecurityControlId</code> or
     * <code>SecurityControlArn</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityControls} method.
     * </p>
     * 
     * @return An array that returns the identifier, Amazon Resource Name (ARN), and other details about a security
     *         control. The same information is returned whether the request includes <code>SecurityControlId</code> or
     *         <code>SecurityControlArn</code>.
     */
    public final List<SecurityControl> securityControls() {
        return securityControls;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedIds() {
        return unprocessedIds != null && !(unprocessedIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of
     * both parameters) for which details cannot be returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedIds} method.
     * </p>
     * 
     * @return A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a
     *         mix of both parameters) for which details cannot be returned.
     */
    public final List<UnprocessedSecurityControl> unprocessedIds() {
        return unprocessedIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityControls() ? securityControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedIds() ? unprocessedIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSecurityControlsResponse)) {
            return false;
        }
        BatchGetSecurityControlsResponse other = (BatchGetSecurityControlsResponse) obj;
        return hasSecurityControls() == other.hasSecurityControls()
                && Objects.equals(securityControls(), other.securityControls())
                && hasUnprocessedIds() == other.hasUnprocessedIds() && Objects.equals(unprocessedIds(), other.unprocessedIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetSecurityControlsResponse")
                .add("SecurityControls", hasSecurityControls() ? securityControls() : null)
                .add("UnprocessedIds", hasUnprocessedIds() ? unprocessedIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityControls":
            return Optional.ofNullable(clazz.cast(securityControls()));
        case "UnprocessedIds":
            return Optional.ofNullable(clazz.cast(unprocessedIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecurityControls", SECURITY_CONTROLS_FIELD);
        map.put("UnprocessedIds", UNPROCESSED_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetSecurityControlsResponse, T> g) {
        return obj -> g.apply((BatchGetSecurityControlsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetSecurityControlsResponse> {
        /**
         * <p>
         * An array that returns the identifier, Amazon Resource Name (ARN), and other details about a security control.
         * The same information is returned whether the request includes <code>SecurityControlId</code> or
         * <code>SecurityControlArn</code>.
         * </p>
         * 
         * @param securityControls
         *        An array that returns the identifier, Amazon Resource Name (ARN), and other details about a security
         *        control. The same information is returned whether the request includes <code>SecurityControlId</code>
         *        or <code>SecurityControlArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControls(Collection<SecurityControl> securityControls);

        /**
         * <p>
         * An array that returns the identifier, Amazon Resource Name (ARN), and other details about a security control.
         * The same information is returned whether the request includes <code>SecurityControlId</code> or
         * <code>SecurityControlArn</code>.
         * </p>
         * 
         * @param securityControls
         *        An array that returns the identifier, Amazon Resource Name (ARN), and other details about a security
         *        control. The same information is returned whether the request includes <code>SecurityControlId</code>
         *        or <code>SecurityControlArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControls(SecurityControl... securityControls);

        /**
         * <p>
         * An array that returns the identifier, Amazon Resource Name (ARN), and other details about a security control.
         * The same information is returned whether the request includes <code>SecurityControlId</code> or
         * <code>SecurityControlArn</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.SecurityControl.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.SecurityControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.SecurityControl.Builder#build()} is called
         * immediately and its result is passed to {@link #securityControls(List<SecurityControl>)}.
         * 
         * @param securityControls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.SecurityControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityControls(java.util.Collection<SecurityControl>)
         */
        Builder securityControls(Consumer<SecurityControl.Builder>... securityControls);

        /**
         * <p>
         * A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix
         * of both parameters) for which details cannot be returned.
         * </p>
         * 
         * @param unprocessedIds
         *        A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>,
         *        or a mix of both parameters) for which details cannot be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedIds(Collection<UnprocessedSecurityControl> unprocessedIds);

        /**
         * <p>
         * A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix
         * of both parameters) for which details cannot be returned.
         * </p>
         * 
         * @param unprocessedIds
         *        A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>,
         *        or a mix of both parameters) for which details cannot be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedIds(UnprocessedSecurityControl... unprocessedIds);

        /**
         * <p>
         * A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix
         * of both parameters) for which details cannot be returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedSecurityControl.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedSecurityControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedSecurityControl.Builder#build()} is
         * called immediately and its result is passed to {@link #unprocessedIds(List<UnprocessedSecurityControl>)}.
         * 
         * @param unprocessedIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.UnprocessedSecurityControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedIds(java.util.Collection<UnprocessedSecurityControl>)
         */
        Builder unprocessedIds(Consumer<UnprocessedSecurityControl.Builder>... unprocessedIds);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<SecurityControl> securityControls = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedSecurityControl> unprocessedIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetSecurityControlsResponse model) {
            super(model);
            securityControls(model.securityControls);
            unprocessedIds(model.unprocessedIds);
        }

        public final List<SecurityControl.Builder> getSecurityControls() {
            List<SecurityControl.Builder> result = SecurityControlsCopier.copyToBuilder(this.securityControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityControls(Collection<SecurityControl.BuilderImpl> securityControls) {
            this.securityControls = SecurityControlsCopier.copyFromBuilder(securityControls);
        }

        @Override
        public final Builder securityControls(Collection<SecurityControl> securityControls) {
            this.securityControls = SecurityControlsCopier.copy(securityControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityControls(SecurityControl... securityControls) {
            securityControls(Arrays.asList(securityControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityControls(Consumer<SecurityControl.Builder>... securityControls) {
            securityControls(Stream.of(securityControls).map(c -> SecurityControl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedSecurityControl.Builder> getUnprocessedIds() {
            List<UnprocessedSecurityControl.Builder> result = UnprocessedSecurityControlsCopier
                    .copyToBuilder(this.unprocessedIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedIds(Collection<UnprocessedSecurityControl.BuilderImpl> unprocessedIds) {
            this.unprocessedIds = UnprocessedSecurityControlsCopier.copyFromBuilder(unprocessedIds);
        }

        @Override
        public final Builder unprocessedIds(Collection<UnprocessedSecurityControl> unprocessedIds) {
            this.unprocessedIds = UnprocessedSecurityControlsCopier.copy(unprocessedIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIds(UnprocessedSecurityControl... unprocessedIds) {
            unprocessedIds(Arrays.asList(unprocessedIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIds(Consumer<UnprocessedSecurityControl.Builder>... unprocessedIds) {
            unprocessedIds(Stream.of(unprocessedIds).map(c -> UnprocessedSecurityControl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetSecurityControlsResponse build() {
            return new BatchGetSecurityControlsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
