/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetConfigurationPolicyAssociationsResponse extends SecurityHubResponse
        implements
        ToCopyableBuilder<BatchGetConfigurationPolicyAssociationsResponse.Builder, BatchGetConfigurationPolicyAssociationsResponse> {
    private static final SdkField<List<ConfigurationPolicyAssociationSummary>> CONFIGURATION_POLICY_ASSOCIATIONS_FIELD = SdkField
            .<List<ConfigurationPolicyAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("ConfigurationPolicyAssociations")
            .getter(getter(BatchGetConfigurationPolicyAssociationsResponse::configurationPolicyAssociations))
            .setter(setter(Builder::configurationPolicyAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicyAssociations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationPolicyAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationPolicyAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedConfigurationPolicyAssociation>> UNPROCESSED_CONFIGURATION_POLICY_ASSOCIATIONS_FIELD = SdkField
            .<List<UnprocessedConfigurationPolicyAssociation>> builder(MarshallingType.LIST)
            .memberName("UnprocessedConfigurationPolicyAssociations")
            .getter(getter(BatchGetConfigurationPolicyAssociationsResponse::unprocessedConfigurationPolicyAssociations))
            .setter(setter(Builder::unprocessedConfigurationPolicyAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("UnprocessedConfigurationPolicyAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedConfigurationPolicyAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedConfigurationPolicyAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_POLICY_ASSOCIATIONS_FIELD, UNPROCESSED_CONFIGURATION_POLICY_ASSOCIATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConfigurationPolicyAssociationSummary> configurationPolicyAssociations;

    private final List<UnprocessedConfigurationPolicyAssociation> unprocessedConfigurationPolicyAssociations;

    private BatchGetConfigurationPolicyAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationPolicyAssociations = builder.configurationPolicyAssociations;
        this.unprocessedConfigurationPolicyAssociations = builder.unprocessedConfigurationPolicyAssociations;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationPolicyAssociations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasConfigurationPolicyAssociations() {
        return configurationPolicyAssociations != null && !(configurationPolicyAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes associations for the target accounts, OUs, or the root.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationPolicyAssociations}
     * method.
     * </p>
     * 
     * @return Describes associations for the target accounts, OUs, or the root.
     */
    public final List<ConfigurationPolicyAssociationSummary> configurationPolicyAssociations() {
        return configurationPolicyAssociations;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * UnprocessedConfigurationPolicyAssociations property. This DOES NOT check that the value is non-empty (for which,
     * you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never return
     * a null collection or map, but you may need to differentiate between the service returning nothing (or null) and
     * the service returning an empty collection or map. For requests, this returns true if a value for the property was
     * specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUnprocessedConfigurationPolicyAssociations() {
        return unprocessedConfigurationPolicyAssociations != null
                && !(unprocessedConfigurationPolicyAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of configuration policy associations, one for each configuration policy association identifier, that was
     * specified in the request but couldn’t be processed due to an error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasUnprocessedConfigurationPolicyAssociations} method.
     * </p>
     * 
     * @return An array of configuration policy associations, one for each configuration policy association identifier,
     *         that was specified in the request but couldn’t be processed due to an error.
     */
    public final List<UnprocessedConfigurationPolicyAssociation> unprocessedConfigurationPolicyAssociations() {
        return unprocessedConfigurationPolicyAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConfigurationPolicyAssociations() ? configurationPolicyAssociations() : null);
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasUnprocessedConfigurationPolicyAssociations() ? unprocessedConfigurationPolicyAssociations()
                        : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetConfigurationPolicyAssociationsResponse)) {
            return false;
        }
        BatchGetConfigurationPolicyAssociationsResponse other = (BatchGetConfigurationPolicyAssociationsResponse) obj;
        return hasConfigurationPolicyAssociations() == other.hasConfigurationPolicyAssociations()
                && Objects.equals(configurationPolicyAssociations(), other.configurationPolicyAssociations())
                && hasUnprocessedConfigurationPolicyAssociations() == other.hasUnprocessedConfigurationPolicyAssociations()
                && Objects.equals(unprocessedConfigurationPolicyAssociations(),
                        other.unprocessedConfigurationPolicyAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchGetConfigurationPolicyAssociationsResponse")
                .add("ConfigurationPolicyAssociations",
                        hasConfigurationPolicyAssociations() ? configurationPolicyAssociations() : null)
                .add("UnprocessedConfigurationPolicyAssociations",
                        hasUnprocessedConfigurationPolicyAssociations() ? unprocessedConfigurationPolicyAssociations() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationPolicyAssociations":
            return Optional.ofNullable(clazz.cast(configurationPolicyAssociations()));
        case "UnprocessedConfigurationPolicyAssociations":
            return Optional.ofNullable(clazz.cast(unprocessedConfigurationPolicyAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationPolicyAssociations", CONFIGURATION_POLICY_ASSOCIATIONS_FIELD);
        map.put("UnprocessedConfigurationPolicyAssociations", UNPROCESSED_CONFIGURATION_POLICY_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetConfigurationPolicyAssociationsResponse, T> g) {
        return obj -> g.apply((BatchGetConfigurationPolicyAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetConfigurationPolicyAssociationsResponse> {
        /**
         * <p>
         * Describes associations for the target accounts, OUs, or the root.
         * </p>
         * 
         * @param configurationPolicyAssociations
         *        Describes associations for the target accounts, OUs, or the root.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationPolicyAssociations(Collection<ConfigurationPolicyAssociationSummary> configurationPolicyAssociations);

        /**
         * <p>
         * Describes associations for the target accounts, OUs, or the root.
         * </p>
         * 
         * @param configurationPolicyAssociations
         *        Describes associations for the target accounts, OUs, or the root.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationPolicyAssociations(ConfigurationPolicyAssociationSummary... configurationPolicyAssociations);

        /**
         * <p>
         * Describes associations for the target accounts, OUs, or the root.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #configurationPolicyAssociations(List<ConfigurationPolicyAssociationSummary>)}.
         * 
         * @param configurationPolicyAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationPolicyAssociations(java.util.Collection<ConfigurationPolicyAssociationSummary>)
         */
        Builder configurationPolicyAssociations(
                Consumer<ConfigurationPolicyAssociationSummary.Builder>... configurationPolicyAssociations);

        /**
         * <p>
         * An array of configuration policy associations, one for each configuration policy association identifier, that
         * was specified in the request but couldn’t be processed due to an error.
         * </p>
         * 
         * @param unprocessedConfigurationPolicyAssociations
         *        An array of configuration policy associations, one for each configuration policy association
         *        identifier, that was specified in the request but couldn’t be processed due to an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedConfigurationPolicyAssociations(
                Collection<UnprocessedConfigurationPolicyAssociation> unprocessedConfigurationPolicyAssociations);

        /**
         * <p>
         * An array of configuration policy associations, one for each configuration policy association identifier, that
         * was specified in the request but couldn’t be processed due to an error.
         * </p>
         * 
         * @param unprocessedConfigurationPolicyAssociations
         *        An array of configuration policy associations, one for each configuration policy association
         *        identifier, that was specified in the request but couldn’t be processed due to an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedConfigurationPolicyAssociations(
                UnprocessedConfigurationPolicyAssociation... unprocessedConfigurationPolicyAssociations);

        /**
         * <p>
         * An array of configuration policy associations, one for each configuration policy association identifier, that
         * was specified in the request but couldn’t be processed due to an error.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedConfigurationPolicyAssociation.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedConfigurationPolicyAssociation#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedConfigurationPolicyAssociation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #unprocessedConfigurationPolicyAssociations(List<UnprocessedConfigurationPolicyAssociation>)}.
         * 
         * @param unprocessedConfigurationPolicyAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.UnprocessedConfigurationPolicyAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see 
         *      #unprocessedConfigurationPolicyAssociations(java.util.Collection<UnprocessedConfigurationPolicyAssociation
         *      >)
         */
        Builder unprocessedConfigurationPolicyAssociations(
                Consumer<UnprocessedConfigurationPolicyAssociation.Builder>... unprocessedConfigurationPolicyAssociations);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<ConfigurationPolicyAssociationSummary> configurationPolicyAssociations = DefaultSdkAutoConstructList
                .getInstance();

        private List<UnprocessedConfigurationPolicyAssociation> unprocessedConfigurationPolicyAssociations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetConfigurationPolicyAssociationsResponse model) {
            super(model);
            configurationPolicyAssociations(model.configurationPolicyAssociations);
            unprocessedConfigurationPolicyAssociations(model.unprocessedConfigurationPolicyAssociations);
        }

        public final List<ConfigurationPolicyAssociationSummary.Builder> getConfigurationPolicyAssociations() {
            List<ConfigurationPolicyAssociationSummary.Builder> result = ConfigurationPolicyAssociationListCopier
                    .copyToBuilder(this.configurationPolicyAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationPolicyAssociations(
                Collection<ConfigurationPolicyAssociationSummary.BuilderImpl> configurationPolicyAssociations) {
            this.configurationPolicyAssociations = ConfigurationPolicyAssociationListCopier
                    .copyFromBuilder(configurationPolicyAssociations);
        }

        @Override
        public final Builder configurationPolicyAssociations(
                Collection<ConfigurationPolicyAssociationSummary> configurationPolicyAssociations) {
            this.configurationPolicyAssociations = ConfigurationPolicyAssociationListCopier.copy(configurationPolicyAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationPolicyAssociations(
                ConfigurationPolicyAssociationSummary... configurationPolicyAssociations) {
            configurationPolicyAssociations(Arrays.asList(configurationPolicyAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationPolicyAssociations(
                Consumer<ConfigurationPolicyAssociationSummary.Builder>... configurationPolicyAssociations) {
            configurationPolicyAssociations(Stream.of(configurationPolicyAssociations)
                    .map(c -> ConfigurationPolicyAssociationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedConfigurationPolicyAssociation.Builder> getUnprocessedConfigurationPolicyAssociations() {
            List<UnprocessedConfigurationPolicyAssociation.Builder> result = UnprocessedConfigurationPolicyAssociationListCopier
                    .copyToBuilder(this.unprocessedConfigurationPolicyAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedConfigurationPolicyAssociations(
                Collection<UnprocessedConfigurationPolicyAssociation.BuilderImpl> unprocessedConfigurationPolicyAssociations) {
            this.unprocessedConfigurationPolicyAssociations = UnprocessedConfigurationPolicyAssociationListCopier
                    .copyFromBuilder(unprocessedConfigurationPolicyAssociations);
        }

        @Override
        public final Builder unprocessedConfigurationPolicyAssociations(
                Collection<UnprocessedConfigurationPolicyAssociation> unprocessedConfigurationPolicyAssociations) {
            this.unprocessedConfigurationPolicyAssociations = UnprocessedConfigurationPolicyAssociationListCopier
                    .copy(unprocessedConfigurationPolicyAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedConfigurationPolicyAssociations(
                UnprocessedConfigurationPolicyAssociation... unprocessedConfigurationPolicyAssociations) {
            unprocessedConfigurationPolicyAssociations(Arrays.asList(unprocessedConfigurationPolicyAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedConfigurationPolicyAssociations(
                Consumer<UnprocessedConfigurationPolicyAssociation.Builder>... unprocessedConfigurationPolicyAssociations) {
            unprocessedConfigurationPolicyAssociations(Stream.of(unprocessedConfigurationPolicyAssociations)
                    .map(c -> UnprocessedConfigurationPolicyAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetConfigurationPolicyAssociationsResponse build() {
            return new BatchGetConfigurationPolicyAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
