/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an WAFv2 web Access Control List (ACL).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafv2WebAclDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafv2WebAclDetails.Builder, AwsWafv2WebAclDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsWafv2WebAclDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AwsWafv2WebAclDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Boolean> MANAGEDBY_FIREWALL_MANAGER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ManagedbyFirewallManager").getter(getter(AwsWafv2WebAclDetails::managedbyFirewallManager))
            .setter(setter(Builder::managedbyFirewallManager))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedbyFirewallManager").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AwsWafv2WebAclDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Long> CAPACITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Capacity")
            .getter(getter(AwsWafv2WebAclDetails::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()).build();

    private static final SdkField<AwsWafv2WebAclCaptchaConfigDetails> CAPTCHA_CONFIG_FIELD = SdkField
            .<AwsWafv2WebAclCaptchaConfigDetails> builder(MarshallingType.SDK_POJO).memberName("CaptchaConfig")
            .getter(getter(AwsWafv2WebAclDetails::captchaConfig)).setter(setter(Builder::captchaConfig))
            .constructor(AwsWafv2WebAclCaptchaConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptchaConfig").build()).build();

    private static final SdkField<AwsWafv2WebAclActionDetails> DEFAULT_ACTION_FIELD = SdkField
            .<AwsWafv2WebAclActionDetails> builder(MarshallingType.SDK_POJO).memberName("DefaultAction")
            .getter(getter(AwsWafv2WebAclDetails::defaultAction)).setter(setter(Builder::defaultAction))
            .constructor(AwsWafv2WebAclActionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsWafv2WebAclDetails::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<AwsWafv2RulesDetails>> RULES_FIELD = SdkField
            .<List<AwsWafv2RulesDetails>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(AwsWafv2WebAclDetails::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsWafv2RulesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsWafv2RulesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsWafv2VisibilityConfigDetails> VISIBILITY_CONFIG_FIELD = SdkField
            .<AwsWafv2VisibilityConfigDetails> builder(MarshallingType.SDK_POJO).memberName("VisibilityConfig")
            .getter(getter(AwsWafv2WebAclDetails::visibilityConfig)).setter(setter(Builder::visibilityConfig))
            .constructor(AwsWafv2VisibilityConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            MANAGEDBY_FIREWALL_MANAGER_FIELD, ID_FIELD, CAPACITY_FIELD, CAPTCHA_CONFIG_FIELD, DEFAULT_ACTION_FIELD,
            DESCRIPTION_FIELD, RULES_FIELD, VISIBILITY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final Boolean managedbyFirewallManager;

    private final String id;

    private final Long capacity;

    private final AwsWafv2WebAclCaptchaConfigDetails captchaConfig;

    private final AwsWafv2WebAclActionDetails defaultAction;

    private final String description;

    private final List<AwsWafv2RulesDetails> rules;

    private final AwsWafv2VisibilityConfigDetails visibilityConfig;

    private AwsWafv2WebAclDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.managedbyFirewallManager = builder.managedbyFirewallManager;
        this.id = builder.id;
        this.capacity = builder.capacity;
        this.captchaConfig = builder.captchaConfig;
        this.defaultAction = builder.defaultAction;
        this.description = builder.description;
        this.rules = builder.rules;
        this.visibilityConfig = builder.visibilityConfig;
    }

    /**
     * <p>
     * The name of the web ACL.
     * </p>
     * 
     * @return The name of the web ACL.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Indicates whether this web ACL is managed by Firewall Manager.
     * </p>
     * 
     * @return Indicates whether this web ACL is managed by Firewall Manager.
     */
    public final Boolean managedbyFirewallManager() {
        return managedbyFirewallManager;
    }

    /**
     * <p>
     * A unique identifier for the web ACL.
     * </p>
     * 
     * @return A unique identifier for the web ACL.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The web ACL capacity units (WCUs) currently being used by this web ACL.
     * </p>
     * 
     * @return The web ACL capacity units (WCUs) currently being used by this web ACL.
     */
    public final Long capacity() {
        return capacity;
    }

    /**
     * <p>
     * Specifies how WAF should handle CAPTCHA evaluations for rules that don't have their own
     * <code>CaptchaConfig</code> settings.
     * </p>
     * 
     * @return Specifies how WAF should handle CAPTCHA evaluations for rules that don't have their own
     *         <code>CaptchaConfig</code> settings.
     */
    public final AwsWafv2WebAclCaptchaConfigDetails captchaConfig() {
        return captchaConfig;
    }

    /**
     * <p>
     * The action to perform if none of the Rules contained in the web ACL match.
     * </p>
     * 
     * @return The action to perform if none of the Rules contained in the web ACL match.
     */
    public final AwsWafv2WebAclActionDetails defaultAction() {
        return defaultAction;
    }

    /**
     * <p>
     * A description of the web ACL that helps with identification.
     * </p>
     * 
     * @return A description of the web ACL that helps with identification.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes
     * one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF
     * handles them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule
     *         includes one top-level statement that WAF uses to identify matching web requests, and parameters that
     *         govern how WAF handles them.
     */
    public final List<AwsWafv2RulesDetails> rules() {
        return rules;
    }

    /**
     * <p>
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     * </p>
     * 
     * @return Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    public final AwsWafv2VisibilityConfigDetails visibilityConfig() {
        return visibilityConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(managedbyFirewallManager());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(captchaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAction());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(visibilityConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2WebAclDetails)) {
            return false;
        }
        AwsWafv2WebAclDetails other = (AwsWafv2WebAclDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(managedbyFirewallManager(), other.managedbyFirewallManager())
                && Objects.equals(id(), other.id()) && Objects.equals(capacity(), other.capacity())
                && Objects.equals(captchaConfig(), other.captchaConfig())
                && Objects.equals(defaultAction(), other.defaultAction()) && Objects.equals(description(), other.description())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules())
                && Objects.equals(visibilityConfig(), other.visibilityConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafv2WebAclDetails").add("Name", name()).add("Arn", arn())
                .add("ManagedbyFirewallManager", managedbyFirewallManager()).add("Id", id()).add("Capacity", capacity())
                .add("CaptchaConfig", captchaConfig()).add("DefaultAction", defaultAction()).add("Description", description())
                .add("Rules", hasRules() ? rules() : null).add("VisibilityConfig", visibilityConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ManagedbyFirewallManager":
            return Optional.ofNullable(clazz.cast(managedbyFirewallManager()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "CaptchaConfig":
            return Optional.ofNullable(clazz.cast(captchaConfig()));
        case "DefaultAction":
            return Optional.ofNullable(clazz.cast(defaultAction()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "VisibilityConfig":
            return Optional.ofNullable(clazz.cast(visibilityConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("ManagedbyFirewallManager", MANAGEDBY_FIREWALL_MANAGER_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Capacity", CAPACITY_FIELD);
        map.put("CaptchaConfig", CAPTCHA_CONFIG_FIELD);
        map.put("DefaultAction", DEFAULT_ACTION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Rules", RULES_FIELD);
        map.put("VisibilityConfig", VISIBILITY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2WebAclDetails, T> g) {
        return obj -> g.apply((AwsWafv2WebAclDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafv2WebAclDetails> {
        /**
         * <p>
         * The name of the web ACL.
         * </p>
         * 
         * @param name
         *        The name of the web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Indicates whether this web ACL is managed by Firewall Manager.
         * </p>
         * 
         * @param managedbyFirewallManager
         *        Indicates whether this web ACL is managed by Firewall Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedbyFirewallManager(Boolean managedbyFirewallManager);

        /**
         * <p>
         * A unique identifier for the web ACL.
         * </p>
         * 
         * @param id
         *        A unique identifier for the web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The web ACL capacity units (WCUs) currently being used by this web ACL.
         * </p>
         * 
         * @param capacity
         *        The web ACL capacity units (WCUs) currently being used by this web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Long capacity);

        /**
         * <p>
         * Specifies how WAF should handle CAPTCHA evaluations for rules that don't have their own
         * <code>CaptchaConfig</code> settings.
         * </p>
         * 
         * @param captchaConfig
         *        Specifies how WAF should handle CAPTCHA evaluations for rules that don't have their own
         *        <code>CaptchaConfig</code> settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captchaConfig(AwsWafv2WebAclCaptchaConfigDetails captchaConfig);

        /**
         * <p>
         * Specifies how WAF should handle CAPTCHA evaluations for rules that don't have their own
         * <code>CaptchaConfig</code> settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsWafv2WebAclCaptchaConfigDetails.Builder} avoiding the need to create one manually via
         * {@link AwsWafv2WebAclCaptchaConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2WebAclCaptchaConfigDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #captchaConfig(AwsWafv2WebAclCaptchaConfigDetails)}.
         * 
         * @param captchaConfig
         *        a consumer that will call methods on {@link AwsWafv2WebAclCaptchaConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captchaConfig(AwsWafv2WebAclCaptchaConfigDetails)
         */
        default Builder captchaConfig(Consumer<AwsWafv2WebAclCaptchaConfigDetails.Builder> captchaConfig) {
            return captchaConfig(AwsWafv2WebAclCaptchaConfigDetails.builder().applyMutation(captchaConfig).build());
        }

        /**
         * <p>
         * The action to perform if none of the Rules contained in the web ACL match.
         * </p>
         * 
         * @param defaultAction
         *        The action to perform if none of the Rules contained in the web ACL match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAction(AwsWafv2WebAclActionDetails defaultAction);

        /**
         * <p>
         * The action to perform if none of the Rules contained in the web ACL match.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafv2WebAclActionDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafv2WebAclActionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2WebAclActionDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultAction(AwsWafv2WebAclActionDetails)}.
         * 
         * @param defaultAction
         *        a consumer that will call methods on {@link AwsWafv2WebAclActionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultAction(AwsWafv2WebAclActionDetails)
         */
        default Builder defaultAction(Consumer<AwsWafv2WebAclActionDetails.Builder> defaultAction) {
            return defaultAction(AwsWafv2WebAclActionDetails.builder().applyMutation(defaultAction).build());
        }

        /**
         * <p>
         * A description of the web ACL that helps with identification.
         * </p>
         * 
         * @param description
         *        A description of the web ACL that helps with identification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule
         * includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern
         * how WAF handles them.
         * </p>
         * 
         * @param rules
         *        The Rule statements used to identify the web requests that you want to allow, block, or count. Each
         *        rule includes one top-level statement that WAF uses to identify matching web requests, and parameters
         *        that govern how WAF handles them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<AwsWafv2RulesDetails> rules);

        /**
         * <p>
         * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule
         * includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern
         * how WAF handles them.
         * </p>
         * 
         * @param rules
         *        The Rule statements used to identify the web requests that you want to allow, block, or count. Each
         *        rule includes one top-level statement that WAF uses to identify matching web requests, and parameters
         *        that govern how WAF handles them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(AwsWafv2RulesDetails... rules);

        /**
         * <p>
         * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule
         * includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern
         * how WAF handles them.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #rules(List<AwsWafv2RulesDetails>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<AwsWafv2RulesDetails>)
         */
        Builder rules(Consumer<AwsWafv2RulesDetails.Builder>... rules);

        /**
         * <p>
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * </p>
         * 
         * @param visibilityConfig
         *        Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityConfig(AwsWafv2VisibilityConfigDetails visibilityConfig);

        /**
         * <p>
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafv2VisibilityConfigDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafv2VisibilityConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2VisibilityConfigDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #visibilityConfig(AwsWafv2VisibilityConfigDetails)}.
         * 
         * @param visibilityConfig
         *        a consumer that will call methods on {@link AwsWafv2VisibilityConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visibilityConfig(AwsWafv2VisibilityConfigDetails)
         */
        default Builder visibilityConfig(Consumer<AwsWafv2VisibilityConfigDetails.Builder> visibilityConfig) {
            return visibilityConfig(AwsWafv2VisibilityConfigDetails.builder().applyMutation(visibilityConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private Boolean managedbyFirewallManager;

        private String id;

        private Long capacity;

        private AwsWafv2WebAclCaptchaConfigDetails captchaConfig;

        private AwsWafv2WebAclActionDetails defaultAction;

        private String description;

        private List<AwsWafv2RulesDetails> rules = DefaultSdkAutoConstructList.getInstance();

        private AwsWafv2VisibilityConfigDetails visibilityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2WebAclDetails model) {
            name(model.name);
            arn(model.arn);
            managedbyFirewallManager(model.managedbyFirewallManager);
            id(model.id);
            capacity(model.capacity);
            captchaConfig(model.captchaConfig);
            defaultAction(model.defaultAction);
            description(model.description);
            rules(model.rules);
            visibilityConfig(model.visibilityConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getManagedbyFirewallManager() {
            return managedbyFirewallManager;
        }

        public final void setManagedbyFirewallManager(Boolean managedbyFirewallManager) {
            this.managedbyFirewallManager = managedbyFirewallManager;
        }

        @Override
        public final Builder managedbyFirewallManager(Boolean managedbyFirewallManager) {
            this.managedbyFirewallManager = managedbyFirewallManager;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Long getCapacity() {
            return capacity;
        }

        public final void setCapacity(Long capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public final AwsWafv2WebAclCaptchaConfigDetails.Builder getCaptchaConfig() {
            return captchaConfig != null ? captchaConfig.toBuilder() : null;
        }

        public final void setCaptchaConfig(AwsWafv2WebAclCaptchaConfigDetails.BuilderImpl captchaConfig) {
            this.captchaConfig = captchaConfig != null ? captchaConfig.build() : null;
        }

        @Override
        public final Builder captchaConfig(AwsWafv2WebAclCaptchaConfigDetails captchaConfig) {
            this.captchaConfig = captchaConfig;
            return this;
        }

        public final AwsWafv2WebAclActionDetails.Builder getDefaultAction() {
            return defaultAction != null ? defaultAction.toBuilder() : null;
        }

        public final void setDefaultAction(AwsWafv2WebAclActionDetails.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        @Override
        public final Builder defaultAction(AwsWafv2WebAclActionDetails defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AwsWafv2RulesDetails.Builder> getRules() {
            List<AwsWafv2RulesDetails.Builder> result = AwsWafv2RulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<AwsWafv2RulesDetails.BuilderImpl> rules) {
            this.rules = AwsWafv2RulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<AwsWafv2RulesDetails> rules) {
            this.rules = AwsWafv2RulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(AwsWafv2RulesDetails... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<AwsWafv2RulesDetails.Builder>... rules) {
            rules(Stream.of(rules).map(c -> AwsWafv2RulesDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsWafv2VisibilityConfigDetails.Builder getVisibilityConfig() {
            return visibilityConfig != null ? visibilityConfig.toBuilder() : null;
        }

        public final void setVisibilityConfig(AwsWafv2VisibilityConfigDetails.BuilderImpl visibilityConfig) {
            this.visibilityConfig = visibilityConfig != null ? visibilityConfig.build() : null;
        }

        @Override
        public final Builder visibilityConfig(AwsWafv2VisibilityConfigDetails visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        @Override
        public AwsWafv2WebAclDetails build() {
            return new AwsWafv2WebAclDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
