/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the action that Amazon CloudFront or WAF takes when a web request matches the conditions in the rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafv2WebAclActionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafv2WebAclActionDetails.Builder, AwsWafv2WebAclActionDetails> {
    private static final SdkField<AwsWafv2ActionAllowDetails> ALLOW_FIELD = SdkField
            .<AwsWafv2ActionAllowDetails> builder(MarshallingType.SDK_POJO).memberName("Allow")
            .getter(getter(AwsWafv2WebAclActionDetails::allow)).setter(setter(Builder::allow))
            .constructor(AwsWafv2ActionAllowDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Allow").build()).build();

    private static final SdkField<AwsWafv2ActionBlockDetails> BLOCK_FIELD = SdkField
            .<AwsWafv2ActionBlockDetails> builder(MarshallingType.SDK_POJO).memberName("Block")
            .getter(getter(AwsWafv2WebAclActionDetails::block)).setter(setter(Builder::block))
            .constructor(AwsWafv2ActionBlockDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_FIELD, BLOCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsWafv2ActionAllowDetails allow;

    private final AwsWafv2ActionBlockDetails block;

    private AwsWafv2WebAclActionDetails(BuilderImpl builder) {
        this.allow = builder.allow;
        this.block = builder.block;
    }

    /**
     * <p>
     * Specifies that WAF should allow requests by default.
     * </p>
     * 
     * @return Specifies that WAF should allow requests by default.
     */
    public final AwsWafv2ActionAllowDetails allow() {
        return allow;
    }

    /**
     * <p>
     * Specifies that WAF should block requests by default.
     * </p>
     * 
     * @return Specifies that WAF should block requests by default.
     */
    public final AwsWafv2ActionBlockDetails block() {
        return block;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allow());
        hashCode = 31 * hashCode + Objects.hashCode(block());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2WebAclActionDetails)) {
            return false;
        }
        AwsWafv2WebAclActionDetails other = (AwsWafv2WebAclActionDetails) obj;
        return Objects.equals(allow(), other.allow()) && Objects.equals(block(), other.block());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafv2WebAclActionDetails").add("Allow", allow()).add("Block", block()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Allow":
            return Optional.ofNullable(clazz.cast(allow()));
        case "Block":
            return Optional.ofNullable(clazz.cast(block()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Allow", ALLOW_FIELD);
        map.put("Block", BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2WebAclActionDetails, T> g) {
        return obj -> g.apply((AwsWafv2WebAclActionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafv2WebAclActionDetails> {
        /**
         * <p>
         * Specifies that WAF should allow requests by default.
         * </p>
         * 
         * @param allow
         *        Specifies that WAF should allow requests by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allow(AwsWafv2ActionAllowDetails allow);

        /**
         * <p>
         * Specifies that WAF should allow requests by default.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafv2ActionAllowDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafv2ActionAllowDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2ActionAllowDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #allow(AwsWafv2ActionAllowDetails)}.
         * 
         * @param allow
         *        a consumer that will call methods on {@link AwsWafv2ActionAllowDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allow(AwsWafv2ActionAllowDetails)
         */
        default Builder allow(Consumer<AwsWafv2ActionAllowDetails.Builder> allow) {
            return allow(AwsWafv2ActionAllowDetails.builder().applyMutation(allow).build());
        }

        /**
         * <p>
         * Specifies that WAF should block requests by default.
         * </p>
         * 
         * @param block
         *        Specifies that WAF should block requests by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder block(AwsWafv2ActionBlockDetails block);

        /**
         * <p>
         * Specifies that WAF should block requests by default.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafv2ActionBlockDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafv2ActionBlockDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2ActionBlockDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #block(AwsWafv2ActionBlockDetails)}.
         * 
         * @param block
         *        a consumer that will call methods on {@link AwsWafv2ActionBlockDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #block(AwsWafv2ActionBlockDetails)
         */
        default Builder block(Consumer<AwsWafv2ActionBlockDetails.Builder> block) {
            return block(AwsWafv2ActionBlockDetails.builder().applyMutation(block).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsWafv2ActionAllowDetails allow;

        private AwsWafv2ActionBlockDetails block;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2WebAclActionDetails model) {
            allow(model.allow);
            block(model.block);
        }

        public final AwsWafv2ActionAllowDetails.Builder getAllow() {
            return allow != null ? allow.toBuilder() : null;
        }

        public final void setAllow(AwsWafv2ActionAllowDetails.BuilderImpl allow) {
            this.allow = allow != null ? allow.build() : null;
        }

        @Override
        public final Builder allow(AwsWafv2ActionAllowDetails allow) {
            this.allow = allow;
            return this;
        }

        public final AwsWafv2ActionBlockDetails.Builder getBlock() {
            return block != null ? block.toBuilder() : null;
        }

        public final void setBlock(AwsWafv2ActionBlockDetails.BuilderImpl block) {
            this.block = block != null ? block.build() : null;
        }

        @Override
        public final Builder block(AwsWafv2ActionBlockDetails block) {
            this.block = block;
            return this;
        }

        @Override
        public AwsWafv2WebAclActionDetails build() {
            return new AwsWafv2WebAclActionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
