/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AwsWafv2RulesListCopier {
    static List<AwsWafv2RulesDetails> copy(Collection<? extends AwsWafv2RulesDetails> awsWafv2RulesListParam) {
        List<AwsWafv2RulesDetails> list;
        if (awsWafv2RulesListParam == null || awsWafv2RulesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsWafv2RulesDetails> modifiableList = new ArrayList<>(awsWafv2RulesListParam.size());
            awsWafv2RulesListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsWafv2RulesDetails> copyFromBuilder(Collection<? extends AwsWafv2RulesDetails.Builder> awsWafv2RulesListParam) {
        List<AwsWafv2RulesDetails> list;
        if (awsWafv2RulesListParam == null || awsWafv2RulesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsWafv2RulesDetails> modifiableList = new ArrayList<>(awsWafv2RulesListParam.size());
            awsWafv2RulesListParam.forEach(entry -> {
                AwsWafv2RulesDetails member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsWafv2RulesDetails.Builder> copyToBuilder(Collection<? extends AwsWafv2RulesDetails> awsWafv2RulesListParam) {
        List<AwsWafv2RulesDetails.Builder> list;
        if (awsWafv2RulesListParam == null || awsWafv2RulesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsWafv2RulesDetails.Builder> modifiableList = new ArrayList<>(awsWafv2RulesListParam.size());
            awsWafv2RulesListParam.forEach(entry -> {
                AwsWafv2RulesDetails.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
