/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action that WAF should take on a web request when it matches a rule's statement. Settings at the web ACL level
 * can override the rule action setting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafv2RulesActionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafv2RulesActionDetails.Builder, AwsWafv2RulesActionDetails> {
    private static final SdkField<AwsWafv2ActionAllowDetails> ALLOW_FIELD = SdkField
            .<AwsWafv2ActionAllowDetails> builder(MarshallingType.SDK_POJO).memberName("Allow")
            .getter(getter(AwsWafv2RulesActionDetails::allow)).setter(setter(Builder::allow))
            .constructor(AwsWafv2ActionAllowDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Allow").build()).build();

    private static final SdkField<AwsWafv2ActionBlockDetails> BLOCK_FIELD = SdkField
            .<AwsWafv2ActionBlockDetails> builder(MarshallingType.SDK_POJO).memberName("Block")
            .getter(getter(AwsWafv2RulesActionDetails::block)).setter(setter(Builder::block))
            .constructor(AwsWafv2ActionBlockDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build()).build();

    private static final SdkField<AwsWafv2RulesActionCaptchaDetails> CAPTCHA_FIELD = SdkField
            .<AwsWafv2RulesActionCaptchaDetails> builder(MarshallingType.SDK_POJO).memberName("Captcha")
            .getter(getter(AwsWafv2RulesActionDetails::captcha)).setter(setter(Builder::captcha))
            .constructor(AwsWafv2RulesActionCaptchaDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Captcha").build()).build();

    private static final SdkField<AwsWafv2RulesActionCountDetails> COUNT_FIELD = SdkField
            .<AwsWafv2RulesActionCountDetails> builder(MarshallingType.SDK_POJO).memberName("Count")
            .getter(getter(AwsWafv2RulesActionDetails::count)).setter(setter(Builder::count))
            .constructor(AwsWafv2RulesActionCountDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_FIELD, BLOCK_FIELD,
            CAPTCHA_FIELD, COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsWafv2ActionAllowDetails allow;

    private final AwsWafv2ActionBlockDetails block;

    private final AwsWafv2RulesActionCaptchaDetails captcha;

    private final AwsWafv2RulesActionCountDetails count;

    private AwsWafv2RulesActionDetails(BuilderImpl builder) {
        this.allow = builder.allow;
        this.block = builder.block;
        this.captcha = builder.captcha;
        this.count = builder.count;
    }

    /**
     * <p>
     * Instructs WAF to allow the web request.
     * </p>
     * 
     * @return Instructs WAF to allow the web request.
     */
    public final AwsWafv2ActionAllowDetails allow() {
        return allow;
    }

    /**
     * <p>
     * Instructs WAF to block the web request.
     * </p>
     * 
     * @return Instructs WAF to block the web request.
     */
    public final AwsWafv2ActionBlockDetails block() {
        return block;
    }

    /**
     * <p>
     * Instructs WAF to run a CAPTCHA check against the web request.
     * </p>
     * 
     * @return Instructs WAF to run a CAPTCHA check against the web request.
     */
    public final AwsWafv2RulesActionCaptchaDetails captcha() {
        return captcha;
    }

    /**
     * <p>
     * Instructs WAF to count the web request and then continue evaluating the request using the remaining rules in the
     * web ACL.
     * </p>
     * 
     * @return Instructs WAF to count the web request and then continue evaluating the request using the remaining rules
     *         in the web ACL.
     */
    public final AwsWafv2RulesActionCountDetails count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allow());
        hashCode = 31 * hashCode + Objects.hashCode(block());
        hashCode = 31 * hashCode + Objects.hashCode(captcha());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2RulesActionDetails)) {
            return false;
        }
        AwsWafv2RulesActionDetails other = (AwsWafv2RulesActionDetails) obj;
        return Objects.equals(allow(), other.allow()) && Objects.equals(block(), other.block())
                && Objects.equals(captcha(), other.captcha()) && Objects.equals(count(), other.count());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafv2RulesActionDetails").add("Allow", allow()).add("Block", block())
                .add("Captcha", captcha()).add("Count", count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Allow":
            return Optional.ofNullable(clazz.cast(allow()));
        case "Block":
            return Optional.ofNullable(clazz.cast(block()));
        case "Captcha":
            return Optional.ofNullable(clazz.cast(captcha()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Allow", ALLOW_FIELD);
        map.put("Block", BLOCK_FIELD);
        map.put("Captcha", CAPTCHA_FIELD);
        map.put("Count", COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2RulesActionDetails, T> g) {
        return obj -> g.apply((AwsWafv2RulesActionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafv2RulesActionDetails> {
        /**
         * <p>
         * Instructs WAF to allow the web request.
         * </p>
         * 
         * @param allow
         *        Instructs WAF to allow the web request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allow(AwsWafv2ActionAllowDetails allow);

        /**
         * <p>
         * Instructs WAF to allow the web request.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafv2ActionAllowDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafv2ActionAllowDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2ActionAllowDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #allow(AwsWafv2ActionAllowDetails)}.
         * 
         * @param allow
         *        a consumer that will call methods on {@link AwsWafv2ActionAllowDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allow(AwsWafv2ActionAllowDetails)
         */
        default Builder allow(Consumer<AwsWafv2ActionAllowDetails.Builder> allow) {
            return allow(AwsWafv2ActionAllowDetails.builder().applyMutation(allow).build());
        }

        /**
         * <p>
         * Instructs WAF to block the web request.
         * </p>
         * 
         * @param block
         *        Instructs WAF to block the web request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder block(AwsWafv2ActionBlockDetails block);

        /**
         * <p>
         * Instructs WAF to block the web request.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafv2ActionBlockDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafv2ActionBlockDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2ActionBlockDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #block(AwsWafv2ActionBlockDetails)}.
         * 
         * @param block
         *        a consumer that will call methods on {@link AwsWafv2ActionBlockDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #block(AwsWafv2ActionBlockDetails)
         */
        default Builder block(Consumer<AwsWafv2ActionBlockDetails.Builder> block) {
            return block(AwsWafv2ActionBlockDetails.builder().applyMutation(block).build());
        }

        /**
         * <p>
         * Instructs WAF to run a CAPTCHA check against the web request.
         * </p>
         * 
         * @param captcha
         *        Instructs WAF to run a CAPTCHA check against the web request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captcha(AwsWafv2RulesActionCaptchaDetails captcha);

        /**
         * <p>
         * Instructs WAF to run a CAPTCHA check against the web request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsWafv2RulesActionCaptchaDetails.Builder} avoiding the need to create one manually via
         * {@link AwsWafv2RulesActionCaptchaDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2RulesActionCaptchaDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #captcha(AwsWafv2RulesActionCaptchaDetails)}.
         * 
         * @param captcha
         *        a consumer that will call methods on {@link AwsWafv2RulesActionCaptchaDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captcha(AwsWafv2RulesActionCaptchaDetails)
         */
        default Builder captcha(Consumer<AwsWafv2RulesActionCaptchaDetails.Builder> captcha) {
            return captcha(AwsWafv2RulesActionCaptchaDetails.builder().applyMutation(captcha).build());
        }

        /**
         * <p>
         * Instructs WAF to count the web request and then continue evaluating the request using the remaining rules in
         * the web ACL.
         * </p>
         * 
         * @param count
         *        Instructs WAF to count the web request and then continue evaluating the request using the remaining
         *        rules in the web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(AwsWafv2RulesActionCountDetails count);

        /**
         * <p>
         * Instructs WAF to count the web request and then continue evaluating the request using the remaining rules in
         * the web ACL.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafv2RulesActionCountDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafv2RulesActionCountDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2RulesActionCountDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #count(AwsWafv2RulesActionCountDetails)}.
         * 
         * @param count
         *        a consumer that will call methods on {@link AwsWafv2RulesActionCountDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #count(AwsWafv2RulesActionCountDetails)
         */
        default Builder count(Consumer<AwsWafv2RulesActionCountDetails.Builder> count) {
            return count(AwsWafv2RulesActionCountDetails.builder().applyMutation(count).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsWafv2ActionAllowDetails allow;

        private AwsWafv2ActionBlockDetails block;

        private AwsWafv2RulesActionCaptchaDetails captcha;

        private AwsWafv2RulesActionCountDetails count;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2RulesActionDetails model) {
            allow(model.allow);
            block(model.block);
            captcha(model.captcha);
            count(model.count);
        }

        public final AwsWafv2ActionAllowDetails.Builder getAllow() {
            return allow != null ? allow.toBuilder() : null;
        }

        public final void setAllow(AwsWafv2ActionAllowDetails.BuilderImpl allow) {
            this.allow = allow != null ? allow.build() : null;
        }

        @Override
        public final Builder allow(AwsWafv2ActionAllowDetails allow) {
            this.allow = allow;
            return this;
        }

        public final AwsWafv2ActionBlockDetails.Builder getBlock() {
            return block != null ? block.toBuilder() : null;
        }

        public final void setBlock(AwsWafv2ActionBlockDetails.BuilderImpl block) {
            this.block = block != null ? block.build() : null;
        }

        @Override
        public final Builder block(AwsWafv2ActionBlockDetails block) {
            this.block = block;
            return this;
        }

        public final AwsWafv2RulesActionCaptchaDetails.Builder getCaptcha() {
            return captcha != null ? captcha.toBuilder() : null;
        }

        public final void setCaptcha(AwsWafv2RulesActionCaptchaDetails.BuilderImpl captcha) {
            this.captcha = captcha != null ? captcha.build() : null;
        }

        @Override
        public final Builder captcha(AwsWafv2RulesActionCaptchaDetails captcha) {
            this.captcha = captcha;
            return this;
        }

        public final AwsWafv2RulesActionCountDetails.Builder getCount() {
            return count != null ? count.toBuilder() : null;
        }

        public final void setCount(AwsWafv2RulesActionCountDetails.BuilderImpl count) {
            this.count = count != null ? count.build() : null;
        }

        @Override
        public final Builder count(AwsWafv2RulesActionCountDetails count) {
            this.count = count;
            return this;
        }

        @Override
        public AwsWafv2RulesActionDetails build() {
            return new AwsWafv2RulesActionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
