/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an WAFv2 rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafv2RuleGroupDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafv2RuleGroupDetails.Builder, AwsWafv2RuleGroupDetails> {
    private static final SdkField<Long> CAPACITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Capacity")
            .getter(getter(AwsWafv2RuleGroupDetails::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsWafv2RuleGroupDetails::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AwsWafv2RuleGroupDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsWafv2RuleGroupDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AwsWafv2RuleGroupDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<List<AwsWafv2RulesDetails>> RULES_FIELD = SdkField
            .<List<AwsWafv2RulesDetails>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(AwsWafv2RuleGroupDetails::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsWafv2RulesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsWafv2RulesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(AwsWafv2RuleGroupDetails::scope)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<AwsWafv2VisibilityConfigDetails> VISIBILITY_CONFIG_FIELD = SdkField
            .<AwsWafv2VisibilityConfigDetails> builder(MarshallingType.SDK_POJO).memberName("VisibilityConfig")
            .getter(getter(AwsWafv2RuleGroupDetails::visibilityConfig)).setter(setter(Builder::visibilityConfig))
            .constructor(AwsWafv2VisibilityConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD,
            DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, ARN_FIELD, RULES_FIELD, SCOPE_FIELD, VISIBILITY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long capacity;

    private final String description;

    private final String id;

    private final String name;

    private final String arn;

    private final List<AwsWafv2RulesDetails> rules;

    private final String scope;

    private final AwsWafv2VisibilityConfigDetails visibilityConfig;

    private AwsWafv2RuleGroupDetails(BuilderImpl builder) {
        this.capacity = builder.capacity;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.rules = builder.rules;
        this.scope = builder.scope;
        this.visibilityConfig = builder.visibilityConfig;
    }

    /**
     * <p>
     * The web ACL capacity units (WCUs) required for this rule group.
     * </p>
     * 
     * @return The web ACL capacity units (WCUs) required for this rule group.
     */
    public final Long capacity() {
        return capacity;
    }

    /**
     * <p>
     * A description of the rule group that helps with identification.
     * </p>
     * 
     * @return A description of the rule group that helps with identification.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique identifier for the rule group.
     * </p>
     * 
     * @return A unique identifier for the rule group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the rule group. You cannot change the name of a rule group after you create it.
     * </p>
     * 
     * @return The name of the rule group. You cannot change the name of a rule group after you create it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the entity.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes
     * one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF
     * handles them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule
     *         includes one top-level statement that WAF uses to identify matching web requests, and parameters that
     *         govern how WAF handles them.
     */
    public final List<AwsWafv2RulesDetails> rules() {
        return rules;
    }

    /**
     * <p>
     * Specifies whether the rule group is for an Amazon CloudFront distribution or for a regional application. A
     * regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync
     * GraphQL API, or an Amazon Cognito user pool.
     * </p>
     * 
     * @return Specifies whether the rule group is for an Amazon CloudFront distribution or for a regional application.
     *         A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an
     *         AppSync GraphQL API, or an Amazon Cognito user pool.
     */
    public final String scope() {
        return scope;
    }

    /**
     * <p>
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     * </p>
     * 
     * @return Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    public final AwsWafv2VisibilityConfigDetails visibilityConfig() {
        return visibilityConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2RuleGroupDetails)) {
            return false;
        }
        AwsWafv2RuleGroupDetails other = (AwsWafv2RuleGroupDetails) obj;
        return Objects.equals(capacity(), other.capacity()) && Objects.equals(description(), other.description())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules())
                && Objects.equals(scope(), other.scope()) && Objects.equals(visibilityConfig(), other.visibilityConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafv2RuleGroupDetails").add("Capacity", capacity()).add("Description", description())
                .add("Id", id()).add("Name", name()).add("Arn", arn()).add("Rules", hasRules() ? rules() : null)
                .add("Scope", scope()).add("VisibilityConfig", visibilityConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "VisibilityConfig":
            return Optional.ofNullable(clazz.cast(visibilityConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Capacity", CAPACITY_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Rules", RULES_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("VisibilityConfig", VISIBILITY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2RuleGroupDetails, T> g) {
        return obj -> g.apply((AwsWafv2RuleGroupDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafv2RuleGroupDetails> {
        /**
         * <p>
         * The web ACL capacity units (WCUs) required for this rule group.
         * </p>
         * 
         * @param capacity
         *        The web ACL capacity units (WCUs) required for this rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Long capacity);

        /**
         * <p>
         * A description of the rule group that helps with identification.
         * </p>
         * 
         * @param description
         *        A description of the rule group that helps with identification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique identifier for the rule group.
         * </p>
         * 
         * @param id
         *        A unique identifier for the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the rule group. You cannot change the name of a rule group after you create it.
         * </p>
         * 
         * @param name
         *        The name of the rule group. You cannot change the name of a rule group after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the entity.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule
         * includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern
         * how WAF handles them.
         * </p>
         * 
         * @param rules
         *        The Rule statements used to identify the web requests that you want to allow, block, or count. Each
         *        rule includes one top-level statement that WAF uses to identify matching web requests, and parameters
         *        that govern how WAF handles them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<AwsWafv2RulesDetails> rules);

        /**
         * <p>
         * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule
         * includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern
         * how WAF handles them.
         * </p>
         * 
         * @param rules
         *        The Rule statements used to identify the web requests that you want to allow, block, or count. Each
         *        rule includes one top-level statement that WAF uses to identify matching web requests, and parameters
         *        that govern how WAF handles them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(AwsWafv2RulesDetails... rules);

        /**
         * <p>
         * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule
         * includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern
         * how WAF handles them.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #rules(List<AwsWafv2RulesDetails>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<AwsWafv2RulesDetails>)
         */
        Builder rules(Consumer<AwsWafv2RulesDetails.Builder>... rules);

        /**
         * <p>
         * Specifies whether the rule group is for an Amazon CloudFront distribution or for a regional application. A
         * regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync
         * GraphQL API, or an Amazon Cognito user pool.
         * </p>
         * 
         * @param scope
         *        Specifies whether the rule group is for an Amazon CloudFront distribution or for a regional
         *        application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway
         *        REST API, an AppSync GraphQL API, or an Amazon Cognito user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String scope);

        /**
         * <p>
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * </p>
         * 
         * @param visibilityConfig
         *        Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityConfig(AwsWafv2VisibilityConfigDetails visibilityConfig);

        /**
         * <p>
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafv2VisibilityConfigDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafv2VisibilityConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2VisibilityConfigDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #visibilityConfig(AwsWafv2VisibilityConfigDetails)}.
         * 
         * @param visibilityConfig
         *        a consumer that will call methods on {@link AwsWafv2VisibilityConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visibilityConfig(AwsWafv2VisibilityConfigDetails)
         */
        default Builder visibilityConfig(Consumer<AwsWafv2VisibilityConfigDetails.Builder> visibilityConfig) {
            return visibilityConfig(AwsWafv2VisibilityConfigDetails.builder().applyMutation(visibilityConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long capacity;

        private String description;

        private String id;

        private String name;

        private String arn;

        private List<AwsWafv2RulesDetails> rules = DefaultSdkAutoConstructList.getInstance();

        private String scope;

        private AwsWafv2VisibilityConfigDetails visibilityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2RuleGroupDetails model) {
            capacity(model.capacity);
            description(model.description);
            id(model.id);
            name(model.name);
            arn(model.arn);
            rules(model.rules);
            scope(model.scope);
            visibilityConfig(model.visibilityConfig);
        }

        public final Long getCapacity() {
            return capacity;
        }

        public final void setCapacity(Long capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<AwsWafv2RulesDetails.Builder> getRules() {
            List<AwsWafv2RulesDetails.Builder> result = AwsWafv2RulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<AwsWafv2RulesDetails.BuilderImpl> rules) {
            this.rules = AwsWafv2RulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<AwsWafv2RulesDetails> rules) {
            this.rules = AwsWafv2RulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(AwsWafv2RulesDetails... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<AwsWafv2RulesDetails.Builder>... rules) {
            rules(Stream.of(rules).map(c -> AwsWafv2RulesDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final AwsWafv2VisibilityConfigDetails.Builder getVisibilityConfig() {
            return visibilityConfig != null ? visibilityConfig.toBuilder() : null;
        }

        public final void setVisibilityConfig(AwsWafv2VisibilityConfigDetails.BuilderImpl visibilityConfig) {
            this.visibilityConfig = visibilityConfig != null ? visibilityConfig.build() : null;
        }

        @Override
        public final Builder visibilityConfig(AwsWafv2VisibilityConfigDetails visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        @Override
        public AwsWafv2RuleGroupDetails build() {
            return new AwsWafv2RuleGroupDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
