/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for a rule in an WAF web ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafWebAclRule implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafWebAclRule.Builder, AwsWafWebAclRule> {
    private static final SdkField<WafAction> ACTION_FIELD = SdkField.<WafAction> builder(MarshallingType.SDK_POJO)
            .memberName("Action").getter(getter(AwsWafWebAclRule::action)).setter(setter(Builder::action))
            .constructor(WafAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<List<WafExcludedRule>> EXCLUDED_RULES_FIELD = SdkField
            .<List<WafExcludedRule>> builder(MarshallingType.LIST)
            .memberName("ExcludedRules")
            .getter(getter(AwsWafWebAclRule::excludedRules))
            .setter(setter(Builder::excludedRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WafExcludedRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(WafExcludedRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<WafOverrideAction> OVERRIDE_ACTION_FIELD = SdkField
            .<WafOverrideAction> builder(MarshallingType.SDK_POJO).memberName("OverrideAction")
            .getter(getter(AwsWafWebAclRule::overrideAction)).setter(setter(Builder::overrideAction))
            .constructor(WafOverrideAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideAction").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(AwsWafWebAclRule::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RuleId")
            .getter(getter(AwsWafWebAclRule::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsWafWebAclRule::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            EXCLUDED_RULES_FIELD, OVERRIDE_ACTION_FIELD, PRIORITY_FIELD, RULE_ID_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WafAction action;

    private final List<WafExcludedRule> excludedRules;

    private final WafOverrideAction overrideAction;

    private final Integer priority;

    private final String ruleId;

    private final String type;

    private AwsWafWebAclRule(BuilderImpl builder) {
        this.action = builder.action;
        this.excludedRules = builder.excludedRules;
        this.overrideAction = builder.overrideAction;
        this.priority = builder.priority;
        this.ruleId = builder.ruleId;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies the action that CloudFront or WAF takes when a web request matches the conditions in the rule.
     * </p>
     * 
     * @return Specifies the action that CloudFront or WAF takes when a web request matches the conditions in the rule.
     */
    public final WafAction action() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludedRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludedRules() {
        return excludedRules != null && !(excludedRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Rules to exclude from a rule group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludedRules} method.
     * </p>
     * 
     * @return Rules to exclude from a rule group.
     */
    public final List<WafExcludedRule> excludedRules() {
        return excludedRules;
    }

    /**
     * <p>
     * Use the <code>OverrideAction</code> to test your <code>RuleGroup</code>.
     * </p>
     * <p>
     * Any rule in a <code>RuleGroup</code> can potentially block a request. If you set the <code>OverrideAction</code>
     * to <code>None</code>, the <code>RuleGroup</code> blocks a request if any individual rule in the
     * <code>RuleGroup</code> matches the request and is configured to block that request.
     * </p>
     * <p>
     * However, if you first want to test the <code>RuleGroup</code>, set the <code>OverrideAction</code> to
     * <code>Count</code>. The <code>RuleGroup</code> then overrides any block action specified by individual rules
     * contained within the group. Instead of blocking matching requests, those requests are counted.
     * </p>
     * <p>
     * <code>ActivatedRule</code>|<code>OverrideAction</code> applies only when updating or adding a
     * <code>RuleGroup</code> to a web ACL. In this case you don't use <code>ActivatedRule</code> <code>Action</code>.
     * For all other update requests, <code>ActivatedRule</code> <code>Action</code> is used instead of
     * <code>ActivatedRule</code> <code>OverrideAction</code>.
     * </p>
     * 
     * @return Use the <code>OverrideAction</code> to test your <code>RuleGroup</code>.</p>
     *         <p>
     *         Any rule in a <code>RuleGroup</code> can potentially block a request. If you set the
     *         <code>OverrideAction</code> to <code>None</code>, the <code>RuleGroup</code> blocks a request if any
     *         individual rule in the <code>RuleGroup</code> matches the request and is configured to block that
     *         request.
     *         </p>
     *         <p>
     *         However, if you first want to test the <code>RuleGroup</code>, set the <code>OverrideAction</code> to
     *         <code>Count</code>. The <code>RuleGroup</code> then overrides any block action specified by individual
     *         rules contained within the group. Instead of blocking matching requests, those requests are counted.
     *         </p>
     *         <p>
     *         <code>ActivatedRule</code>|<code>OverrideAction</code> applies only when updating or adding a
     *         <code>RuleGroup</code> to a web ACL. In this case you don't use <code>ActivatedRule</code>
     *         <code>Action</code>. For all other update requests, <code>ActivatedRule</code> <code>Action</code> is
     *         used instead of <code>ActivatedRule</code> <code>OverrideAction</code>.
     */
    public final WafOverrideAction overrideAction() {
        return overrideAction;
    }

    /**
     * <p>
     * Specifies the order in which the rules in a web ACL are evaluated. Rules with a lower value for
     * <code>Priority</code> are evaluated before rules with a higher value. The value must be a unique integer. If you
     * add multiple rules to a web ACL, the values don't need to be consecutive.
     * </p>
     * 
     * @return Specifies the order in which the rules in a web ACL are evaluated. Rules with a lower value for
     *         <code>Priority</code> are evaluated before rules with a higher value. The value must be a unique integer.
     *         If you add multiple rules to a web ACL, the values don't need to be consecutive.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The identifier for a rule.
     * </p>
     * 
     * @return The identifier for a rule.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * The rule type.
     * </p>
     * <p>
     * Valid values: <code>REGULAR</code> | <code>RATE_BASED</code> | <code>GROUP</code>
     * </p>
     * <p>
     * The default is <code>REGULAR</code>.
     * </p>
     * 
     * @return The rule type.</p>
     *         <p>
     *         Valid values: <code>REGULAR</code> | <code>RATE_BASED</code> | <code>GROUP</code>
     *         </p>
     *         <p>
     *         The default is <code>REGULAR</code>.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedRules() ? excludedRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(overrideAction());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafWebAclRule)) {
            return false;
        }
        AwsWafWebAclRule other = (AwsWafWebAclRule) obj;
        return Objects.equals(action(), other.action()) && hasExcludedRules() == other.hasExcludedRules()
                && Objects.equals(excludedRules(), other.excludedRules())
                && Objects.equals(overrideAction(), other.overrideAction()) && Objects.equals(priority(), other.priority())
                && Objects.equals(ruleId(), other.ruleId()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafWebAclRule").add("Action", action())
                .add("ExcludedRules", hasExcludedRules() ? excludedRules() : null).add("OverrideAction", overrideAction())
                .add("Priority", priority()).add("RuleId", ruleId()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "ExcludedRules":
            return Optional.ofNullable(clazz.cast(excludedRules()));
        case "OverrideAction":
            return Optional.ofNullable(clazz.cast(overrideAction()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Action", ACTION_FIELD);
        map.put("ExcludedRules", EXCLUDED_RULES_FIELD);
        map.put("OverrideAction", OVERRIDE_ACTION_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("RuleId", RULE_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafWebAclRule, T> g) {
        return obj -> g.apply((AwsWafWebAclRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafWebAclRule> {
        /**
         * <p>
         * Specifies the action that CloudFront or WAF takes when a web request matches the conditions in the rule.
         * </p>
         * 
         * @param action
         *        Specifies the action that CloudFront or WAF takes when a web request matches the conditions in the
         *        rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(WafAction action);

        /**
         * <p>
         * Specifies the action that CloudFront or WAF takes when a web request matches the conditions in the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link WafAction.Builder} avoiding the need to
         * create one manually via {@link WafAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WafAction.Builder#build()} is called immediately and its result
         * is passed to {@link #action(WafAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link WafAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(WafAction)
         */
        default Builder action(Consumer<WafAction.Builder> action) {
            return action(WafAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * Rules to exclude from a rule group.
         * </p>
         * 
         * @param excludedRules
         *        Rules to exclude from a rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedRules(Collection<WafExcludedRule> excludedRules);

        /**
         * <p>
         * Rules to exclude from a rule group.
         * </p>
         * 
         * @param excludedRules
         *        Rules to exclude from a rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedRules(WafExcludedRule... excludedRules);

        /**
         * <p>
         * Rules to exclude from a rule group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.WafExcludedRule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.WafExcludedRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.WafExcludedRule.Builder#build()} is called
         * immediately and its result is passed to {@link #excludedRules(List<WafExcludedRule>)}.
         * 
         * @param excludedRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.WafExcludedRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludedRules(java.util.Collection<WafExcludedRule>)
         */
        Builder excludedRules(Consumer<WafExcludedRule.Builder>... excludedRules);

        /**
         * <p>
         * Use the <code>OverrideAction</code> to test your <code>RuleGroup</code>.
         * </p>
         * <p>
         * Any rule in a <code>RuleGroup</code> can potentially block a request. If you set the
         * <code>OverrideAction</code> to <code>None</code>, the <code>RuleGroup</code> blocks a request if any
         * individual rule in the <code>RuleGroup</code> matches the request and is configured to block that request.
         * </p>
         * <p>
         * However, if you first want to test the <code>RuleGroup</code>, set the <code>OverrideAction</code> to
         * <code>Count</code>. The <code>RuleGroup</code> then overrides any block action specified by individual rules
         * contained within the group. Instead of blocking matching requests, those requests are counted.
         * </p>
         * <p>
         * <code>ActivatedRule</code>|<code>OverrideAction</code> applies only when updating or adding a
         * <code>RuleGroup</code> to a web ACL. In this case you don't use <code>ActivatedRule</code>
         * <code>Action</code>. For all other update requests, <code>ActivatedRule</code> <code>Action</code> is used
         * instead of <code>ActivatedRule</code> <code>OverrideAction</code>.
         * </p>
         * 
         * @param overrideAction
         *        Use the <code>OverrideAction</code> to test your <code>RuleGroup</code>.</p>
         *        <p>
         *        Any rule in a <code>RuleGroup</code> can potentially block a request. If you set the
         *        <code>OverrideAction</code> to <code>None</code>, the <code>RuleGroup</code> blocks a request if any
         *        individual rule in the <code>RuleGroup</code> matches the request and is configured to block that
         *        request.
         *        </p>
         *        <p>
         *        However, if you first want to test the <code>RuleGroup</code>, set the <code>OverrideAction</code> to
         *        <code>Count</code>. The <code>RuleGroup</code> then overrides any block action specified by individual
         *        rules contained within the group. Instead of blocking matching requests, those requests are counted.
         *        </p>
         *        <p>
         *        <code>ActivatedRule</code>|<code>OverrideAction</code> applies only when updating or adding a
         *        <code>RuleGroup</code> to a web ACL. In this case you don't use <code>ActivatedRule</code>
         *        <code>Action</code>. For all other update requests, <code>ActivatedRule</code> <code>Action</code> is
         *        used instead of <code>ActivatedRule</code> <code>OverrideAction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideAction(WafOverrideAction overrideAction);

        /**
         * <p>
         * Use the <code>OverrideAction</code> to test your <code>RuleGroup</code>.
         * </p>
         * <p>
         * Any rule in a <code>RuleGroup</code> can potentially block a request. If you set the
         * <code>OverrideAction</code> to <code>None</code>, the <code>RuleGroup</code> blocks a request if any
         * individual rule in the <code>RuleGroup</code> matches the request and is configured to block that request.
         * </p>
         * <p>
         * However, if you first want to test the <code>RuleGroup</code>, set the <code>OverrideAction</code> to
         * <code>Count</code>. The <code>RuleGroup</code> then overrides any block action specified by individual rules
         * contained within the group. Instead of blocking matching requests, those requests are counted.
         * </p>
         * <p>
         * <code>ActivatedRule</code>|<code>OverrideAction</code> applies only when updating or adding a
         * <code>RuleGroup</code> to a web ACL. In this case you don't use <code>ActivatedRule</code>
         * <code>Action</code>. For all other update requests, <code>ActivatedRule</code> <code>Action</code> is used
         * instead of <code>ActivatedRule</code> <code>OverrideAction</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link WafOverrideAction.Builder} avoiding the
         * need to create one manually via {@link WafOverrideAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WafOverrideAction.Builder#build()} is called immediately and its
         * result is passed to {@link #overrideAction(WafOverrideAction)}.
         * 
         * @param overrideAction
         *        a consumer that will call methods on {@link WafOverrideAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideAction(WafOverrideAction)
         */
        default Builder overrideAction(Consumer<WafOverrideAction.Builder> overrideAction) {
            return overrideAction(WafOverrideAction.builder().applyMutation(overrideAction).build());
        }

        /**
         * <p>
         * Specifies the order in which the rules in a web ACL are evaluated. Rules with a lower value for
         * <code>Priority</code> are evaluated before rules with a higher value. The value must be a unique integer. If
         * you add multiple rules to a web ACL, the values don't need to be consecutive.
         * </p>
         * 
         * @param priority
         *        Specifies the order in which the rules in a web ACL are evaluated. Rules with a lower value for
         *        <code>Priority</code> are evaluated before rules with a higher value. The value must be a unique
         *        integer. If you add multiple rules to a web ACL, the values don't need to be consecutive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The identifier for a rule.
         * </p>
         * 
         * @param ruleId
         *        The identifier for a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The rule type.
         * </p>
         * <p>
         * Valid values: <code>REGULAR</code> | <code>RATE_BASED</code> | <code>GROUP</code>
         * </p>
         * <p>
         * The default is <code>REGULAR</code>.
         * </p>
         * 
         * @param type
         *        The rule type.</p>
         *        <p>
         *        Valid values: <code>REGULAR</code> | <code>RATE_BASED</code> | <code>GROUP</code>
         *        </p>
         *        <p>
         *        The default is <code>REGULAR</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private WafAction action;

        private List<WafExcludedRule> excludedRules = DefaultSdkAutoConstructList.getInstance();

        private WafOverrideAction overrideAction;

        private Integer priority;

        private String ruleId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafWebAclRule model) {
            action(model.action);
            excludedRules(model.excludedRules);
            overrideAction(model.overrideAction);
            priority(model.priority);
            ruleId(model.ruleId);
            type(model.type);
        }

        public final WafAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(WafAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(WafAction action) {
            this.action = action;
            return this;
        }

        public final List<WafExcludedRule.Builder> getExcludedRules() {
            List<WafExcludedRule.Builder> result = WafExcludedRuleListCopier.copyToBuilder(this.excludedRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludedRules(Collection<WafExcludedRule.BuilderImpl> excludedRules) {
            this.excludedRules = WafExcludedRuleListCopier.copyFromBuilder(excludedRules);
        }

        @Override
        public final Builder excludedRules(Collection<WafExcludedRule> excludedRules) {
            this.excludedRules = WafExcludedRuleListCopier.copy(excludedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(WafExcludedRule... excludedRules) {
            excludedRules(Arrays.asList(excludedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(Consumer<WafExcludedRule.Builder>... excludedRules) {
            excludedRules(Stream.of(excludedRules).map(c -> WafExcludedRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final WafOverrideAction.Builder getOverrideAction() {
            return overrideAction != null ? overrideAction.toBuilder() : null;
        }

        public final void setOverrideAction(WafOverrideAction.BuilderImpl overrideAction) {
            this.overrideAction = overrideAction != null ? overrideAction.build() : null;
        }

        @Override
        public final Builder overrideAction(WafOverrideAction overrideAction) {
            this.overrideAction = overrideAction;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsWafWebAclRule build() {
            return new AwsWafWebAclRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
