/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an Amazon SNS topic to which notifications can be published.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSnsTopicDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsSnsTopicDetails.Builder, AwsSnsTopicDetails> {
    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsMasterKeyId").getter(getter(AwsSnsTopicDetails::kmsMasterKeyId))
            .setter(setter(Builder::kmsMasterKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsMasterKeyId").build()).build();

    private static final SdkField<List<AwsSnsTopicSubscription>> SUBSCRIPTION_FIELD = SdkField
            .<List<AwsSnsTopicSubscription>> builder(MarshallingType.LIST)
            .memberName("Subscription")
            .getter(getter(AwsSnsTopicDetails::subscription))
            .setter(setter(Builder::subscription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscription").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsSnsTopicSubscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsSnsTopicSubscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicName").getter(getter(AwsSnsTopicDetails::topicName)).setter(setter(Builder::topicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(AwsSnsTopicDetails::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> SQS_SUCCESS_FEEDBACK_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SqsSuccessFeedbackRoleArn").getter(getter(AwsSnsTopicDetails::sqsSuccessFeedbackRoleArn))
            .setter(setter(Builder::sqsSuccessFeedbackRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsSuccessFeedbackRoleArn").build())
            .build();

    private static final SdkField<String> SQS_FAILURE_FEEDBACK_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SqsFailureFeedbackRoleArn").getter(getter(AwsSnsTopicDetails::sqsFailureFeedbackRoleArn))
            .setter(setter(Builder::sqsFailureFeedbackRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsFailureFeedbackRoleArn").build())
            .build();

    private static final SdkField<String> APPLICATION_SUCCESS_FEEDBACK_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationSuccessFeedbackRoleArn")
            .getter(getter(AwsSnsTopicDetails::applicationSuccessFeedbackRoleArn))
            .setter(setter(Builder::applicationSuccessFeedbackRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSuccessFeedbackRoleArn")
                    .build()).build();

    private static final SdkField<String> FIREHOSE_SUCCESS_FEEDBACK_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FirehoseSuccessFeedbackRoleArn")
            .getter(getter(AwsSnsTopicDetails::firehoseSuccessFeedbackRoleArn))
            .setter(setter(Builder::firehoseSuccessFeedbackRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseSuccessFeedbackRoleArn")
                    .build()).build();

    private static final SdkField<String> FIREHOSE_FAILURE_FEEDBACK_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FirehoseFailureFeedbackRoleArn")
            .getter(getter(AwsSnsTopicDetails::firehoseFailureFeedbackRoleArn))
            .setter(setter(Builder::firehoseFailureFeedbackRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseFailureFeedbackRoleArn")
                    .build()).build();

    private static final SdkField<String> HTTP_SUCCESS_FEEDBACK_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HttpSuccessFeedbackRoleArn")
            .getter(getter(AwsSnsTopicDetails::httpSuccessFeedbackRoleArn))
            .setter(setter(Builder::httpSuccessFeedbackRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpSuccessFeedbackRoleArn").build())
            .build();

    private static final SdkField<String> HTTP_FAILURE_FEEDBACK_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HttpFailureFeedbackRoleArn")
            .getter(getter(AwsSnsTopicDetails::httpFailureFeedbackRoleArn))
            .setter(setter(Builder::httpFailureFeedbackRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpFailureFeedbackRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_MASTER_KEY_ID_FIELD,
            SUBSCRIPTION_FIELD, TOPIC_NAME_FIELD, OWNER_FIELD, SQS_SUCCESS_FEEDBACK_ROLE_ARN_FIELD,
            SQS_FAILURE_FEEDBACK_ROLE_ARN_FIELD, APPLICATION_SUCCESS_FEEDBACK_ROLE_ARN_FIELD,
            FIREHOSE_SUCCESS_FEEDBACK_ROLE_ARN_FIELD, FIREHOSE_FAILURE_FEEDBACK_ROLE_ARN_FIELD,
            HTTP_SUCCESS_FEEDBACK_ROLE_ARN_FIELD, HTTP_FAILURE_FEEDBACK_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String kmsMasterKeyId;

    private final List<AwsSnsTopicSubscription> subscription;

    private final String topicName;

    private final String owner;

    private final String sqsSuccessFeedbackRoleArn;

    private final String sqsFailureFeedbackRoleArn;

    private final String applicationSuccessFeedbackRoleArn;

    private final String firehoseSuccessFeedbackRoleArn;

    private final String firehoseFailureFeedbackRoleArn;

    private final String httpSuccessFeedbackRoleArn;

    private final String httpFailureFeedbackRoleArn;

    private AwsSnsTopicDetails(BuilderImpl builder) {
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.subscription = builder.subscription;
        this.topicName = builder.topicName;
        this.owner = builder.owner;
        this.sqsSuccessFeedbackRoleArn = builder.sqsSuccessFeedbackRoleArn;
        this.sqsFailureFeedbackRoleArn = builder.sqsFailureFeedbackRoleArn;
        this.applicationSuccessFeedbackRoleArn = builder.applicationSuccessFeedbackRoleArn;
        this.firehoseSuccessFeedbackRoleArn = builder.firehoseSuccessFeedbackRoleArn;
        this.firehoseFailureFeedbackRoleArn = builder.firehoseFailureFeedbackRoleArn;
        this.httpSuccessFeedbackRoleArn = builder.httpSuccessFeedbackRoleArn;
        this.httpFailureFeedbackRoleArn = builder.httpFailureFeedbackRoleArn;
    }

    /**
     * <p>
     * The ID of an Amazon Web Services managed key for Amazon SNS or a customer managed key.
     * </p>
     * 
     * @return The ID of an Amazon Web Services managed key for Amazon SNS or a customer managed key.
     */
    public final String kmsMasterKeyId() {
        return kmsMasterKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subscription property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscription() {
        return subscription != null && !(subscription instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscription} method.
     * </p>
     * 
     * @return Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
     */
    public final List<AwsSnsTopicSubscription> subscription() {
        return subscription;
    }

    /**
     * <p>
     * The name of the Amazon SNS topic.
     * </p>
     * 
     * @return The name of the Amazon SNS topic.
     */
    public final String topicName() {
        return topicName;
    }

    /**
     * <p>
     * The subscription's owner.
     * </p>
     * 
     * @return The subscription's owner.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS
     * endpoint.
     * </p>
     * 
     * @return Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS
     *         endpoint.
     */
    public final String sqsSuccessFeedbackRoleArn() {
        return sqsSuccessFeedbackRoleArn;
    }

    /**
     * <p>
     * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
     * </p>
     * 
     * @return Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS
     *         endpoint.
     */
    public final String sqsFailureFeedbackRoleArn() {
        return sqsFailureFeedbackRoleArn;
    }

    /**
     * <p>
     * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to a platform application
     * endpoint.
     * </p>
     * 
     * @return Indicates failed message delivery status for an Amazon SNS topic that is subscribed to a platform
     *         application endpoint.
     */
    public final String applicationSuccessFeedbackRoleArn() {
        return applicationSuccessFeedbackRoleArn;
    }

    /**
     * <p>
     * Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data
     * Firehose endpoint.
     * </p>
     * 
     * @return Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon
     *         Kinesis Data Firehose endpoint.
     */
    public final String firehoseSuccessFeedbackRoleArn() {
        return firehoseSuccessFeedbackRoleArn;
    }

    /**
     * <p>
     * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data
     * Firehose endpoint.
     * </p>
     * 
     * @return Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis
     *         Data Firehose endpoint.
     */
    public final String firehoseFailureFeedbackRoleArn() {
        return firehoseFailureFeedbackRoleArn;
    }

    /**
     * <p>
     * Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.
     * </p>
     * 
     * @return Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an HTTP
     *         endpoint.
     */
    public final String httpSuccessFeedbackRoleArn() {
        return httpSuccessFeedbackRoleArn;
    }

    /**
     * <p>
     * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.
     * </p>
     * 
     * @return Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.
     */
    public final String httpFailureFeedbackRoleArn() {
        return httpFailureFeedbackRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscription() ? subscription() : null);
        hashCode = 31 * hashCode + Objects.hashCode(topicName());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(sqsSuccessFeedbackRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(sqsFailureFeedbackRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSuccessFeedbackRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(firehoseSuccessFeedbackRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(firehoseFailureFeedbackRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(httpSuccessFeedbackRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(httpFailureFeedbackRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSnsTopicDetails)) {
            return false;
        }
        AwsSnsTopicDetails other = (AwsSnsTopicDetails) obj;
        return Objects.equals(kmsMasterKeyId(), other.kmsMasterKeyId()) && hasSubscription() == other.hasSubscription()
                && Objects.equals(subscription(), other.subscription()) && Objects.equals(topicName(), other.topicName())
                && Objects.equals(owner(), other.owner())
                && Objects.equals(sqsSuccessFeedbackRoleArn(), other.sqsSuccessFeedbackRoleArn())
                && Objects.equals(sqsFailureFeedbackRoleArn(), other.sqsFailureFeedbackRoleArn())
                && Objects.equals(applicationSuccessFeedbackRoleArn(), other.applicationSuccessFeedbackRoleArn())
                && Objects.equals(firehoseSuccessFeedbackRoleArn(), other.firehoseSuccessFeedbackRoleArn())
                && Objects.equals(firehoseFailureFeedbackRoleArn(), other.firehoseFailureFeedbackRoleArn())
                && Objects.equals(httpSuccessFeedbackRoleArn(), other.httpSuccessFeedbackRoleArn())
                && Objects.equals(httpFailureFeedbackRoleArn(), other.httpFailureFeedbackRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsSnsTopicDetails").add("KmsMasterKeyId", kmsMasterKeyId())
                .add("Subscription", hasSubscription() ? subscription() : null).add("TopicName", topicName())
                .add("Owner", owner()).add("SqsSuccessFeedbackRoleArn", sqsSuccessFeedbackRoleArn())
                .add("SqsFailureFeedbackRoleArn", sqsFailureFeedbackRoleArn())
                .add("ApplicationSuccessFeedbackRoleArn", applicationSuccessFeedbackRoleArn())
                .add("FirehoseSuccessFeedbackRoleArn", firehoseSuccessFeedbackRoleArn())
                .add("FirehoseFailureFeedbackRoleArn", firehoseFailureFeedbackRoleArn())
                .add("HttpSuccessFeedbackRoleArn", httpSuccessFeedbackRoleArn())
                .add("HttpFailureFeedbackRoleArn", httpFailureFeedbackRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsMasterKeyId":
            return Optional.ofNullable(clazz.cast(kmsMasterKeyId()));
        case "Subscription":
            return Optional.ofNullable(clazz.cast(subscription()));
        case "TopicName":
            return Optional.ofNullable(clazz.cast(topicName()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "SqsSuccessFeedbackRoleArn":
            return Optional.ofNullable(clazz.cast(sqsSuccessFeedbackRoleArn()));
        case "SqsFailureFeedbackRoleArn":
            return Optional.ofNullable(clazz.cast(sqsFailureFeedbackRoleArn()));
        case "ApplicationSuccessFeedbackRoleArn":
            return Optional.ofNullable(clazz.cast(applicationSuccessFeedbackRoleArn()));
        case "FirehoseSuccessFeedbackRoleArn":
            return Optional.ofNullable(clazz.cast(firehoseSuccessFeedbackRoleArn()));
        case "FirehoseFailureFeedbackRoleArn":
            return Optional.ofNullable(clazz.cast(firehoseFailureFeedbackRoleArn()));
        case "HttpSuccessFeedbackRoleArn":
            return Optional.ofNullable(clazz.cast(httpSuccessFeedbackRoleArn()));
        case "HttpFailureFeedbackRoleArn":
            return Optional.ofNullable(clazz.cast(httpFailureFeedbackRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KmsMasterKeyId", KMS_MASTER_KEY_ID_FIELD);
        map.put("Subscription", SUBSCRIPTION_FIELD);
        map.put("TopicName", TOPIC_NAME_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("SqsSuccessFeedbackRoleArn", SQS_SUCCESS_FEEDBACK_ROLE_ARN_FIELD);
        map.put("SqsFailureFeedbackRoleArn", SQS_FAILURE_FEEDBACK_ROLE_ARN_FIELD);
        map.put("ApplicationSuccessFeedbackRoleArn", APPLICATION_SUCCESS_FEEDBACK_ROLE_ARN_FIELD);
        map.put("FirehoseSuccessFeedbackRoleArn", FIREHOSE_SUCCESS_FEEDBACK_ROLE_ARN_FIELD);
        map.put("FirehoseFailureFeedbackRoleArn", FIREHOSE_FAILURE_FEEDBACK_ROLE_ARN_FIELD);
        map.put("HttpSuccessFeedbackRoleArn", HTTP_SUCCESS_FEEDBACK_ROLE_ARN_FIELD);
        map.put("HttpFailureFeedbackRoleArn", HTTP_FAILURE_FEEDBACK_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsSnsTopicDetails, T> g) {
        return obj -> g.apply((AwsSnsTopicDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSnsTopicDetails> {
        /**
         * <p>
         * The ID of an Amazon Web Services managed key for Amazon SNS or a customer managed key.
         * </p>
         * 
         * @param kmsMasterKeyId
         *        The ID of an Amazon Web Services managed key for Amazon SNS or a customer managed key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsMasterKeyId(String kmsMasterKeyId);

        /**
         * <p>
         * Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
         * </p>
         * 
         * @param subscription
         *        Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscription(Collection<AwsSnsTopicSubscription> subscription);

        /**
         * <p>
         * Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
         * </p>
         * 
         * @param subscription
         *        Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscription(AwsSnsTopicSubscription... subscription);

        /**
         * <p>
         * Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsSnsTopicSubscription.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsSnsTopicSubscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsSnsTopicSubscription.Builder#build()} is called
         * immediately and its result is passed to {@link #subscription(List<AwsSnsTopicSubscription>)}.
         * 
         * @param subscription
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsSnsTopicSubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscription(java.util.Collection<AwsSnsTopicSubscription>)
         */
        Builder subscription(Consumer<AwsSnsTopicSubscription.Builder>... subscription);

        /**
         * <p>
         * The name of the Amazon SNS topic.
         * </p>
         * 
         * @param topicName
         *        The name of the Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicName(String topicName);

        /**
         * <p>
         * The subscription's owner.
         * </p>
         * 
         * @param owner
         *        The subscription's owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS
         * endpoint.
         * </p>
         * 
         * @param sqsSuccessFeedbackRoleArn
         *        Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon
         *        SQS endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqsSuccessFeedbackRoleArn(String sqsSuccessFeedbackRoleArn);

        /**
         * <p>
         * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS
         * endpoint.
         * </p>
         * 
         * @param sqsFailureFeedbackRoleArn
         *        Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqsFailureFeedbackRoleArn(String sqsFailureFeedbackRoleArn);

        /**
         * <p>
         * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to a platform application
         * endpoint.
         * </p>
         * 
         * @param applicationSuccessFeedbackRoleArn
         *        Indicates failed message delivery status for an Amazon SNS topic that is subscribed to a platform
         *        application endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSuccessFeedbackRoleArn(String applicationSuccessFeedbackRoleArn);

        /**
         * <p>
         * Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis
         * Data Firehose endpoint.
         * </p>
         * 
         * @param firehoseSuccessFeedbackRoleArn
         *        Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon
         *        Kinesis Data Firehose endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehoseSuccessFeedbackRoleArn(String firehoseSuccessFeedbackRoleArn);

        /**
         * <p>
         * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data
         * Firehose endpoint.
         * </p>
         * 
         * @param firehoseFailureFeedbackRoleArn
         *        Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon
         *        Kinesis Data Firehose endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehoseFailureFeedbackRoleArn(String firehoseFailureFeedbackRoleArn);

        /**
         * <p>
         * Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.
         * </p>
         * 
         * @param httpSuccessFeedbackRoleArn
         *        Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an HTTP
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpSuccessFeedbackRoleArn(String httpSuccessFeedbackRoleArn);

        /**
         * <p>
         * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.
         * </p>
         * 
         * @param httpFailureFeedbackRoleArn
         *        Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an HTTP
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpFailureFeedbackRoleArn(String httpFailureFeedbackRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String kmsMasterKeyId;

        private List<AwsSnsTopicSubscription> subscription = DefaultSdkAutoConstructList.getInstance();

        private String topicName;

        private String owner;

        private String sqsSuccessFeedbackRoleArn;

        private String sqsFailureFeedbackRoleArn;

        private String applicationSuccessFeedbackRoleArn;

        private String firehoseSuccessFeedbackRoleArn;

        private String firehoseFailureFeedbackRoleArn;

        private String httpSuccessFeedbackRoleArn;

        private String httpFailureFeedbackRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSnsTopicDetails model) {
            kmsMasterKeyId(model.kmsMasterKeyId);
            subscription(model.subscription);
            topicName(model.topicName);
            owner(model.owner);
            sqsSuccessFeedbackRoleArn(model.sqsSuccessFeedbackRoleArn);
            sqsFailureFeedbackRoleArn(model.sqsFailureFeedbackRoleArn);
            applicationSuccessFeedbackRoleArn(model.applicationSuccessFeedbackRoleArn);
            firehoseSuccessFeedbackRoleArn(model.firehoseSuccessFeedbackRoleArn);
            firehoseFailureFeedbackRoleArn(model.firehoseFailureFeedbackRoleArn);
            httpSuccessFeedbackRoleArn(model.httpSuccessFeedbackRoleArn);
            httpFailureFeedbackRoleArn(model.httpFailureFeedbackRoleArn);
        }

        public final String getKmsMasterKeyId() {
            return kmsMasterKeyId;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final List<AwsSnsTopicSubscription.Builder> getSubscription() {
            List<AwsSnsTopicSubscription.Builder> result = AwsSnsTopicSubscriptionListCopier.copyToBuilder(this.subscription);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscription(Collection<AwsSnsTopicSubscription.BuilderImpl> subscription) {
            this.subscription = AwsSnsTopicSubscriptionListCopier.copyFromBuilder(subscription);
        }

        @Override
        public final Builder subscription(Collection<AwsSnsTopicSubscription> subscription) {
            this.subscription = AwsSnsTopicSubscriptionListCopier.copy(subscription);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscription(AwsSnsTopicSubscription... subscription) {
            subscription(Arrays.asList(subscription));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscription(Consumer<AwsSnsTopicSubscription.Builder>... subscription) {
            subscription(Stream.of(subscription).map(c -> AwsSnsTopicSubscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTopicName() {
            return topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getSqsSuccessFeedbackRoleArn() {
            return sqsSuccessFeedbackRoleArn;
        }

        public final void setSqsSuccessFeedbackRoleArn(String sqsSuccessFeedbackRoleArn) {
            this.sqsSuccessFeedbackRoleArn = sqsSuccessFeedbackRoleArn;
        }

        @Override
        public final Builder sqsSuccessFeedbackRoleArn(String sqsSuccessFeedbackRoleArn) {
            this.sqsSuccessFeedbackRoleArn = sqsSuccessFeedbackRoleArn;
            return this;
        }

        public final String getSqsFailureFeedbackRoleArn() {
            return sqsFailureFeedbackRoleArn;
        }

        public final void setSqsFailureFeedbackRoleArn(String sqsFailureFeedbackRoleArn) {
            this.sqsFailureFeedbackRoleArn = sqsFailureFeedbackRoleArn;
        }

        @Override
        public final Builder sqsFailureFeedbackRoleArn(String sqsFailureFeedbackRoleArn) {
            this.sqsFailureFeedbackRoleArn = sqsFailureFeedbackRoleArn;
            return this;
        }

        public final String getApplicationSuccessFeedbackRoleArn() {
            return applicationSuccessFeedbackRoleArn;
        }

        public final void setApplicationSuccessFeedbackRoleArn(String applicationSuccessFeedbackRoleArn) {
            this.applicationSuccessFeedbackRoleArn = applicationSuccessFeedbackRoleArn;
        }

        @Override
        public final Builder applicationSuccessFeedbackRoleArn(String applicationSuccessFeedbackRoleArn) {
            this.applicationSuccessFeedbackRoleArn = applicationSuccessFeedbackRoleArn;
            return this;
        }

        public final String getFirehoseSuccessFeedbackRoleArn() {
            return firehoseSuccessFeedbackRoleArn;
        }

        public final void setFirehoseSuccessFeedbackRoleArn(String firehoseSuccessFeedbackRoleArn) {
            this.firehoseSuccessFeedbackRoleArn = firehoseSuccessFeedbackRoleArn;
        }

        @Override
        public final Builder firehoseSuccessFeedbackRoleArn(String firehoseSuccessFeedbackRoleArn) {
            this.firehoseSuccessFeedbackRoleArn = firehoseSuccessFeedbackRoleArn;
            return this;
        }

        public final String getFirehoseFailureFeedbackRoleArn() {
            return firehoseFailureFeedbackRoleArn;
        }

        public final void setFirehoseFailureFeedbackRoleArn(String firehoseFailureFeedbackRoleArn) {
            this.firehoseFailureFeedbackRoleArn = firehoseFailureFeedbackRoleArn;
        }

        @Override
        public final Builder firehoseFailureFeedbackRoleArn(String firehoseFailureFeedbackRoleArn) {
            this.firehoseFailureFeedbackRoleArn = firehoseFailureFeedbackRoleArn;
            return this;
        }

        public final String getHttpSuccessFeedbackRoleArn() {
            return httpSuccessFeedbackRoleArn;
        }

        public final void setHttpSuccessFeedbackRoleArn(String httpSuccessFeedbackRoleArn) {
            this.httpSuccessFeedbackRoleArn = httpSuccessFeedbackRoleArn;
        }

        @Override
        public final Builder httpSuccessFeedbackRoleArn(String httpSuccessFeedbackRoleArn) {
            this.httpSuccessFeedbackRoleArn = httpSuccessFeedbackRoleArn;
            return this;
        }

        public final String getHttpFailureFeedbackRoleArn() {
            return httpFailureFeedbackRoleArn;
        }

        public final void setHttpFailureFeedbackRoleArn(String httpFailureFeedbackRoleArn) {
            this.httpFailureFeedbackRoleArn = httpFailureFeedbackRoleArn;
        }

        @Override
        public final Builder httpFailureFeedbackRoleArn(String httpFailureFeedbackRoleArn) {
            this.httpFailureFeedbackRoleArn = httpFailureFeedbackRoleArn;
            return this;
        }

        @Override
        public AwsSnsTopicDetails build() {
            return new AwsSnsTopicDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
