/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the S3 Object Lock rule for the specified object. In Amazon S3, Object Lock can help prevent objects from
 * being deleted or overwritten for a fixed amount of time or indefinitely.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketObjectLockConfigurationRuleDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketObjectLockConfigurationRuleDetails.Builder, AwsS3BucketObjectLockConfigurationRuleDetails> {
    private static final SdkField<AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails> DEFAULT_RETENTION_FIELD = SdkField
            .<AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultRetention").getter(getter(AwsS3BucketObjectLockConfigurationRuleDetails::defaultRetention))
            .setter(setter(Builder::defaultRetention))
            .constructor(AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRetention").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_RETENTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails defaultRetention;

    private AwsS3BucketObjectLockConfigurationRuleDetails(BuilderImpl builder) {
        this.defaultRetention = builder.defaultRetention;
    }

    /**
     * <p>
     * The default Object Lock retention mode and period that you want to apply to new objects placed in the specified
     * bucket.
     * </p>
     * 
     * @return The default Object Lock retention mode and period that you want to apply to new objects placed in the
     *         specified bucket.
     */
    public final AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails defaultRetention() {
        return defaultRetention;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultRetention());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketObjectLockConfigurationRuleDetails)) {
            return false;
        }
        AwsS3BucketObjectLockConfigurationRuleDetails other = (AwsS3BucketObjectLockConfigurationRuleDetails) obj;
        return Objects.equals(defaultRetention(), other.defaultRetention());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketObjectLockConfigurationRuleDetails").add("DefaultRetention", defaultRetention())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultRetention":
            return Optional.ofNullable(clazz.cast(defaultRetention()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultRetention", DEFAULT_RETENTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketObjectLockConfigurationRuleDetails, T> g) {
        return obj -> g.apply((AwsS3BucketObjectLockConfigurationRuleDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketObjectLockConfigurationRuleDetails> {
        /**
         * <p>
         * The default Object Lock retention mode and period that you want to apply to new objects placed in the
         * specified bucket.
         * </p>
         * 
         * @param defaultRetention
         *        The default Object Lock retention mode and period that you want to apply to new objects placed in the
         *        specified bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRetention(AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails defaultRetention);

        /**
         * <p>
         * The default Object Lock retention mode and period that you want to apply to new objects placed in the
         * specified bucket.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.Builder} avoiding the need to create one
         * manually via {@link AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #defaultRetention(AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails)}.
         * 
         * @param defaultRetention
         *        a consumer that will call methods on
         *        {@link AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultRetention(AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails)
         */
        default Builder defaultRetention(
                Consumer<AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.Builder> defaultRetention) {
            return defaultRetention(AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.builder()
                    .applyMutation(defaultRetention).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails defaultRetention;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketObjectLockConfigurationRuleDetails model) {
            defaultRetention(model.defaultRetention);
        }

        public final AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.Builder getDefaultRetention() {
            return defaultRetention != null ? defaultRetention.toBuilder() : null;
        }

        public final void setDefaultRetention(
                AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.BuilderImpl defaultRetention) {
            this.defaultRetention = defaultRetention != null ? defaultRetention.build() : null;
        }

        @Override
        public final Builder defaultRetention(AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails defaultRetention) {
            this.defaultRetention = defaultRetention;
            return this;
        }

        @Override
        public AwsS3BucketObjectLockConfigurationRuleDetails build() {
            return new AwsS3BucketObjectLockConfigurationRuleDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
