/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container element for S3 Object Lock configuration parameters. In Amazon S3, Object Lock can help prevent objects
 * from being deleted or overwritten for a fixed amount of time or indefinitely.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketObjectLockConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketObjectLockConfiguration.Builder, AwsS3BucketObjectLockConfiguration> {
    private static final SdkField<String> OBJECT_LOCK_ENABLED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectLockEnabled").getter(getter(AwsS3BucketObjectLockConfiguration::objectLockEnabled))
            .setter(setter(Builder::objectLockEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLockEnabled").build()).build();

    private static final SdkField<AwsS3BucketObjectLockConfigurationRuleDetails> RULE_FIELD = SdkField
            .<AwsS3BucketObjectLockConfigurationRuleDetails> builder(MarshallingType.SDK_POJO).memberName("Rule")
            .getter(getter(AwsS3BucketObjectLockConfiguration::rule)).setter(setter(Builder::rule))
            .constructor(AwsS3BucketObjectLockConfigurationRuleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_LOCK_ENABLED_FIELD,
            RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String objectLockEnabled;

    private final AwsS3BucketObjectLockConfigurationRuleDetails rule;

    private AwsS3BucketObjectLockConfiguration(BuilderImpl builder) {
        this.objectLockEnabled = builder.objectLockEnabled;
        this.rule = builder.rule;
    }

    /**
     * <p>
     * Indicates whether the bucket has an Object Lock configuration enabled.
     * </p>
     * 
     * @return Indicates whether the bucket has an Object Lock configuration enabled.
     */
    public final String objectLockEnabled() {
        return objectLockEnabled;
    }

    /**
     * <p>
     * Specifies the Object Lock rule for the specified object.
     * </p>
     * 
     * @return Specifies the Object Lock rule for the specified object.
     */
    public final AwsS3BucketObjectLockConfigurationRuleDetails rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectLockEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketObjectLockConfiguration)) {
            return false;
        }
        AwsS3BucketObjectLockConfiguration other = (AwsS3BucketObjectLockConfiguration) obj;
        return Objects.equals(objectLockEnabled(), other.objectLockEnabled()) && Objects.equals(rule(), other.rule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketObjectLockConfiguration").add("ObjectLockEnabled", objectLockEnabled())
                .add("Rule", rule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectLockEnabled":
            return Optional.ofNullable(clazz.cast(objectLockEnabled()));
        case "Rule":
            return Optional.ofNullable(clazz.cast(rule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ObjectLockEnabled", OBJECT_LOCK_ENABLED_FIELD);
        map.put("Rule", RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketObjectLockConfiguration, T> g) {
        return obj -> g.apply((AwsS3BucketObjectLockConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketObjectLockConfiguration> {
        /**
         * <p>
         * Indicates whether the bucket has an Object Lock configuration enabled.
         * </p>
         * 
         * @param objectLockEnabled
         *        Indicates whether the bucket has an Object Lock configuration enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectLockEnabled(String objectLockEnabled);

        /**
         * <p>
         * Specifies the Object Lock rule for the specified object.
         * </p>
         * 
         * @param rule
         *        Specifies the Object Lock rule for the specified object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(AwsS3BucketObjectLockConfigurationRuleDetails rule);

        /**
         * <p>
         * Specifies the Object Lock rule for the specified object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3BucketObjectLockConfigurationRuleDetails.Builder} avoiding the need to create one manually via
         * {@link AwsS3BucketObjectLockConfigurationRuleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3BucketObjectLockConfigurationRuleDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #rule(AwsS3BucketObjectLockConfigurationRuleDetails)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link AwsS3BucketObjectLockConfigurationRuleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(AwsS3BucketObjectLockConfigurationRuleDetails)
         */
        default Builder rule(Consumer<AwsS3BucketObjectLockConfigurationRuleDetails.Builder> rule) {
            return rule(AwsS3BucketObjectLockConfigurationRuleDetails.builder().applyMutation(rule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String objectLockEnabled;

        private AwsS3BucketObjectLockConfigurationRuleDetails rule;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketObjectLockConfiguration model) {
            objectLockEnabled(model.objectLockEnabled);
            rule(model.rule);
        }

        public final String getObjectLockEnabled() {
            return objectLockEnabled;
        }

        public final void setObjectLockEnabled(String objectLockEnabled) {
            this.objectLockEnabled = objectLockEnabled;
        }

        @Override
        public final Builder objectLockEnabled(String objectLockEnabled) {
            this.objectLockEnabled = objectLockEnabled;
            return this;
        }

        public final AwsS3BucketObjectLockConfigurationRuleDetails.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(AwsS3BucketObjectLockConfigurationRuleDetails.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(AwsS3BucketObjectLockConfigurationRuleDetails rule) {
            this.rule = rule;
            return this;
        }

        @Override
        public AwsS3BucketObjectLockConfiguration build() {
            return new AwsS3BucketObjectLockConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
