/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of a parameter in a cluster parameter group for an Amazon Redshift cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRedshiftClusterClusterParameterStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRedshiftClusterClusterParameterStatus.Builder, AwsRedshiftClusterClusterParameterStatus> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterName").getter(getter(AwsRedshiftClusterClusterParameterStatus::parameterName))
            .setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final SdkField<String> PARAMETER_APPLY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterApplyStatus").getter(getter(AwsRedshiftClusterClusterParameterStatus::parameterApplyStatus))
            .setter(setter(Builder::parameterApplyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterApplyStatus").build())
            .build();

    private static final SdkField<String> PARAMETER_APPLY_ERROR_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ParameterApplyErrorDescription")
            .getter(getter(AwsRedshiftClusterClusterParameterStatus::parameterApplyErrorDescription))
            .setter(setter(Builder::parameterApplyErrorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterApplyErrorDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD,
            PARAMETER_APPLY_STATUS_FIELD, PARAMETER_APPLY_ERROR_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parameterName;

    private final String parameterApplyStatus;

    private final String parameterApplyErrorDescription;

    private AwsRedshiftClusterClusterParameterStatus(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.parameterApplyErrorDescription = builder.parameterApplyErrorDescription;
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * 
     * @return The name of the parameter.
     */
    public final String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * The status of the parameter. Indicates whether the parameter is in sync with the database, waiting for a cluster
     * reboot, or encountered an error when it was applied.
     * </p>
     * <p>
     * Valid values: <code>in-sync</code> | <code>pending-reboot</code> | <code>applying</code> |
     * <code>invalid-parameter</code> | <code>apply-deferred</code> | <code>apply-error</code> |
     * <code>unknown-error</code>
     * </p>
     * 
     * @return The status of the parameter. Indicates whether the parameter is in sync with the database, waiting for a
     *         cluster reboot, or encountered an error when it was applied.</p>
     *         <p>
     *         Valid values: <code>in-sync</code> | <code>pending-reboot</code> | <code>applying</code> |
     *         <code>invalid-parameter</code> | <code>apply-deferred</code> | <code>apply-error</code> |
     *         <code>unknown-error</code>
     */
    public final String parameterApplyStatus() {
        return parameterApplyStatus;
    }

    /**
     * <p>
     * The error that prevented the parameter from being applied to the database.
     * </p>
     * 
     * @return The error that prevented the parameter from being applied to the database.
     */
    public final String parameterApplyErrorDescription() {
        return parameterApplyErrorDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterApplyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(parameterApplyErrorDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterClusterParameterStatus)) {
            return false;
        }
        AwsRedshiftClusterClusterParameterStatus other = (AwsRedshiftClusterClusterParameterStatus) obj;
        return Objects.equals(parameterName(), other.parameterName())
                && Objects.equals(parameterApplyStatus(), other.parameterApplyStatus())
                && Objects.equals(parameterApplyErrorDescription(), other.parameterApplyErrorDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRedshiftClusterClusterParameterStatus").add("ParameterName", parameterName())
                .add("ParameterApplyStatus", parameterApplyStatus())
                .add("ParameterApplyErrorDescription", parameterApplyErrorDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "ParameterApplyStatus":
            return Optional.ofNullable(clazz.cast(parameterApplyStatus()));
        case "ParameterApplyErrorDescription":
            return Optional.ofNullable(clazz.cast(parameterApplyErrorDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParameterName", PARAMETER_NAME_FIELD);
        map.put("ParameterApplyStatus", PARAMETER_APPLY_STATUS_FIELD);
        map.put("ParameterApplyErrorDescription", PARAMETER_APPLY_ERROR_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterClusterParameterStatus, T> g) {
        return obj -> g.apply((AwsRedshiftClusterClusterParameterStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRedshiftClusterClusterParameterStatus> {
        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param parameterName
         *        The name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * The status of the parameter. Indicates whether the parameter is in sync with the database, waiting for a
         * cluster reboot, or encountered an error when it was applied.
         * </p>
         * <p>
         * Valid values: <code>in-sync</code> | <code>pending-reboot</code> | <code>applying</code> |
         * <code>invalid-parameter</code> | <code>apply-deferred</code> | <code>apply-error</code> |
         * <code>unknown-error</code>
         * </p>
         * 
         * @param parameterApplyStatus
         *        The status of the parameter. Indicates whether the parameter is in sync with the database, waiting for
         *        a cluster reboot, or encountered an error when it was applied.</p>
         *        <p>
         *        Valid values: <code>in-sync</code> | <code>pending-reboot</code> | <code>applying</code> |
         *        <code>invalid-parameter</code> | <code>apply-deferred</code> | <code>apply-error</code> |
         *        <code>unknown-error</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterApplyStatus(String parameterApplyStatus);

        /**
         * <p>
         * The error that prevented the parameter from being applied to the database.
         * </p>
         * 
         * @param parameterApplyErrorDescription
         *        The error that prevented the parameter from being applied to the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterApplyErrorDescription(String parameterApplyErrorDescription);
    }

    static final class BuilderImpl implements Builder {
        private String parameterName;

        private String parameterApplyStatus;

        private String parameterApplyErrorDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterClusterParameterStatus model) {
            parameterName(model.parameterName);
            parameterApplyStatus(model.parameterApplyStatus);
            parameterApplyErrorDescription(model.parameterApplyErrorDescription);
        }

        public final String getParameterName() {
            return parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getParameterApplyStatus() {
            return parameterApplyStatus;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final String getParameterApplyErrorDescription() {
            return parameterApplyErrorDescription;
        }

        public final void setParameterApplyErrorDescription(String parameterApplyErrorDescription) {
            this.parameterApplyErrorDescription = parameterApplyErrorDescription;
        }

        @Override
        public final Builder parameterApplyErrorDescription(String parameterApplyErrorDescription) {
            this.parameterApplyErrorDescription = parameterApplyErrorDescription;
            return this;
        }

        @Override
        public AwsRedshiftClusterClusterParameterStatus build() {
            return new AwsRedshiftClusterClusterParameterStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
