/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a subnet in a subnet group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsDbSubnetGroupSubnet implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsDbSubnetGroupSubnet.Builder, AwsRdsDbSubnetGroupSubnet> {
    private static final SdkField<String> SUBNET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetIdentifier").getter(getter(AwsRdsDbSubnetGroupSubnet::subnetIdentifier))
            .setter(setter(Builder::subnetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdentifier").build()).build();

    private static final SdkField<AwsRdsDbSubnetGroupSubnetAvailabilityZone> SUBNET_AVAILABILITY_ZONE_FIELD = SdkField
            .<AwsRdsDbSubnetGroupSubnetAvailabilityZone> builder(MarshallingType.SDK_POJO).memberName("SubnetAvailabilityZone")
            .getter(getter(AwsRdsDbSubnetGroupSubnet::subnetAvailabilityZone)).setter(setter(Builder::subnetAvailabilityZone))
            .constructor(AwsRdsDbSubnetGroupSubnetAvailabilityZone::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZone").build())
            .build();

    private static final SdkField<String> SUBNET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetStatus").getter(getter(AwsRdsDbSubnetGroupSubnet::subnetStatus))
            .setter(setter(Builder::subnetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDENTIFIER_FIELD,
            SUBNET_AVAILABILITY_ZONE_FIELD, SUBNET_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String subnetIdentifier;

    private final AwsRdsDbSubnetGroupSubnetAvailabilityZone subnetAvailabilityZone;

    private final String subnetStatus;

    private AwsRdsDbSubnetGroupSubnet(BuilderImpl builder) {
        this.subnetIdentifier = builder.subnetIdentifier;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
        this.subnetStatus = builder.subnetStatus;
    }

    /**
     * <p>
     * The identifier of a subnet in the subnet group.
     * </p>
     * 
     * @return The identifier of a subnet in the subnet group.
     */
    public final String subnetIdentifier() {
        return subnetIdentifier;
    }

    /**
     * <p>
     * Information about the Availability Zone for a subnet in the subnet group.
     * </p>
     * 
     * @return Information about the Availability Zone for a subnet in the subnet group.
     */
    public final AwsRdsDbSubnetGroupSubnetAvailabilityZone subnetAvailabilityZone() {
        return subnetAvailabilityZone;
    }

    /**
     * <p>
     * The status of a subnet in the subnet group.
     * </p>
     * 
     * @return The status of a subnet in the subnet group.
     */
    public final String subnetStatus() {
        return subnetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(subnetAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(subnetStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbSubnetGroupSubnet)) {
            return false;
        }
        AwsRdsDbSubnetGroupSubnet other = (AwsRdsDbSubnetGroupSubnet) obj;
        return Objects.equals(subnetIdentifier(), other.subnetIdentifier())
                && Objects.equals(subnetAvailabilityZone(), other.subnetAvailabilityZone())
                && Objects.equals(subnetStatus(), other.subnetStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRdsDbSubnetGroupSubnet").add("SubnetIdentifier", subnetIdentifier())
                .add("SubnetAvailabilityZone", subnetAvailabilityZone()).add("SubnetStatus", subnetStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetIdentifier":
            return Optional.ofNullable(clazz.cast(subnetIdentifier()));
        case "SubnetAvailabilityZone":
            return Optional.ofNullable(clazz.cast(subnetAvailabilityZone()));
        case "SubnetStatus":
            return Optional.ofNullable(clazz.cast(subnetStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SubnetIdentifier", SUBNET_IDENTIFIER_FIELD);
        map.put("SubnetAvailabilityZone", SUBNET_AVAILABILITY_ZONE_FIELD);
        map.put("SubnetStatus", SUBNET_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbSubnetGroupSubnet, T> g) {
        return obj -> g.apply((AwsRdsDbSubnetGroupSubnet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsDbSubnetGroupSubnet> {
        /**
         * <p>
         * The identifier of a subnet in the subnet group.
         * </p>
         * 
         * @param subnetIdentifier
         *        The identifier of a subnet in the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIdentifier(String subnetIdentifier);

        /**
         * <p>
         * Information about the Availability Zone for a subnet in the subnet group.
         * </p>
         * 
         * @param subnetAvailabilityZone
         *        Information about the Availability Zone for a subnet in the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetAvailabilityZone(AwsRdsDbSubnetGroupSubnetAvailabilityZone subnetAvailabilityZone);

        /**
         * <p>
         * Information about the Availability Zone for a subnet in the subnet group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsRdsDbSubnetGroupSubnetAvailabilityZone.Builder} avoiding the need to create one manually via
         * {@link AwsRdsDbSubnetGroupSubnetAvailabilityZone#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRdsDbSubnetGroupSubnetAvailabilityZone.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #subnetAvailabilityZone(AwsRdsDbSubnetGroupSubnetAvailabilityZone)}.
         * 
         * @param subnetAvailabilityZone
         *        a consumer that will call methods on {@link AwsRdsDbSubnetGroupSubnetAvailabilityZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetAvailabilityZone(AwsRdsDbSubnetGroupSubnetAvailabilityZone)
         */
        default Builder subnetAvailabilityZone(Consumer<AwsRdsDbSubnetGroupSubnetAvailabilityZone.Builder> subnetAvailabilityZone) {
            return subnetAvailabilityZone(AwsRdsDbSubnetGroupSubnetAvailabilityZone.builder()
                    .applyMutation(subnetAvailabilityZone).build());
        }

        /**
         * <p>
         * The status of a subnet in the subnet group.
         * </p>
         * 
         * @param subnetStatus
         *        The status of a subnet in the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetStatus(String subnetStatus);
    }

    static final class BuilderImpl implements Builder {
        private String subnetIdentifier;

        private AwsRdsDbSubnetGroupSubnetAvailabilityZone subnetAvailabilityZone;

        private String subnetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbSubnetGroupSubnet model) {
            subnetIdentifier(model.subnetIdentifier);
            subnetAvailabilityZone(model.subnetAvailabilityZone);
            subnetStatus(model.subnetStatus);
        }

        public final String getSubnetIdentifier() {
            return subnetIdentifier;
        }

        public final void setSubnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
        }

        @Override
        public final Builder subnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
            return this;
        }

        public final AwsRdsDbSubnetGroupSubnetAvailabilityZone.Builder getSubnetAvailabilityZone() {
            return subnetAvailabilityZone != null ? subnetAvailabilityZone.toBuilder() : null;
        }

        public final void setSubnetAvailabilityZone(AwsRdsDbSubnetGroupSubnetAvailabilityZone.BuilderImpl subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone != null ? subnetAvailabilityZone.build() : null;
        }

        @Override
        public final Builder subnetAvailabilityZone(AwsRdsDbSubnetGroupSubnetAvailabilityZone subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final String getSubnetStatus() {
            return subnetStatus;
        }

        public final void setSubnetStatus(String subnetStatus) {
            this.subnetStatus = subnetStatus;
        }

        @Override
        public final Builder subnetStatus(String subnetStatus) {
            this.subnetStatus = subnetStatus;
            return this;
        }

        @Override
        public AwsRdsDbSubnetGroupSubnet build() {
            return new AwsRdsDbSubnetGroupSubnet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
