/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Amazon Managed Streaming for Apache Kafka (Amazon MSK) cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsMskClusterDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsMskClusterDetails.Builder, AwsMskClusterDetails> {
    private static final SdkField<AwsMskClusterClusterInfoDetails> CLUSTER_INFO_FIELD = SdkField
            .<AwsMskClusterClusterInfoDetails> builder(MarshallingType.SDK_POJO).memberName("ClusterInfo")
            .getter(getter(AwsMskClusterDetails::clusterInfo)).setter(setter(Builder::clusterInfo))
            .constructor(AwsMskClusterClusterInfoDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsMskClusterClusterInfoDetails clusterInfo;

    private AwsMskClusterDetails(BuilderImpl builder) {
        this.clusterInfo = builder.clusterInfo;
    }

    /**
     * <p>
     * Provides information about a cluster.
     * </p>
     * 
     * @return Provides information about a cluster.
     */
    public final AwsMskClusterClusterInfoDetails clusterInfo() {
        return clusterInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsMskClusterDetails)) {
            return false;
        }
        AwsMskClusterDetails other = (AwsMskClusterDetails) obj;
        return Objects.equals(clusterInfo(), other.clusterInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsMskClusterDetails").add("ClusterInfo", clusterInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterInfo":
            return Optional.ofNullable(clazz.cast(clusterInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterInfo", CLUSTER_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsMskClusterDetails, T> g) {
        return obj -> g.apply((AwsMskClusterDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsMskClusterDetails> {
        /**
         * <p>
         * Provides information about a cluster.
         * </p>
         * 
         * @param clusterInfo
         *        Provides information about a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterInfo(AwsMskClusterClusterInfoDetails clusterInfo);

        /**
         * <p>
         * Provides information about a cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsMskClusterClusterInfoDetails.Builder}
         * avoiding the need to create one manually via {@link AwsMskClusterClusterInfoDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsMskClusterClusterInfoDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #clusterInfo(AwsMskClusterClusterInfoDetails)}.
         * 
         * @param clusterInfo
         *        a consumer that will call methods on {@link AwsMskClusterClusterInfoDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterInfo(AwsMskClusterClusterInfoDetails)
         */
        default Builder clusterInfo(Consumer<AwsMskClusterClusterInfoDetails.Builder> clusterInfo) {
            return clusterInfo(AwsMskClusterClusterInfoDetails.builder().applyMutation(clusterInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsMskClusterClusterInfoDetails clusterInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsMskClusterDetails model) {
            clusterInfo(model.clusterInfo);
        }

        public final AwsMskClusterClusterInfoDetails.Builder getClusterInfo() {
            return clusterInfo != null ? clusterInfo.toBuilder() : null;
        }

        public final void setClusterInfo(AwsMskClusterClusterInfoDetails.BuilderImpl clusterInfo) {
            this.clusterInfo = clusterInfo != null ? clusterInfo.build() : null;
        }

        @Override
        public final Builder clusterInfo(AwsMskClusterClusterInfoDetails clusterInfo) {
            this.clusterInfo = clusterInfo;
            return this;
        }

        @Override
        public AwsMskClusterDetails build() {
            return new AwsMskClusterDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
