/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data-volume encryption details. You can't update encryption at rest settings for existing clusters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.Builder, AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails> {
    private static final SdkField<String> DATA_VOLUME_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataVolumeKMSKeyId")
            .getter(getter(AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails::dataVolumeKMSKeyId))
            .setter(setter(Builder::dataVolumeKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataVolumeKMSKeyId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_VOLUME_KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataVolumeKMSKeyId;

    private AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails(BuilderImpl builder) {
        this.dataVolumeKMSKeyId = builder.dataVolumeKMSKeyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key for encrypting data at rest. If you don't specify a KMS key, MSK
     * creates one for you and uses it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key for encrypting data at rest. If you don't specify a KMS
     *         key, MSK creates one for you and uses it.
     */
    public final String dataVolumeKMSKeyId() {
        return dataVolumeKMSKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataVolumeKMSKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails)) {
            return false;
        }
        AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails other = (AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails) obj;
        return Objects.equals(dataVolumeKMSKeyId(), other.dataVolumeKMSKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails")
                .add("DataVolumeKMSKeyId", dataVolumeKMSKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataVolumeKMSKeyId":
            return Optional.ofNullable(clazz.cast(dataVolumeKMSKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataVolumeKMSKeyId", DATA_VOLUME_KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails, T> g) {
        return obj -> g.apply((AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key for encrypting data at rest. If you don't specify a KMS key,
         * MSK creates one for you and uses it.
         * </p>
         * 
         * @param dataVolumeKMSKeyId
         *        The Amazon Resource Name (ARN) of the KMS key for encrypting data at rest. If you don't specify a KMS
         *        key, MSK creates one for you and uses it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataVolumeKMSKeyId(String dataVolumeKMSKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String dataVolumeKMSKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails model) {
            dataVolumeKMSKeyId(model.dataVolumeKMSKeyId);
        }

        public final String getDataVolumeKMSKeyId() {
            return dataVolumeKMSKeyId;
        }

        public final void setDataVolumeKMSKeyId(String dataVolumeKMSKeyId) {
            this.dataVolumeKMSKeyId = dataVolumeKMSKeyId;
        }

        @Override
        public final Builder dataVolumeKMSKeyId(String dataVolumeKMSKeyId) {
            this.dataVolumeKMSKeyId = dataVolumeKMSKeyId;
            return this;
        }

        @Override
        public AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails build() {
            return new AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
