/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details for client authentication using SASL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsMskClusterClusterInfoClientAuthenticationSaslDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsMskClusterClusterInfoClientAuthenticationSaslDetails.Builder, AwsMskClusterClusterInfoClientAuthenticationSaslDetails> {
    private static final SdkField<AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails> IAM_FIELD = SdkField
            .<AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails> builder(MarshallingType.SDK_POJO).memberName("Iam")
            .getter(getter(AwsMskClusterClusterInfoClientAuthenticationSaslDetails::iam)).setter(setter(Builder::iam))
            .constructor(AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iam").build()).build();

    private static final SdkField<AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails> SCRAM_FIELD = SdkField
            .<AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails> builder(MarshallingType.SDK_POJO).memberName("Scram")
            .getter(getter(AwsMskClusterClusterInfoClientAuthenticationSaslDetails::scram)).setter(setter(Builder::scram))
            .constructor(AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scram").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_FIELD, SCRAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails iam;

    private final AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails scram;

    private AwsMskClusterClusterInfoClientAuthenticationSaslDetails(BuilderImpl builder) {
        this.iam = builder.iam;
        this.scram = builder.scram;
    }

    /**
     * <p>
     * Provides details for SASL client authentication using IAM.
     * </p>
     * 
     * @return Provides details for SASL client authentication using IAM.
     */
    public final AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails iam() {
        return iam;
    }

    /**
     * <p>
     * Details for SASL client authentication using SCRAM.
     * </p>
     * 
     * @return Details for SASL client authentication using SCRAM.
     */
    public final AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails scram() {
        return scram;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iam());
        hashCode = 31 * hashCode + Objects.hashCode(scram());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsMskClusterClusterInfoClientAuthenticationSaslDetails)) {
            return false;
        }
        AwsMskClusterClusterInfoClientAuthenticationSaslDetails other = (AwsMskClusterClusterInfoClientAuthenticationSaslDetails) obj;
        return Objects.equals(iam(), other.iam()) && Objects.equals(scram(), other.scram());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsMskClusterClusterInfoClientAuthenticationSaslDetails").add("Iam", iam())
                .add("Scram", scram()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Iam":
            return Optional.ofNullable(clazz.cast(iam()));
        case "Scram":
            return Optional.ofNullable(clazz.cast(scram()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Iam", IAM_FIELD);
        map.put("Scram", SCRAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsMskClusterClusterInfoClientAuthenticationSaslDetails, T> g) {
        return obj -> g.apply((AwsMskClusterClusterInfoClientAuthenticationSaslDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsMskClusterClusterInfoClientAuthenticationSaslDetails> {
        /**
         * <p>
         * Provides details for SASL client authentication using IAM.
         * </p>
         * 
         * @param iam
         *        Provides details for SASL client authentication using IAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iam(AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails iam);

        /**
         * <p>
         * Provides details for SASL client authentication using IAM.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.Builder} avoiding the need to create one
         * manually via {@link AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #iam(AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails)}.
         * 
         * @param iam
         *        a consumer that will call methods on
         *        {@link AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iam(AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails)
         */
        default Builder iam(Consumer<AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.Builder> iam) {
            return iam(AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.builder().applyMutation(iam).build());
        }

        /**
         * <p>
         * Details for SASL client authentication using SCRAM.
         * </p>
         * 
         * @param scram
         *        Details for SASL client authentication using SCRAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scram(AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails scram);

        /**
         * <p>
         * Details for SASL client authentication using SCRAM.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.Builder} avoiding the need to create one
         * manually via {@link AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #scram(AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails)}.
         * 
         * @param scram
         *        a consumer that will call methods on
         *        {@link AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scram(AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails)
         */
        default Builder scram(Consumer<AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.Builder> scram) {
            return scram(AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.builder().applyMutation(scram).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails iam;

        private AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails scram;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsMskClusterClusterInfoClientAuthenticationSaslDetails model) {
            iam(model.iam);
            scram(model.scram);
        }

        public final AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.Builder getIam() {
            return iam != null ? iam.toBuilder() : null;
        }

        public final void setIam(AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails.BuilderImpl iam) {
            this.iam = iam != null ? iam.build() : null;
        }

        @Override
        public final Builder iam(AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails iam) {
            this.iam = iam;
            return this;
        }

        public final AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.Builder getScram() {
            return scram != null ? scram.toBuilder() : null;
        }

        public final void setScram(AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails.BuilderImpl scram) {
            this.scram = scram != null ? scram.build() : null;
        }

        @Override
        public final Builder scram(AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails scram) {
            this.scram = scram;
            return this;
        }

        @Override
        public AwsMskClusterClusterInfoClientAuthenticationSaslDetails build() {
            return new AwsMskClusterClusterInfoClientAuthenticationSaslDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
