/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a Lambda layer version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsLambdaLayerVersionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsLambdaLayerVersionDetails.Builder, AwsLambdaLayerVersionDetails> {
    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Version")
            .getter(getter(AwsLambdaLayerVersionDetails::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<List<String>> COMPATIBLE_RUNTIMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CompatibleRuntimes")
            .getter(getter(AwsLambdaLayerVersionDetails::compatibleRuntimes))
            .setter(setter(Builder::compatibleRuntimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleRuntimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedDate").getter(getter(AwsLambdaLayerVersionDetails::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD,
            COMPATIBLE_RUNTIMES_FIELD, CREATED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long version;

    private final List<String> compatibleRuntimes;

    private final String createdDate;

    private AwsLambdaLayerVersionDetails(BuilderImpl builder) {
        this.version = builder.version;
        this.compatibleRuntimes = builder.compatibleRuntimes;
        this.createdDate = builder.createdDate;
    }

    /**
     * <p>
     * The version number.
     * </p>
     * 
     * @return The version number.
     */
    public final Long version() {
        return version;
    }

    /**
     * For responses, this returns true if the service returned a value for the CompatibleRuntimes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCompatibleRuntimes() {
        return compatibleRuntimes != null && !(compatibleRuntimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The layer's compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function
     * runtimes</a>.
     * </p>
     * <p>
     * The following list includes deprecated runtimes. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime
     * deprecation policy</a> in the <i>Lambda Developer Guide</i>.
     * </p>
     * <p>
     * Array Members: Maximum number of 5 items.
     * </p>
     * <p>
     * Valid Values:
     * <code>nodejs | nodejs4.3 | nodejs6.10 | nodejs8.10 | nodejs10.x | nodejs12.x | nodejs14.x | nodejs16.x | java8 | java8.al2 | java11 | python2.7 | python3.6 | python3.7 | python3.8 | python3.9 | dotnetcore1.0 | dotnetcore2.0 | dotnetcore2.1 | dotnetcore3.1 | dotnet6 | nodejs4.3-edge | go1.x | ruby2.5 | ruby2.7 | provided | provided.al2 | nodejs18.x | python3.10 | java17 | ruby3.2 | python3.11 | nodejs20.x | provided.al2023 | python3.12 | java21</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleRuntimes} method.
     * </p>
     * 
     * @return The layer's compatible <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>.</p>
     *         <p>
     *         The following list includes deprecated runtimes. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime
     *         deprecation policy</a> in the <i>Lambda Developer Guide</i>.
     *         </p>
     *         <p>
     *         Array Members: Maximum number of 5 items.
     *         </p>
     *         <p>
     *         Valid Values:
     *         <code>nodejs | nodejs4.3 | nodejs6.10 | nodejs8.10 | nodejs10.x | nodejs12.x | nodejs14.x | nodejs16.x | java8 | java8.al2 | java11 | python2.7 | python3.6 | python3.7 | python3.8 | python3.9 | dotnetcore1.0 | dotnetcore2.0 | dotnetcore2.1 | dotnetcore3.1 | dotnet6 | nodejs4.3-edge | go1.x | ruby2.5 | ruby2.7 | provided | provided.al2 | nodejs18.x | python3.10 | java17 | ruby3.2 | python3.11 | nodejs20.x | provided.al2023 | python3.12 | java21</code>
     */
    public final List<String> compatibleRuntimes() {
        return compatibleRuntimes;
    }

    /**
     * <p>
     * Indicates when the version was created.
     * </p>
     * <p>
     * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     * </p>
     * 
     * @return Indicates when the version was created.</p>
     *         <p>
     *         For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     */
    public final String createdDate() {
        return createdDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(hasCompatibleRuntimes() ? compatibleRuntimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLambdaLayerVersionDetails)) {
            return false;
        }
        AwsLambdaLayerVersionDetails other = (AwsLambdaLayerVersionDetails) obj;
        return Objects.equals(version(), other.version()) && hasCompatibleRuntimes() == other.hasCompatibleRuntimes()
                && Objects.equals(compatibleRuntimes(), other.compatibleRuntimes())
                && Objects.equals(createdDate(), other.createdDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsLambdaLayerVersionDetails").add("Version", version())
                .add("CompatibleRuntimes", hasCompatibleRuntimes() ? compatibleRuntimes() : null)
                .add("CreatedDate", createdDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "CompatibleRuntimes":
            return Optional.ofNullable(clazz.cast(compatibleRuntimes()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Version", VERSION_FIELD);
        map.put("CompatibleRuntimes", COMPATIBLE_RUNTIMES_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsLambdaLayerVersionDetails, T> g) {
        return obj -> g.apply((AwsLambdaLayerVersionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsLambdaLayerVersionDetails> {
        /**
         * <p>
         * The version number.
         * </p>
         * 
         * @param version
         *        The version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The layer's compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function
         * runtimes</a>.
         * </p>
         * <p>
         * The following list includes deprecated runtimes. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime
         * deprecation policy</a> in the <i>Lambda Developer Guide</i>.
         * </p>
         * <p>
         * Array Members: Maximum number of 5 items.
         * </p>
         * <p>
         * Valid Values:
         * <code>nodejs | nodejs4.3 | nodejs6.10 | nodejs8.10 | nodejs10.x | nodejs12.x | nodejs14.x | nodejs16.x | java8 | java8.al2 | java11 | python2.7 | python3.6 | python3.7 | python3.8 | python3.9 | dotnetcore1.0 | dotnetcore2.0 | dotnetcore2.1 | dotnetcore3.1 | dotnet6 | nodejs4.3-edge | go1.x | ruby2.5 | ruby2.7 | provided | provided.al2 | nodejs18.x | python3.10 | java17 | ruby3.2 | python3.11 | nodejs20.x | provided.al2023 | python3.12 | java21</code>
         * </p>
         * 
         * @param compatibleRuntimes
         *        The layer's compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>.</p>
         *        <p>
         *        The following list includes deprecated runtimes. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy"
         *        >Runtime deprecation policy</a> in the <i>Lambda Developer Guide</i>.
         *        </p>
         *        <p>
         *        Array Members: Maximum number of 5 items.
         *        </p>
         *        <p>
         *        Valid Values:
         *        <code>nodejs | nodejs4.3 | nodejs6.10 | nodejs8.10 | nodejs10.x | nodejs12.x | nodejs14.x | nodejs16.x | java8 | java8.al2 | java11 | python2.7 | python3.6 | python3.7 | python3.8 | python3.9 | dotnetcore1.0 | dotnetcore2.0 | dotnetcore2.1 | dotnetcore3.1 | dotnet6 | nodejs4.3-edge | go1.x | ruby2.5 | ruby2.7 | provided | provided.al2 | nodejs18.x | python3.10 | java17 | ruby3.2 | python3.11 | nodejs20.x | provided.al2023 | python3.12 | java21</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimes(Collection<String> compatibleRuntimes);

        /**
         * <p>
         * The layer's compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function
         * runtimes</a>.
         * </p>
         * <p>
         * The following list includes deprecated runtimes. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime
         * deprecation policy</a> in the <i>Lambda Developer Guide</i>.
         * </p>
         * <p>
         * Array Members: Maximum number of 5 items.
         * </p>
         * <p>
         * Valid Values:
         * <code>nodejs | nodejs4.3 | nodejs6.10 | nodejs8.10 | nodejs10.x | nodejs12.x | nodejs14.x | nodejs16.x | java8 | java8.al2 | java11 | python2.7 | python3.6 | python3.7 | python3.8 | python3.9 | dotnetcore1.0 | dotnetcore2.0 | dotnetcore2.1 | dotnetcore3.1 | dotnet6 | nodejs4.3-edge | go1.x | ruby2.5 | ruby2.7 | provided | provided.al2 | nodejs18.x | python3.10 | java17 | ruby3.2 | python3.11 | nodejs20.x | provided.al2023 | python3.12 | java21</code>
         * </p>
         * 
         * @param compatibleRuntimes
         *        The layer's compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>.</p>
         *        <p>
         *        The following list includes deprecated runtimes. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy"
         *        >Runtime deprecation policy</a> in the <i>Lambda Developer Guide</i>.
         *        </p>
         *        <p>
         *        Array Members: Maximum number of 5 items.
         *        </p>
         *        <p>
         *        Valid Values:
         *        <code>nodejs | nodejs4.3 | nodejs6.10 | nodejs8.10 | nodejs10.x | nodejs12.x | nodejs14.x | nodejs16.x | java8 | java8.al2 | java11 | python2.7 | python3.6 | python3.7 | python3.8 | python3.9 | dotnetcore1.0 | dotnetcore2.0 | dotnetcore2.1 | dotnetcore3.1 | dotnet6 | nodejs4.3-edge | go1.x | ruby2.5 | ruby2.7 | provided | provided.al2 | nodejs18.x | python3.10 | java17 | ruby3.2 | python3.11 | nodejs20.x | provided.al2023 | python3.12 | java21</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimes(String... compatibleRuntimes);

        /**
         * <p>
         * Indicates when the version was created.
         * </p>
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * </p>
         * 
         * @param createdDate
         *        Indicates when the version was created.</p>
         *        <p>
         *        For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         *        href
         *        ="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(String createdDate);
    }

    static final class BuilderImpl implements Builder {
        private Long version;

        private List<String> compatibleRuntimes = DefaultSdkAutoConstructList.getInstance();

        private String createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLambdaLayerVersionDetails model) {
            version(model.version);
            compatibleRuntimes(model.compatibleRuntimes);
            createdDate(model.createdDate);
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getCompatibleRuntimes() {
            if (compatibleRuntimes instanceof SdkAutoConstructList) {
                return null;
            }
            return compatibleRuntimes;
        }

        public final void setCompatibleRuntimes(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = NonEmptyStringListCopier.copy(compatibleRuntimes);
        }

        @Override
        public final Builder compatibleRuntimes(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = NonEmptyStringListCopier.copy(compatibleRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleRuntimes(String... compatibleRuntimes) {
            compatibleRuntimes(Arrays.asList(compatibleRuntimes));
            return this;
        }

        public final String getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @Override
        public AwsLambdaLayerVersionDetails build() {
            return new AwsLambdaLayerVersionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
