/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes which data sources are activated for the detector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsGuardDutyDetectorDataSourcesDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsGuardDutyDetectorDataSourcesDetails.Builder, AwsGuardDutyDetectorDataSourcesDetails> {
    private static final SdkField<AwsGuardDutyDetectorDataSourcesCloudTrailDetails> CLOUD_TRAIL_FIELD = SdkField
            .<AwsGuardDutyDetectorDataSourcesCloudTrailDetails> builder(MarshallingType.SDK_POJO).memberName("CloudTrail")
            .getter(getter(AwsGuardDutyDetectorDataSourcesDetails::cloudTrail)).setter(setter(Builder::cloudTrail))
            .constructor(AwsGuardDutyDetectorDataSourcesCloudTrailDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudTrail").build()).build();

    private static final SdkField<AwsGuardDutyDetectorDataSourcesDnsLogsDetails> DNS_LOGS_FIELD = SdkField
            .<AwsGuardDutyDetectorDataSourcesDnsLogsDetails> builder(MarshallingType.SDK_POJO).memberName("DnsLogs")
            .getter(getter(AwsGuardDutyDetectorDataSourcesDetails::dnsLogs)).setter(setter(Builder::dnsLogs))
            .constructor(AwsGuardDutyDetectorDataSourcesDnsLogsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsLogs").build()).build();

    private static final SdkField<AwsGuardDutyDetectorDataSourcesFlowLogsDetails> FLOW_LOGS_FIELD = SdkField
            .<AwsGuardDutyDetectorDataSourcesFlowLogsDetails> builder(MarshallingType.SDK_POJO).memberName("FlowLogs")
            .getter(getter(AwsGuardDutyDetectorDataSourcesDetails::flowLogs)).setter(setter(Builder::flowLogs))
            .constructor(AwsGuardDutyDetectorDataSourcesFlowLogsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogs").build()).build();

    private static final SdkField<AwsGuardDutyDetectorDataSourcesKubernetesDetails> KUBERNETES_FIELD = SdkField
            .<AwsGuardDutyDetectorDataSourcesKubernetesDetails> builder(MarshallingType.SDK_POJO).memberName("Kubernetes")
            .getter(getter(AwsGuardDutyDetectorDataSourcesDetails::kubernetes)).setter(setter(Builder::kubernetes))
            .constructor(AwsGuardDutyDetectorDataSourcesKubernetesDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Kubernetes").build()).build();

    private static final SdkField<AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails> MALWARE_PROTECTION_FIELD = SdkField
            .<AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails> builder(MarshallingType.SDK_POJO)
            .memberName("MalwareProtection").getter(getter(AwsGuardDutyDetectorDataSourcesDetails::malwareProtection))
            .setter(setter(Builder::malwareProtection))
            .constructor(AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareProtection").build()).build();

    private static final SdkField<AwsGuardDutyDetectorDataSourcesS3LogsDetails> S3_LOGS_FIELD = SdkField
            .<AwsGuardDutyDetectorDataSourcesS3LogsDetails> builder(MarshallingType.SDK_POJO).memberName("S3Logs")
            .getter(getter(AwsGuardDutyDetectorDataSourcesDetails::s3Logs)).setter(setter(Builder::s3Logs))
            .constructor(AwsGuardDutyDetectorDataSourcesS3LogsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Logs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_TRAIL_FIELD,
            DNS_LOGS_FIELD, FLOW_LOGS_FIELD, KUBERNETES_FIELD, MALWARE_PROTECTION_FIELD, S3_LOGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsGuardDutyDetectorDataSourcesCloudTrailDetails cloudTrail;

    private final AwsGuardDutyDetectorDataSourcesDnsLogsDetails dnsLogs;

    private final AwsGuardDutyDetectorDataSourcesFlowLogsDetails flowLogs;

    private final AwsGuardDutyDetectorDataSourcesKubernetesDetails kubernetes;

    private final AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails malwareProtection;

    private final AwsGuardDutyDetectorDataSourcesS3LogsDetails s3Logs;

    private AwsGuardDutyDetectorDataSourcesDetails(BuilderImpl builder) {
        this.cloudTrail = builder.cloudTrail;
        this.dnsLogs = builder.dnsLogs;
        this.flowLogs = builder.flowLogs;
        this.kubernetes = builder.kubernetes;
        this.malwareProtection = builder.malwareProtection;
        this.s3Logs = builder.s3Logs;
    }

    /**
     * <p>
     * An object that contains information on the status of CloudTrail as a data source for the detector.
     * </p>
     * 
     * @return An object that contains information on the status of CloudTrail as a data source for the detector.
     */
    public final AwsGuardDutyDetectorDataSourcesCloudTrailDetails cloudTrail() {
        return cloudTrail;
    }

    /**
     * <p>
     * An object that contains information on the status of DNS logs as a data source for the detector.
     * </p>
     * 
     * @return An object that contains information on the status of DNS logs as a data source for the detector.
     */
    public final AwsGuardDutyDetectorDataSourcesDnsLogsDetails dnsLogs() {
        return dnsLogs;
    }

    /**
     * <p>
     * An object that contains information on the status of VPC Flow Logs as a data source for the detector.
     * </p>
     * 
     * @return An object that contains information on the status of VPC Flow Logs as a data source for the detector.
     */
    public final AwsGuardDutyDetectorDataSourcesFlowLogsDetails flowLogs() {
        return flowLogs;
    }

    /**
     * <p>
     * An object that contains information on the status of Kubernetes data sources for the detector.
     * </p>
     * 
     * @return An object that contains information on the status of Kubernetes data sources for the detector.
     */
    public final AwsGuardDutyDetectorDataSourcesKubernetesDetails kubernetes() {
        return kubernetes;
    }

    /**
     * <p>
     * An object that contains information on the status of Malware Protection as a data source for the detector.
     * </p>
     * 
     * @return An object that contains information on the status of Malware Protection as a data source for the
     *         detector.
     */
    public final AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails malwareProtection() {
        return malwareProtection;
    }

    /**
     * <p>
     * An object that contains information on the status of S3 Data event logs as a data source for the detector.
     * </p>
     * 
     * @return An object that contains information on the status of S3 Data event logs as a data source for the
     *         detector.
     */
    public final AwsGuardDutyDetectorDataSourcesS3LogsDetails s3Logs() {
        return s3Logs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudTrail());
        hashCode = 31 * hashCode + Objects.hashCode(dnsLogs());
        hashCode = 31 * hashCode + Objects.hashCode(flowLogs());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetes());
        hashCode = 31 * hashCode + Objects.hashCode(malwareProtection());
        hashCode = 31 * hashCode + Objects.hashCode(s3Logs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsGuardDutyDetectorDataSourcesDetails)) {
            return false;
        }
        AwsGuardDutyDetectorDataSourcesDetails other = (AwsGuardDutyDetectorDataSourcesDetails) obj;
        return Objects.equals(cloudTrail(), other.cloudTrail()) && Objects.equals(dnsLogs(), other.dnsLogs())
                && Objects.equals(flowLogs(), other.flowLogs()) && Objects.equals(kubernetes(), other.kubernetes())
                && Objects.equals(malwareProtection(), other.malwareProtection()) && Objects.equals(s3Logs(), other.s3Logs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsGuardDutyDetectorDataSourcesDetails").add("CloudTrail", cloudTrail())
                .add("DnsLogs", dnsLogs()).add("FlowLogs", flowLogs()).add("Kubernetes", kubernetes())
                .add("MalwareProtection", malwareProtection()).add("S3Logs", s3Logs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudTrail":
            return Optional.ofNullable(clazz.cast(cloudTrail()));
        case "DnsLogs":
            return Optional.ofNullable(clazz.cast(dnsLogs()));
        case "FlowLogs":
            return Optional.ofNullable(clazz.cast(flowLogs()));
        case "Kubernetes":
            return Optional.ofNullable(clazz.cast(kubernetes()));
        case "MalwareProtection":
            return Optional.ofNullable(clazz.cast(malwareProtection()));
        case "S3Logs":
            return Optional.ofNullable(clazz.cast(s3Logs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CloudTrail", CLOUD_TRAIL_FIELD);
        map.put("DnsLogs", DNS_LOGS_FIELD);
        map.put("FlowLogs", FLOW_LOGS_FIELD);
        map.put("Kubernetes", KUBERNETES_FIELD);
        map.put("MalwareProtection", MALWARE_PROTECTION_FIELD);
        map.put("S3Logs", S3_LOGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsGuardDutyDetectorDataSourcesDetails, T> g) {
        return obj -> g.apply((AwsGuardDutyDetectorDataSourcesDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsGuardDutyDetectorDataSourcesDetails> {
        /**
         * <p>
         * An object that contains information on the status of CloudTrail as a data source for the detector.
         * </p>
         * 
         * @param cloudTrail
         *        An object that contains information on the status of CloudTrail as a data source for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudTrail(AwsGuardDutyDetectorDataSourcesCloudTrailDetails cloudTrail);

        /**
         * <p>
         * An object that contains information on the status of CloudTrail as a data source for the detector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsGuardDutyDetectorDataSourcesCloudTrailDetails.Builder} avoiding the need to create one manually via
         * {@link AwsGuardDutyDetectorDataSourcesCloudTrailDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsGuardDutyDetectorDataSourcesCloudTrailDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #cloudTrail(AwsGuardDutyDetectorDataSourcesCloudTrailDetails)}.
         * 
         * @param cloudTrail
         *        a consumer that will call methods on {@link AwsGuardDutyDetectorDataSourcesCloudTrailDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudTrail(AwsGuardDutyDetectorDataSourcesCloudTrailDetails)
         */
        default Builder cloudTrail(Consumer<AwsGuardDutyDetectorDataSourcesCloudTrailDetails.Builder> cloudTrail) {
            return cloudTrail(AwsGuardDutyDetectorDataSourcesCloudTrailDetails.builder().applyMutation(cloudTrail).build());
        }

        /**
         * <p>
         * An object that contains information on the status of DNS logs as a data source for the detector.
         * </p>
         * 
         * @param dnsLogs
         *        An object that contains information on the status of DNS logs as a data source for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsLogs(AwsGuardDutyDetectorDataSourcesDnsLogsDetails dnsLogs);

        /**
         * <p>
         * An object that contains information on the status of DNS logs as a data source for the detector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsGuardDutyDetectorDataSourcesDnsLogsDetails.Builder} avoiding the need to create one manually via
         * {@link AwsGuardDutyDetectorDataSourcesDnsLogsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsGuardDutyDetectorDataSourcesDnsLogsDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #dnsLogs(AwsGuardDutyDetectorDataSourcesDnsLogsDetails)}.
         * 
         * @param dnsLogs
         *        a consumer that will call methods on {@link AwsGuardDutyDetectorDataSourcesDnsLogsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsLogs(AwsGuardDutyDetectorDataSourcesDnsLogsDetails)
         */
        default Builder dnsLogs(Consumer<AwsGuardDutyDetectorDataSourcesDnsLogsDetails.Builder> dnsLogs) {
            return dnsLogs(AwsGuardDutyDetectorDataSourcesDnsLogsDetails.builder().applyMutation(dnsLogs).build());
        }

        /**
         * <p>
         * An object that contains information on the status of VPC Flow Logs as a data source for the detector.
         * </p>
         * 
         * @param flowLogs
         *        An object that contains information on the status of VPC Flow Logs as a data source for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogs(AwsGuardDutyDetectorDataSourcesFlowLogsDetails flowLogs);

        /**
         * <p>
         * An object that contains information on the status of VPC Flow Logs as a data source for the detector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsGuardDutyDetectorDataSourcesFlowLogsDetails.Builder} avoiding the need to create one manually via
         * {@link AwsGuardDutyDetectorDataSourcesFlowLogsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsGuardDutyDetectorDataSourcesFlowLogsDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #flowLogs(AwsGuardDutyDetectorDataSourcesFlowLogsDetails)}.
         * 
         * @param flowLogs
         *        a consumer that will call methods on {@link AwsGuardDutyDetectorDataSourcesFlowLogsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowLogs(AwsGuardDutyDetectorDataSourcesFlowLogsDetails)
         */
        default Builder flowLogs(Consumer<AwsGuardDutyDetectorDataSourcesFlowLogsDetails.Builder> flowLogs) {
            return flowLogs(AwsGuardDutyDetectorDataSourcesFlowLogsDetails.builder().applyMutation(flowLogs).build());
        }

        /**
         * <p>
         * An object that contains information on the status of Kubernetes data sources for the detector.
         * </p>
         * 
         * @param kubernetes
         *        An object that contains information on the status of Kubernetes data sources for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetes(AwsGuardDutyDetectorDataSourcesKubernetesDetails kubernetes);

        /**
         * <p>
         * An object that contains information on the status of Kubernetes data sources for the detector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsGuardDutyDetectorDataSourcesKubernetesDetails.Builder} avoiding the need to create one manually via
         * {@link AwsGuardDutyDetectorDataSourcesKubernetesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsGuardDutyDetectorDataSourcesKubernetesDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #kubernetes(AwsGuardDutyDetectorDataSourcesKubernetesDetails)}.
         * 
         * @param kubernetes
         *        a consumer that will call methods on {@link AwsGuardDutyDetectorDataSourcesKubernetesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetes(AwsGuardDutyDetectorDataSourcesKubernetesDetails)
         */
        default Builder kubernetes(Consumer<AwsGuardDutyDetectorDataSourcesKubernetesDetails.Builder> kubernetes) {
            return kubernetes(AwsGuardDutyDetectorDataSourcesKubernetesDetails.builder().applyMutation(kubernetes).build());
        }

        /**
         * <p>
         * An object that contains information on the status of Malware Protection as a data source for the detector.
         * </p>
         * 
         * @param malwareProtection
         *        An object that contains information on the status of Malware Protection as a data source for the
         *        detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareProtection(AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails malwareProtection);

        /**
         * <p>
         * An object that contains information on the status of Malware Protection as a data source for the detector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.Builder} avoiding the need to create one
         * manually via {@link AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #malwareProtection(AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails)}.
         * 
         * @param malwareProtection
         *        a consumer that will call methods on
         *        {@link AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malwareProtection(AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails)
         */
        default Builder malwareProtection(
                Consumer<AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.Builder> malwareProtection) {
            return malwareProtection(AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.builder()
                    .applyMutation(malwareProtection).build());
        }

        /**
         * <p>
         * An object that contains information on the status of S3 Data event logs as a data source for the detector.
         * </p>
         * 
         * @param s3Logs
         *        An object that contains information on the status of S3 Data event logs as a data source for the
         *        detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Logs(AwsGuardDutyDetectorDataSourcesS3LogsDetails s3Logs);

        /**
         * <p>
         * An object that contains information on the status of S3 Data event logs as a data source for the detector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsGuardDutyDetectorDataSourcesS3LogsDetails.Builder} avoiding the need to create one manually via
         * {@link AwsGuardDutyDetectorDataSourcesS3LogsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsGuardDutyDetectorDataSourcesS3LogsDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #s3Logs(AwsGuardDutyDetectorDataSourcesS3LogsDetails)}.
         * 
         * @param s3Logs
         *        a consumer that will call methods on {@link AwsGuardDutyDetectorDataSourcesS3LogsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Logs(AwsGuardDutyDetectorDataSourcesS3LogsDetails)
         */
        default Builder s3Logs(Consumer<AwsGuardDutyDetectorDataSourcesS3LogsDetails.Builder> s3Logs) {
            return s3Logs(AwsGuardDutyDetectorDataSourcesS3LogsDetails.builder().applyMutation(s3Logs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsGuardDutyDetectorDataSourcesCloudTrailDetails cloudTrail;

        private AwsGuardDutyDetectorDataSourcesDnsLogsDetails dnsLogs;

        private AwsGuardDutyDetectorDataSourcesFlowLogsDetails flowLogs;

        private AwsGuardDutyDetectorDataSourcesKubernetesDetails kubernetes;

        private AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails malwareProtection;

        private AwsGuardDutyDetectorDataSourcesS3LogsDetails s3Logs;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsGuardDutyDetectorDataSourcesDetails model) {
            cloudTrail(model.cloudTrail);
            dnsLogs(model.dnsLogs);
            flowLogs(model.flowLogs);
            kubernetes(model.kubernetes);
            malwareProtection(model.malwareProtection);
            s3Logs(model.s3Logs);
        }

        public final AwsGuardDutyDetectorDataSourcesCloudTrailDetails.Builder getCloudTrail() {
            return cloudTrail != null ? cloudTrail.toBuilder() : null;
        }

        public final void setCloudTrail(AwsGuardDutyDetectorDataSourcesCloudTrailDetails.BuilderImpl cloudTrail) {
            this.cloudTrail = cloudTrail != null ? cloudTrail.build() : null;
        }

        @Override
        public final Builder cloudTrail(AwsGuardDutyDetectorDataSourcesCloudTrailDetails cloudTrail) {
            this.cloudTrail = cloudTrail;
            return this;
        }

        public final AwsGuardDutyDetectorDataSourcesDnsLogsDetails.Builder getDnsLogs() {
            return dnsLogs != null ? dnsLogs.toBuilder() : null;
        }

        public final void setDnsLogs(AwsGuardDutyDetectorDataSourcesDnsLogsDetails.BuilderImpl dnsLogs) {
            this.dnsLogs = dnsLogs != null ? dnsLogs.build() : null;
        }

        @Override
        public final Builder dnsLogs(AwsGuardDutyDetectorDataSourcesDnsLogsDetails dnsLogs) {
            this.dnsLogs = dnsLogs;
            return this;
        }

        public final AwsGuardDutyDetectorDataSourcesFlowLogsDetails.Builder getFlowLogs() {
            return flowLogs != null ? flowLogs.toBuilder() : null;
        }

        public final void setFlowLogs(AwsGuardDutyDetectorDataSourcesFlowLogsDetails.BuilderImpl flowLogs) {
            this.flowLogs = flowLogs != null ? flowLogs.build() : null;
        }

        @Override
        public final Builder flowLogs(AwsGuardDutyDetectorDataSourcesFlowLogsDetails flowLogs) {
            this.flowLogs = flowLogs;
            return this;
        }

        public final AwsGuardDutyDetectorDataSourcesKubernetesDetails.Builder getKubernetes() {
            return kubernetes != null ? kubernetes.toBuilder() : null;
        }

        public final void setKubernetes(AwsGuardDutyDetectorDataSourcesKubernetesDetails.BuilderImpl kubernetes) {
            this.kubernetes = kubernetes != null ? kubernetes.build() : null;
        }

        @Override
        public final Builder kubernetes(AwsGuardDutyDetectorDataSourcesKubernetesDetails kubernetes) {
            this.kubernetes = kubernetes;
            return this;
        }

        public final AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.Builder getMalwareProtection() {
            return malwareProtection != null ? malwareProtection.toBuilder() : null;
        }

        public final void setMalwareProtection(
                AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.BuilderImpl malwareProtection) {
            this.malwareProtection = malwareProtection != null ? malwareProtection.build() : null;
        }

        @Override
        public final Builder malwareProtection(AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails malwareProtection) {
            this.malwareProtection = malwareProtection;
            return this;
        }

        public final AwsGuardDutyDetectorDataSourcesS3LogsDetails.Builder getS3Logs() {
            return s3Logs != null ? s3Logs.toBuilder() : null;
        }

        public final void setS3Logs(AwsGuardDutyDetectorDataSourcesS3LogsDetails.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        public final Builder s3Logs(AwsGuardDutyDetectorDataSourcesS3LogsDetails s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        @Override
        public AwsGuardDutyDetectorDataSourcesDetails build() {
            return new AwsGuardDutyDetectorDataSourcesDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
