/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Web Services Region that events are routed to when failover is triggered or event replication is enabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.Builder, AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails> {
    private static final SdkField<String> ROUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Route")
            .getter(getter(AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails::route)).setter(setter(Builder::route))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Route").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String route;

    private AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails(BuilderImpl builder) {
        this.route = builder.route;
    }

    /**
     * <p>
     * Defines the secondary Region.
     * </p>
     * 
     * @return Defines the secondary Region.
     */
    public final String route() {
        return route;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(route());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails)) {
            return false;
        }
        AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails other = (AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails) obj;
        return Objects.equals(route(), other.route());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails").add("Route", route()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Route":
            return Optional.ofNullable(clazz.cast(route()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Route", ROUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails, T> g) {
        return obj -> g.apply((AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails> {
        /**
         * <p>
         * Defines the secondary Region.
         * </p>
         * 
         * @param route
         *        Defines the secondary Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder route(String route);
    }

    static final class BuilderImpl implements Builder {
        private String route;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails model) {
            route(model.route);
        }

        public final String getRoute() {
            return route;
        }

        public final void setRoute(String route) {
            this.route = route;
        }

        @Override
        public final Builder route(String route) {
            this.route = route;
            return this;
        }

        @Override
        public AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails build() {
            return new AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
